/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.util;

import java.util.ArrayList;

public class StyleUtils {
    public static final String RTL_CSS_SUFFIX = ":rtl";
    public static final String LTR_CSS_SUFFIX = ":ltr";
    private static final String _DOUBLE_COLON = "::";
    private static final String[] _EMPTY_STRING_ARRAY = new String[0];

    public static String convertToValidSelector(String selector) {
        if (selector == null) {
            return null;
        }
        String[] splitSelector = StyleUtils.splitStringByWhitespace(selector = selector.replace('|', '_'));
        int splitLength = splitSelector.length;
        if (splitLength == 1) {
            return splitSelector[0].replaceFirst(_DOUBLE_COLON, "_");
        }
        for (int i = 0; i < splitLength; ++i) {
            splitSelector[i] = splitSelector[i].replaceFirst(_DOUBLE_COLON, "_");
        }
        return StyleUtils.arrayToStringWithSpaces(splitSelector);
    }

    public static boolean isIcon(String selectorName) {
        if (selectorName == null) {
            return false;
        }
        return selectorName.endsWith("-icon") || selectorName.indexOf("-icon:") > -1 || selectorName.indexOf("Icon:alias") > -1;
    }

    public static String[] splitStringByWhitespace(String selector) {
        int length = selector.length();
        StringBuffer buffer = new StringBuffer(length);
        ArrayList<String> splitList = new ArrayList<String>();
        boolean inWhitespace = false;
        for (int i = 0; i < length; ++i) {
            char c = selector.charAt(i);
            if (Character.isWhitespace(c)) {
                String bufferString;
                if (inWhitespace || (bufferString = buffer.toString()).length() <= 0) continue;
                splitList.add(bufferString);
                buffer = new StringBuffer(length);
                inWhitespace = true;
                continue;
            }
            buffer.append(c);
            if (!inWhitespace) continue;
            inWhitespace = false;
        }
        String lastString = buffer.toString();
        if (lastString.length() > 0) {
            splitList.add(lastString);
        }
        return splitList.toArray(_EMPTY_STRING_ARRAY);
    }

    public static String arrayToStringWithSpaces(String[] stringArray) {
        int length = stringArray.length;
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        int bufferSize = 0;
        for (int i = 0; i < length; ++i) {
            bufferSize += stringArray[i].length() + 1;
        }
        StringBuffer returnString = new StringBuffer(bufferSize);
        for (int i = 0; i < length; ++i) {
            returnString.append(stringArray[i]);
            if (i + 1 >= length) continue;
            returnString.append(' ');
        }
        return returnString.toString();
    }
}

