/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.laf.browser;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;

class MirrorImageFilter
extends ImageFilter {
    private int[] _pixels;
    private int _width;
    private int _height;
    private boolean _done;

    MirrorImageFilter() {
    }

    @Override
    public void setDimensions(int width, int height) {
        if (!this._done) {
            this._width = width;
            this._height = height;
            this._pixels = new int[width * height];
        }
        super.setDimensions(width, height);
    }

    @Override
    public void setPixels(int x, int y, int width, int height, ColorModel model, byte[] pixels, int off, int scansize) {
        if (this._pixels == null) {
            return;
        }
        for (int n = y; n < y + height; ++n) {
            for (int m = x; m < x + width; ++m) {
                byte value = pixels[n * scansize + m + off];
                this._pixels[n * this._width + m] = model.getRGB(value & 0xFF);
            }
        }
    }

    @Override
    public void setPixels(int x, int y, int width, int height, ColorModel model, int[] pixels, int off, int scansize) {
        if (this._pixels == null) {
            return;
        }
        for (int n = y; n < y + height; ++n) {
            for (int m = x; m < x + width; ++m) {
                int value = pixels[n * scansize + m + off];
                this._pixels[n * this._width + m] = model.getRGB(value);
            }
        }
    }

    @Override
    public void imageComplete(int status) {
        int[] pixels = this._pixels;
        if (!this._done && pixels != null && status == 3) {
            int[] scanline = new int[this._width];
            for (int y = 0; y < this._height; ++y) {
                for (int x = 0; x < this._width; ++x) {
                    scanline[this._width - x - 1] = pixels[y * this._width + x];
                }
                super.setPixels(0, y, this._width, 1, ColorModel.getRGBdefault(), scanline, 0, this._width);
            }
            this._pixels = null;
            this._done = true;
        }
        super.imageComplete(status);
    }
}

