/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.resource.RegexResourceLoader;
import org.apache.myfaces.trinidad.resource.ResourceLoader;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidadinternal.resource.CoreClassLoaderResourceLoader;
import org.apache.myfaces.trinidadinternal.resource.CoreCommonScriptsResourceLoader;
import org.apache.myfaces.trinidadinternal.resource.LocaleElementsResourceLoader;

public class CoreRenderKitResourceLoader
extends RegexResourceLoader {
    private static final String _VERSION;
    private static final TrinidadLogger _LOG;

    public CoreRenderKitResourceLoader(ResourceLoader parent) {
        this.register("(/.*/Common.*\\.js)", (ResourceLoader)new CoreCommonScriptsResourceLoader(CoreRenderKitResourceLoader._getCommonLibraryURI(false), false));
        this.register("(/.*/DebugCommon.*\\.js)", (ResourceLoader)new CoreCommonScriptsResourceLoader(CoreRenderKitResourceLoader._getCommonLibraryURI(true), true));
        this.register("(/.*LocaleElements.*\\.js)", (ResourceLoader)new LocaleElementsResourceLoader(CoreRenderKitResourceLoader.getLocaleElementsURI("LocaleElements", true)));
        this.register("(/.*\\.(css|cur|jpg|gif|png|jpeg|svg|js))", (ResourceLoader)new CoreClassLoaderResourceLoader(parent));
    }

    private static String _getCommonLibraryURI(boolean debug) {
        StringBuffer base = new StringBuffer(debug ? "/adf/jsLibs/DebugCommon" : "/adf/jsLibs/Common");
        return base.append(_VERSION).append(".js").toString();
    }

    public static String getLocaleElementsURI(String str, Boolean incVersion) {
        StringBuffer base = new StringBuffer("/adf/jsLibs/resources/");
        base.append(str);
        base.append("_");
        String locStr = CoreRenderKitResourceLoader.getLocale();
        base.append(locStr);
        if (incVersion.booleanValue()) {
            base.append(_VERSION);
        }
        base.append(".js");
        return base.toString();
    }

    public static String getLocale() {
        String path = ((HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest()).getPathInfo();
        String locStr = "";
        int locIndex = path.indexOf("LocaleElements") + "LocaleElements_".length();
        int index = path.indexOf(_VERSION);
        if (index < 0) {
            index = path.indexOf(".js");
        }
        if (index >= 0) {
            locStr = path.substring(locIndex, index);
        }
        return locStr;
    }

    public static String __getVersion() {
        return _VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block11: {
            _LOG = TrinidadLogger.createTrinidadLogger(CoreRenderKitResourceLoader.class);
            String version = "unknown";
            try {
                URL resource = ClassLoaderUtils.getResource((String)"META-INF/trinidad-version.txt");
                if (resource == null) break block11;
                BufferedReader br = null;
                try {
                    InputStream in = resource.openStream();
                    br = new BufferedReader(new InputStreamReader(in));
                    version = br.readLine();
                }
                catch (IOException e) {
                    _LOG.severe((Throwable)e);
                }
                finally {
                    if (br != null) {
                        br.close();
                    }
                }
            }
            catch (IOException e) {
                _LOG.severe((Throwable)e);
            }
            finally {
                _VERSION = version;
            }
        }
    }
}

