/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.uix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.ValueBinding;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.myfaces.trinidad.component.UIXSelectItem;
import org.apache.myfaces.trinidadinternal.convert.ConverterUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectItemSupport {
    private SelectItemSupport() {
    }

    public static List<SelectItem> getSelectItems(UIComponent component, Converter converter) {
        return SelectItemSupport.getSelectItems(component, converter, false);
    }

    public static List<SelectItem> getSelectItems(UIComponent component, Converter converter, boolean filteredItems) {
        int childCount = component.getChildCount();
        if (childCount == 0) {
            return Collections.emptyList();
        }
        if (!(component instanceof ValueHolder)) {
            return Collections.emptyList();
        }
        FacesContext context = FacesContext.getCurrentInstance();
        ArrayList<Object> items = null;
        for (UIComponent child : component.getChildren()) {
            if (child instanceof UISelectItem) {
                if (items == null) {
                    items = new ArrayList<SelectItem>(childCount);
                }
                SelectItemSupport._addSelectItem(context, component, (UISelectItem)child, items, converter);
                continue;
            }
            if (child instanceof UISelectItems) {
                if (items == null) {
                    items = new ArrayList(childCount);
                }
                SelectItemSupport.addSelectItems((UISelectItems)child, items, filteredItems);
                continue;
            }
            if (!(child instanceof UIXSelectItem)) continue;
            if (items == null) {
                items = new ArrayList(childCount);
            }
            SelectItemSupport._addUIXSelectItem(context, component, (UIXSelectItem)child, items, converter);
        }
        if (items == null) {
            return Collections.emptyList();
        }
        return items;
    }

    public static int getSelectItemCount(UIComponent component) {
        int itemCount = 0;
        int childCount = component.getChildCount();
        if (childCount == 0) {
            return itemCount;
        }
        if (!(component instanceof ValueHolder)) {
            return itemCount;
        }
        for (UIComponent child : component.getChildren()) {
            if (child instanceof UISelectItem || child instanceof UIXSelectItem) {
                ++itemCount;
                continue;
            }
            if (!(child instanceof UISelectItems)) continue;
            Object value = ((UISelectItems)child).getValue();
            if (value instanceof SelectItem) {
                ++itemCount;
                continue;
            }
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                itemCount += array.length;
                continue;
            }
            if (value instanceof Collection) {
                itemCount += ((Collection)value).size();
                continue;
            }
            if (!(value instanceof Map)) continue;
            itemCount += ((Map)value).size();
        }
        return itemCount;
    }

    private static void _addSelectItem(FacesContext context, UIComponent component, UISelectItem uiItem, List<SelectItem> items, Converter converter) {
        SelectItem item;
        if (!uiItem.isRendered()) {
            items.add(null);
            return;
        }
        Object value = uiItem.getValue();
        if (value instanceof SelectItem) {
            item = (SelectItem)value;
        } else {
            Object itemValue = uiItem.getItemValue();
            if (converter != null && itemValue instanceof String) {
                itemValue = converter.getAsObject(context, component, (String)itemValue);
            }
            String itemLabel = uiItem.getItemLabel();
            item = new SelectItem(itemValue == null ? "" : itemValue, itemLabel == null ? "" : itemLabel, uiItem.getItemDescription(), uiItem.isItemDisabled());
        }
        items.add(item);
    }

    public static void addSelectItem(UISelectItem uiItem, List<SelectItem> items) {
        SelectItem item;
        Object value = uiItem.getValue();
        if (value instanceof SelectItem) {
            item = (SelectItem)value;
        } else {
            Object itemValue = uiItem.getItemValue();
            String itemLabel = uiItem.getItemLabel();
            item = new SelectItem(itemValue == null ? "" : itemValue, itemLabel == null ? "" : itemLabel, uiItem.getItemDescription(), uiItem.isItemDisabled());
        }
        items.add(item);
    }

    public static void addSelectItems(UISelectItems uiItems, List<SelectItem> items, boolean filteredItems) {
        block8: {
            Object value;
            block10: {
                block9: {
                    block7: {
                        if (!uiItems.isRendered()) {
                            items.add(null);
                            return;
                        }
                        value = uiItems.getValue();
                        if (!(value instanceof SelectItem)) break block7;
                        items.add((SelectItem)value);
                        break block8;
                    }
                    if (!(value instanceof Object[])) break block9;
                    Object[] array = (Object[])value;
                    for (int i = 0; i < array.length; ++i) {
                        if (array[i] instanceof SelectItemGroup && filteredItems) {
                            SelectItemSupport.resolveAndAddItems((SelectItemGroup)array[i], items);
                            continue;
                        }
                        items.add((SelectItem)array[i]);
                    }
                    break block8;
                }
                if (!(value instanceof Collection)) break block10;
                for (SelectItem item : (Collection)value) {
                    if (item instanceof SelectItemGroup && filteredItems) {
                        SelectItemSupport.resolveAndAddItems((SelectItemGroup)item, items);
                        continue;
                    }
                    items.add(item);
                }
                break block8;
            }
            if (!(value instanceof Map)) break block8;
            for (Map.Entry entry : ((Map)value).entrySet()) {
                Object label = entry.getKey();
                SelectItem item = new SelectItem(entry.getValue(), label == null ? (String)null : label.toString());
                if (item instanceof SelectItemGroup && filteredItems) {
                    SelectItemSupport.resolveAndAddItems((SelectItemGroup)item, items);
                    continue;
                }
                items.add(item);
            }
        }
    }

    private static void resolveAndAddItems(SelectItemGroup group, List<SelectItem> items) {
        for (SelectItem item : group.getSelectItems()) {
            if (item instanceof SelectItemGroup) {
                SelectItemSupport.resolveAndAddItems((SelectItemGroup)item, items);
                continue;
            }
            items.add(item);
        }
    }

    private static void _addUIXSelectItem(FacesContext context, UIComponent component, UIXSelectItem uixSelectItem, List<SelectItem> items, Converter converter) {
        if (!uixSelectItem.isRendered()) {
            items.add(null);
            return;
        }
        Object label = uixSelectItem.getAttributes().get("label");
        Object value = uixSelectItem.getValue();
        boolean disabled = Boolean.TRUE.equals(uixSelectItem.getAttributes().get("disabled"));
        Object description = uixSelectItem.getAttributes().get("shortDesc");
        SelectItem selectItem = null;
        if (value instanceof SelectItem) {
            selectItem = (SelectItem)value;
        } else {
            if (converter != null && value instanceof String) {
                value = converter.getAsObject(context, component, (String)value);
            }
            selectItem = new SelectItem(value == null ? "" : value, label == null ? "" : label.toString(), description == null ? "" : (String)description, disabled);
        }
        items.add(selectItem);
    }

    public static Converter getConverter(UIComponent component) {
        Object o;
        FacesContext fContext = FacesContext.getCurrentInstance();
        Converter converter = null;
        Class<List> modelClass = null;
        ValueBinding binding = component.getValueBinding("value");
        if (binding != null && (modelClass = binding.getType(fContext)) == null && (o = binding.getValue(fContext)) != null) {
            modelClass = o.getClass();
        }
        if (modelClass != null && (modelClass.isArray() || modelClass.isAssignableFrom(List.class))) {
            Class<?> itemClass = modelClass.getComponentType();
            if (itemClass != null) {
                converter = ConverterUtils.createConverter(fContext, itemClass);
            }
        } else {
            converter = ConverterUtils.createConverter(fContext, modelClass);
        }
        return converter;
    }
}

