/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.util.Map;
import javax.faces.component.UIComponent;
import org.apache.myfaces.trinidad.component.ChildArrayList;
import org.apache.myfaces.trinidad.util.ArrayMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FacetHashMap
extends ArrayMap<String, UIComponent> {
    private UIComponent _parent;

    public FacetHashMap(UIComponent parent) {
        super(0, 5);
        this._parent = parent;
    }

    @Override
    public void clear() {
        for (UIComponent value : this.values()) {
            value.setParent(null);
        }
        super.clear();
    }

    @Override
    public UIComponent put(String key, UIComponent value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        UIComponent previous = (UIComponent)super.get(key);
        if (previous != null) {
            previous.setParent(null);
        }
        if (value.getParent() != null) {
            ChildArrayList.__removeFromParent(value, -1);
        }
        value.setParent(this._parent);
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends UIComponent> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        for (Map.Entry<? extends String, ? extends UIComponent> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public UIComponent remove(Object key) {
        UIComponent previous = (UIComponent)super.remove(key);
        if (previous != null) {
            previous.setParent(null);
        }
        return previous;
    }
}

