/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.myfaces.trinidadinternal.style.BaseStyle;
import org.apache.myfaces.trinidadinternal.style.PropertyParseException;
import org.apache.myfaces.trinidadinternal.style.Style;
import org.apache.myfaces.trinidadinternal.style.util.CSSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSStyle
extends BaseStyle {
    private transient String _inline;
    private static final String _BACKGROUND_NAME = "background-color";
    private static final String _FOREGROUND_NAME = "color";
    private static final String _FONT_FAMILY_NAME = "font-family";
    private static final String _FONT_SIZE_NAME = "font-size";
    private static final String _FONT_STYLE_NAME = "font-style";
    private static final String _FONT_WEIGHT_NAME = "font-weight";
    private static final String _TEXT_ANTIALIAS_NAME = "text-antialias";
    private static final int _DEFAULT_BUFFER_SIZE = 100;
    private static final long serialVersionUID = 1L;

    public CSSStyle() {
    }

    public CSSStyle(Map<String, String> properties) {
        super(properties);
    }

    public CSSStyle(Style style) {
        super(style);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toInlineString() {
        String inline = this._inline;
        if (inline != null) {
            return inline;
        }
        Iterator<Object> e = this.getPropertyNames();
        StringBuffer buffer = new StringBuffer(100);
        boolean first = true;
        if (e != null) {
            while (e.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(";");
                }
                String name = (String)e.next();
                String value = this.getProperty(name);
                buffer.append(name);
                buffer.append(":");
                buffer.append(value);
            }
        }
        inline = buffer.toString();
        CSSStyle cSSStyle = this;
        synchronized (cSSStyle) {
            this._inline = inline;
        }
        return inline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String name, String value) {
        super.setProperty(name, value);
        CSSStyle cSSStyle = this;
        synchronized (cSSStyle) {
            this._inline = null;
        }
    }

    @Override
    protected Object parseProperty(Object key) throws PropertyParseException {
        String antialiased;
        Object value = null;
        if (key == Style.BACKGROUND_KEY) {
            value = CSSUtils.parseColor(this.getProperty(_BACKGROUND_NAME));
        } else if (key == Style.FOREGROUND_KEY) {
            value = CSSUtils.parseColor(this.getProperty(_FOREGROUND_NAME));
        } else if (key == Style.FONT_SIZE_KEY) {
            value = CSSUtils.parseFontSize(this.getProperty(_FONT_SIZE_NAME));
        } else if (key == Style.FONT_STYLE_KEY) {
            value = CSSUtils.parseFontStyle(this.getProperty(_FONT_STYLE_NAME));
        } else if (key == Style.FONT_WEIGHT_KEY) {
            value = CSSUtils.parseFontWeight(this.getProperty(_FONT_WEIGHT_NAME));
        } else if (key == Style.FONT_FAMILIES_KEY) {
            String[] families = CSSUtils.parseFontFamilies(this.getProperty(_FONT_FAMILY_NAME));
            if (families != null) {
                value = Collections.unmodifiableList(Arrays.asList(families));
            }
        } else if (key == Style.TEXT_ANTIALIAS_KEY && (antialiased = this.getProperty(_TEXT_ANTIALIAS_NAME)) != null && "true".equalsIgnoreCase(antialiased)) {
            value = Boolean.TRUE;
        }
        return value;
    }

    public String toString() {
        return "CSSStyle[css=" + this.toInlineString() + "]";
    }
}

