/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.skin.SkinAddition;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderingContext;
import org.apache.myfaces.trinidadinternal.skin.DocumentProviderSkin;
import org.apache.myfaces.trinidadinternal.skin.SkinUtils;
import org.apache.myfaces.trinidadinternal.skin.icon.NullIcon;
import org.apache.myfaces.trinidadinternal.skin.icon.ReferenceIcon;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.StyleProvider;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestSkinWrapper
extends Skin
implements DocumentProviderSkin {
    private final Skin _skin;
    private Map<String, Icon> _icons;
    private Map<Object, Object> _properties;
    private static final Icon _NULL_ICON = new NullIcon();
    private static final Map<String, Icon> _NULL_ICONS = Collections.emptyMap();
    private static final Map<Object, Object> _NULL_PROPERTIES = Collections.emptyMap();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(RequestSkinWrapper.class);

    public RequestSkinWrapper(Skin wrappedSkin) {
        this._skin = wrappedSkin;
    }

    public Skin getWrappedSkin() {
        return this._skin;
    }

    public String getId() {
        return this._skin.getId();
    }

    public String getFamily() {
        return this._skin.getFamily();
    }

    public String getRenderKitId() {
        return this._skin.getRenderKitId();
    }

    public String getStyleSheetDocumentId(RenderingContext arc) {
        return this._skin.getStyleSheetDocumentId(arc);
    }

    public Map<String, String> getStyleClassMap(RenderingContext arc) {
        return this._skin.getStyleClassMap(arc);
    }

    public String getStyleSheetName() {
        return this._skin.getStyleSheetName();
    }

    public String getTranslatedString(LocaleContext lContext, String key) throws MissingResourceException {
        return this._skin.getTranslatedString(lContext, key);
    }

    public Object getTranslatedValue(LocaleContext lContext, String key) throws MissingResourceException {
        return this._skin.getTranslatedValue(lContext, key);
    }

    public Icon getIcon(String iconName) {
        return this.getIcon(iconName, true);
    }

    public Icon getIcon(String iconName, boolean resolveIcon) {
        Map<String, Icon> icons = this._getRequestIcons();
        assert (icons != null);
        Icon icon = icons.get(iconName);
        if (icon == null) {
            icon = this._skin.getIcon(iconName, false);
            if (resolveIcon) {
                if (icon instanceof ReferenceIcon) {
                    icon = SkinUtils.resolveReferenceIcon(this, (ReferenceIcon)icon);
                }
                this.registerIcon(iconName, icon);
            }
        }
        return icon == _NULL_ICON ? null : icon;
    }

    public void registerIcon(String iconName, Icon icon) {
        Map<String, Icon> icons = this._getRequestIcons();
        if (icons != _NULL_ICONS) {
            icons.put(iconName, icon == null ? _NULL_ICON : icon);
        }
    }

    public Object getProperty(Object key) {
        Map<Object, Object> properties = this._getRequestSkinProperties();
        assert (properties != null);
        Object propertyValue = properties.get(key);
        if (propertyValue == null) {
            propertyValue = this._skin.getProperty(key);
        }
        return propertyValue;
    }

    public void setProperty(Object key, Object value) {
        Map<Object, Object> properties = this._getRequestSkinProperties();
        if (properties != _NULL_PROPERTIES) {
            properties.put(key, value);
        }
    }

    public void registerStyleSheet(String styleSheetName) {
        this._skin.registerStyleSheet(styleSheetName);
    }

    public void addSkinAddition(SkinAddition skinAddition) {
        this._skin.addSkinAddition(skinAddition);
    }

    public List<SkinAddition> getSkinAdditions() {
        return this._skin.getSkinAdditions();
    }

    @Override
    public StyleSheetDocument getStyleSheetDocument(StyleContext styleContext) {
        assert (this._skin instanceof DocumentProviderSkin);
        return ((DocumentProviderSkin)this._skin).getStyleSheetDocument(styleContext);
    }

    private Map<String, Icon> _getRequestIcons() {
        if (this._icons == null) {
            RenderingContext rc = RenderingContext.getCurrentInstance();
            assert (rc instanceof CoreRenderingContext);
            CoreRenderingContext crc = (CoreRenderingContext)rc;
            StyleContext styleContext = crc.getStyleContext();
            StyleProvider styleProvider = styleContext.getStyleProvider();
            this._icons = styleProvider.getIcons(styleContext);
            if (this._icons == null) {
                if (_LOG.isWarning()) {
                    _LOG.warning("_icons is an emptyMap because the skin/style subsystem has failed to initialize.");
                }
                this._icons = _NULL_ICONS;
            }
        }
        return this._icons;
    }

    private Map<Object, Object> _getRequestSkinProperties() {
        if (this._properties == null) {
            RenderingContext rc = RenderingContext.getCurrentInstance();
            assert (rc instanceof CoreRenderingContext);
            CoreRenderingContext crc = (CoreRenderingContext)rc;
            StyleContext styleContext = crc.getStyleContext();
            StyleProvider styleProvider = styleContext.getStyleProvider();
            this._properties = styleProvider.getSkinProperties(styleContext);
            if (this._properties == null) {
                if (_LOG.isWarning()) {
                    _LOG.warning("_properties is an emptyMap because the skin/style subsystem has failed to initialize.");
                }
                this._properties = _NULL_PROPERTIES;
            }
        }
        return this._properties;
    }
}

