/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.data;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.share.data.RequestParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletRequestParameters
extends RequestParameters {
    public static final String HAS_COMPOUND_NAME = "_compNm";
    private static final char _PROPERTY_BOUNDARY = '$';
    private static final String _DOT_X = "$.x";
    private static final String _DOT_Y = "$.y";
    private static final String _COMPOUND_NAME_PREFIX = "_uixcn";
    private static final String _EXCHANGE_PARAM_NAME_PREFIX = "_uixX";
    private static final int _COMPOUND_NAME_PREFIX_LENGTH = "_uixcn".length();
    private Map<String, Object> _params;
    private boolean _cloneArrays;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ServletRequestParameters.class);

    public static Map<String, Object> createRequestMap(Map<String, Object> requestParams) {
        if (requestParams == null) {
            throw new IllegalArgumentException();
        }
        return ServletRequestParameters._processParameters(requestParams, requestParams.size());
    }

    public ServletRequestParameters(Map<String, Object> requestParams) {
        this._params = ServletRequestParameters.createRequestMap(requestParams);
        this._cloneArrays = true;
    }

    public static void decodeCompoundKeyValues(String compoundValue, int startIndex, Map<String, Object> keyValues) {
        int yIndex;
        if (compoundValue == null) {
            return;
        }
        int index = startIndex - 1;
        int endIndex = compoundValue.length();
        int xIndex = compoundValue.lastIndexOf(_DOT_X);
        int xyIndex = Math.max(xIndex, yIndex = compoundValue.lastIndexOf(_DOT_Y));
        if (xyIndex > -1 && compoundValue.substring(xyIndex + 1, endIndex).indexOf(36) < 0) {
            endIndex = xyIndex;
        }
        while (index >= -1) {
            char nextChar;
            boolean fixEscapes = false;
            int nextIndex = compoundValue.indexOf(36, index + 1);
            while (nextIndex > 0 && nextIndex < endIndex - 1 && ((nextChar = compoundValue.charAt(nextIndex + 1)) == '$' || nextChar == '=')) {
                fixEscapes = true;
                nextIndex = compoundValue.indexOf(36, nextIndex + 2);
            }
            if (nextIndex < 0) {
                nextIndex = endIndex;
            }
            int equalsIndex = compoundValue.indexOf(61, index + 1);
            while (equalsIndex > 0 && equalsIndex < nextIndex && compoundValue.charAt(equalsIndex - 1) == '$') {
                equalsIndex = compoundValue.indexOf(61, equalsIndex + 1);
            }
            if (equalsIndex >= nextIndex || equalsIndex < 0) {
                equalsIndex = nextIndex;
            }
            String key = compoundValue.substring(index + 1, equalsIndex);
            String value = equalsIndex == nextIndex ? "" : compoundValue.substring(equalsIndex + 1, nextIndex);
            if (fixEscapes) {
                key = ServletRequestParameters._decodeEscapes(key);
                value = ServletRequestParameters._decodeEscapes(value);
            }
            key = ServletRequestParameters._decodeChars(key);
            value = ServletRequestParameters._decodeChars(value);
            keyValues.put(key, new String[]{value});
            if (nextIndex >= endIndex) break;
            index = nextIndex;
        }
    }

    public static String encodeCompoundKeyValues(String namePrefix, Iterator<Object> keyValues, int keyValueSize) {
        return ServletRequestParameters.encodeCompoundKeyValues(namePrefix, keyValues, keyValueSize, null, null, 0);
    }

    public static String encodeCompoundKeyValues(String namePrefix, Iterator<Object> keyValues, int keyValueSize, String exchangePrefix, Iterator<Object> keyExchanges, int keyExchangesSize) {
        int prefixSize = namePrefix != null ? namePrefix.length() * 2 : 0;
        int exchangePrefixSize = exchangePrefix != null ? exchangePrefix.length() : 0;
        int totalSize = prefixSize + keyValueSize + exchangePrefixSize + keyExchangesSize;
        StringBuffer compoundValue = new StringBuffer(totalSize);
        if (prefixSize > 0) {
            compoundValue.append(namePrefix);
        }
        if (keyExchanges != null && keyExchanges.hasNext()) {
            ServletRequestParameters._encodeIterator(keyExchanges, compoundValue, exchangePrefix);
            ServletRequestParameters._encodeIterator(keyValues, compoundValue, namePrefix);
        } else {
            ServletRequestParameters._encodeIterator(keyValues, compoundValue, null);
        }
        if (compoundValue.length() > prefixSize) {
            return compoundValue.toString();
        }
        return null;
    }

    public static String encodeCompoundKeyValues(Iterator<Object> keyValues, int keyValueSize) {
        return ServletRequestParameters.encodeCompoundKeyValues(_COMPOUND_NAME_PREFIX, keyValues, keyValueSize);
    }

    public static String encodeCompoundKeyValues(Iterator<Object> keyValues, int keyValueSize, Iterator<Object> keyExchanges, int keyExchangesSize) {
        return ServletRequestParameters.encodeCompoundKeyValues(_COMPOUND_NAME_PREFIX, keyValues, keyValueSize, _EXCHANGE_PARAM_NAME_PREFIX, keyExchanges, keyExchangesSize);
    }

    @Override
    public String getParameter(String name) {
        Object param = this._params.get(name);
        if (param instanceof String[]) {
            return ((String[])param)[0];
        }
        return (String)param;
    }

    @Override
    public Iterator<String> getParameterNames() {
        return this._params.keySet().iterator();
    }

    @Override
    public String[] getParameterValues(String name) {
        Object param = this._params.get(name);
        if (param instanceof String[]) {
            String[] paramArr = (String[])param;
            if (this._cloneArrays) {
                return (String[])paramArr.clone();
            }
            return paramArr;
        }
        return new String[]{(String)param};
    }

    private static Map<String, Object> _processParameters(Map<String, Object> requestParams, int dictionarySize) {
        boolean hasCompoundName;
        boolean bl = hasCompoundName = requestParams.get(HAS_COMPOUND_NAME) != null;
        if (hasCompoundName) {
            Hashtable<String, Object> params = new Hashtable<String, Object>((int)((double)dictionarySize * 1.5));
            HashMap<String, String> keyExchangeMap = new HashMap<String, String>();
            Iterator<String> paramNames = requestParams.keySet().iterator();
            if (paramNames != null) {
                while (paramNames.hasNext()) {
                    String currName = paramNames.next();
                    boolean putValue = true;
                    if (hasCompoundName) {
                        if (HAS_COMPOUND_NAME.equals(currName)) {
                            putValue = false;
                        } else if (currName.startsWith(_COMPOUND_NAME_PREFIX) && currName.indexOf(61) != -1) {
                            int fromIndex = currName.indexOf(_EXCHANGE_PARAM_NAME_PREFIX);
                            if (fromIndex < 0) {
                                fromIndex = _COMPOUND_NAME_PREFIX_LENGTH;
                            } else {
                                int toIndex = 0;
                                int endIndex = currName.indexOf(_COMPOUND_NAME_PREFIX, fromIndex);
                                fromIndex += _EXCHANGE_PARAM_NAME_PREFIX.length();
                                while (fromIndex < endIndex) {
                                    toIndex = currName.indexOf(61, fromIndex);
                                    String oldKey = currName.substring(fromIndex, toIndex);
                                    fromIndex = toIndex + 1;
                                    toIndex = currName.indexOf(36, fromIndex);
                                    String newKey = currName.substring(fromIndex, toIndex);
                                    fromIndex = toIndex + 1;
                                    keyExchangeMap.put(oldKey, newKey);
                                }
                                fromIndex = endIndex + _COMPOUND_NAME_PREFIX_LENGTH;
                            }
                            ServletRequestParameters.decodeCompoundKeyValues(currName, fromIndex, params);
                            putValue = false;
                        }
                    }
                    if (!putValue) continue;
                    params.put(currName, requestParams.get(currName));
                }
            }
            for (String oldKey : keyExchangeMap.keySet()) {
                Object value = params.get(oldKey);
                if (value == null) continue;
                String newKey = (String)keyExchangeMap.get(oldKey);
                params.put(newKey, value);
            }
            return params;
        }
        return requestParams;
    }

    private static void _encodeIterator(Iterator<Object> keyValues, StringBuffer compoundValue, String prefix) {
        boolean needsPropSeparator = false;
        if (keyValues != null && keyValues.hasNext()) {
            try {
                if (prefix != null) {
                    compoundValue.append(prefix);
                }
                do {
                    Object key;
                    if ((key = keyValues.next()) != null) {
                        if (needsPropSeparator) {
                            compoundValue.append('$');
                            needsPropSeparator = false;
                        }
                        ServletRequestParameters._encodeChars(compoundValue, key.toString());
                        compoundValue.append('=');
                        Object value = keyValues.next();
                        if (value != null) {
                            ServletRequestParameters._encodeChars(compoundValue, value.toString());
                        }
                        needsPropSeparator = true;
                        continue;
                    }
                    keyValues.next();
                } while (keyValues.hasNext());
                compoundValue.append('$');
            }
            catch (NoSuchElementException e) {
                throw new IllegalArgumentException(_LOG.getMessage("KEYS_AND_VALUES_MUST_MATCH"));
            }
        }
    }

    private static String _decodeEscapes(String string) {
        int length = string.length();
        StringBuffer buffer = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c == '$') {
                if (++i >= length) break;
                c = string.charAt(i);
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static String _encodeChars(StringBuffer buffer, String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '%' || c == '$' || c == '=' || c == ' ') {
                buffer.append('%');
                buffer.append(ServletRequestParameters._toHex(c >> 4 & 0xF));
                buffer.append(ServletRequestParameters._toHex(c & 0xF));
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static char _toHex(int fourBits) {
        if (fourBits < 10) {
            return (char)(48 + fourBits);
        }
        return (char)(65 + (fourBits - 10));
    }

    private static String _decodeChars(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(37) < 0) {
            return s;
        }
        StringBuffer buffer = new StringBuffer(s.length());
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '%') {
                int digit = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                buffer.append((char)digit);
                i += 2;
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }
}

