/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.ppr;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.context.RequestContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialPageContextImpl
extends PartialPageContext {
    private Map<String, Boolean> _targets = new HashMap<String, Boolean>();
    private Set<String> _renderedTargets = new HashSet<String>();
    private Stack<String> _currentTargetStack = new Stack();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(PartialPageContextImpl.class);

    PartialPageContextImpl() {
    }

    public PartialPageContextImpl(RequestContext reqContext) {
        this();
        RequestContextImpl requestContext = (RequestContextImpl)reqContext;
        Iterator<String> targetIter = requestContext.getPartialTargets();
        while (targetIter.hasNext()) {
            this._targets.put(targetIter.next(), Boolean.FALSE);
        }
        if (this._targets.isEmpty()) {
            _LOG.fine("PPR is about to render without any targets");
        }
    }

    public Iterator<String> getPartialTargets() {
        return this._targets.keySet().iterator();
    }

    public boolean isPartialTarget(String id) {
        return id != null && this._targets.containsKey(id);
    }

    public boolean isPartialTargetRendered(String id) {
        return this._renderedTargets.contains(id);
    }

    public void addPartialTarget(String id) {
        this._targets.put(id, Boolean.FALSE);
    }

    public boolean isInsidePartialTarget() {
        return this._getCurrentPartialTarget() != null;
    }

    public void addRenderedPartialTarget(String id) {
        this._renderedTargets.add(id);
    }

    public Iterator<String> getRenderedPartialTargets() {
        return this._renderedTargets.iterator();
    }

    public void pushRenderedPartialTarget(String id) {
        if (_LOG.isFine() && !this._targets.containsKey(id)) {
            _LOG.fine("Rendering partial target {0}, which was not requested", (Object)id);
        }
        this._targets.put(id, Boolean.TRUE);
        this._currentTargetStack.push(id);
        if (_LOG.isFiner()) {
            _LOG.finer("Pushed rendered PPR target " + id);
        }
    }

    public void popRenderedPartialTarget() {
        this._currentTargetStack.pop();
    }

    private String _getCurrentPartialTarget() {
        if (this._currentTargetStack.empty()) {
            return null;
        }
        return this._currentTargetStack.peek();
    }
}

