/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.custom.tree.HtmlTreeNode;
import org.apache.myfaces.custom.tree.IconProvider;
import org.apache.myfaces.custom.tree.event.TreeSelectionEvent;
import org.apache.myfaces.custom.tree.event.TreeSelectionListener;
import org.apache.myfaces.custom.tree.model.TreeModel;
import org.apache.myfaces.custom.tree.model.TreeModelEvent;
import org.apache.myfaces.custom.tree.model.TreeModelListener;
import org.apache.myfaces.custom.tree.model.TreePath;

public class HtmlTree
extends HtmlPanelGroup
implements TreeModelListener {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlTree";
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.HtmlTree";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.HtmlTree";
    public static final long DEFAULT_EXPIRE_LISTENERS = 28800000L;
    private static final String FACET_ROOTNODE = "rootNode";
    private static final String PREVIOUS_VIEW_ROOT = HtmlTree.class.getName() + ".PREVIOUS_VIEW_ROOT";
    private static final int EVENT_CHANGED = 0;
    private static final int EVENT_INSERTED = 1;
    private static final int EVENT_REMOVED = 2;
    private static final int EVENT_STRUCTURE_CHANGED = 3;
    private static int counter = 0;
    private IconProvider iconProvider;
    private boolean itemStatesRestored = false;
    private String var;
    private String nodeClass;
    private String rowClasses;
    private String columnClasses;
    private String selectedNodeClass;
    private String iconClass;
    private String iconLine;
    private String iconNoline;
    private String iconChildFirst;
    private String iconChildMiddle;
    private String iconChildLast;
    private String iconNodeOpen;
    private String iconNodeOpenFirst;
    private String iconNodeOpenMiddle;
    private String iconNodeOpenLast;
    private String iconNodeClose;
    private String iconNodeCloseFirst;
    private String iconNodeCloseMiddle;
    private String iconNodeCloseLast;
    private int uniqueIdCounter = 0;
    private int[] selectedPath;
    private int internalId = counter++;
    private Long expireListeners;

    public TreeModel getModel(FacesContext context) {
        TreeModel model;
        ValueBinding binding = this.getValueBinding("model");
        if (binding != null && (model = (TreeModel)binding.getValue(context)) != null) {
            return model;
        }
        return null;
    }

    public String createUniqueId(FacesContext context) {
        return this.getClientId(context).replaceAll(":", "_") + "_node_" + this.uniqueIdCounter++;
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.addFacesListener(listener);
    }

    public IconProvider getIconProvider() {
        return this.iconProvider;
    }

    public void setIconProvider(IconProvider iconProvider) {
        this.iconProvider = iconProvider;
    }

    public String getVar() {
        return this.getStringValue(this.var, "var");
    }

    public void setVar(String var) {
        this.var = var;
    }

    protected String getStringValue(String value, String vbName) {
        Object obj;
        if (value != null) {
            return value;
        }
        ValueBinding vb = this.getValueBinding(vbName);
        if (vb != null && (obj = vb.getValue(this.getFacesContext())) != null) {
            return obj.toString();
        }
        return null;
    }

    public String getIconLine() {
        return this.getStringValue(this.iconLine, "iconLine");
    }

    public void setIconLine(String iconLine) {
        this.iconLine = iconLine;
    }

    public String getIconNoline() {
        return this.getStringValue(this.iconNoline, "iconNoline");
    }

    public void setIconNoline(String iconNoline) {
        this.iconNoline = iconNoline;
    }

    public String getIconChildFirst() {
        return this.getStringValue(this.iconChildFirst, "iconChildFirst");
    }

    public void setIconChildFirst(String iconChildFirst) {
        this.iconChildFirst = iconChildFirst;
    }

    public String getIconChildMiddle() {
        return this.getStringValue(this.iconChildMiddle, "iconChildMiddle");
    }

    public void setIconChildMiddle(String iconChildMiddle) {
        this.iconChildMiddle = iconChildMiddle;
    }

    public String getIconChildLast() {
        return this.getStringValue(this.iconChildLast, "iconChildLast");
    }

    public void setIconChildLast(String iconChildLast) {
        this.iconChildLast = iconChildLast;
    }

    public String getIconNodeOpen() {
        return this.getStringValue(this.iconNodeOpen, "iconNodeOpen");
    }

    public void setIconNodeOpen(String iconNodeOpen) {
        this.iconNodeOpen = iconNodeOpen;
    }

    public String getIconNodeOpenFirst() {
        return this.getStringValue(this.iconNodeOpenFirst, "iconNodeOpenFirst");
    }

    public void setIconNodeOpenFirst(String iconNodeOpenFirst) {
        this.iconNodeOpenFirst = iconNodeOpenFirst;
    }

    public String getIconNodeOpenMiddle() {
        return this.getStringValue(this.iconNodeOpenMiddle, "iconNodeOpenMiddle");
    }

    public void setIconNodeOpenMiddle(String iconNodeOpenMiddle) {
        this.iconNodeOpenMiddle = iconNodeOpenMiddle;
    }

    public String getIconNodeOpenLast() {
        return this.getStringValue(this.iconNodeOpenLast, "iconNodeOpenLast");
    }

    public void setIconNodeOpenLast(String iconNodeOpenLast) {
        this.iconNodeOpenLast = iconNodeOpenLast;
    }

    public String getIconNodeClose() {
        return this.getStringValue(this.iconNodeClose, "iconNodeClose");
    }

    public void setIconNodeClose(String iconNodeClose) {
        this.iconNodeClose = iconNodeClose;
    }

    public String getIconNodeCloseFirst() {
        return this.getStringValue(this.iconNodeCloseFirst, "iconNodeCloseFirst");
    }

    public void setIconNodeCloseFirst(String iconNodeCloseFirst) {
        this.iconNodeCloseFirst = iconNodeCloseFirst;
    }

    public String getIconNodeCloseMiddle() {
        return this.getStringValue(this.iconNodeCloseMiddle, "iconNodeCloseMiddle");
    }

    public void setIconNodeCloseMiddle(String iconNodeCloseMiddle) {
        this.iconNodeCloseMiddle = iconNodeCloseMiddle;
    }

    public String getIconNodeCloseLast() {
        return this.getStringValue(this.iconNodeCloseLast, "iconNodeCloseLast");
    }

    public void setIconNodeCloseLast(String iconNodeCloseLast) {
        this.iconNodeCloseLast = iconNodeCloseLast;
    }

    public String getNodeClass() {
        return this.getStringValue(this.nodeClass, "nodeClass");
    }

    public void setNodeClass(String nodeClass) {
        this.nodeClass = nodeClass;
    }

    public String getRowClasses() {
        return this.getStringValue(this.rowClasses, "rowClasses");
    }

    public void setRowClasses(String rowClasses) {
        this.rowClasses = rowClasses;
    }

    public String getColumnClasses() {
        return this.getStringValue(this.columnClasses, "columnClasses");
    }

    public void setColumnClasses(String columnClasses) {
        this.columnClasses = columnClasses;
    }

    public String getSelectedNodeClass() {
        return this.getStringValue(this.selectedNodeClass, "selectedNodeClass");
    }

    public void setSelectedNodeClass(String selectedNodeClass) {
        this.selectedNodeClass = selectedNodeClass;
    }

    public String getIconClass() {
        return this.getStringValue(this.iconClass, "iconClass");
    }

    public void setIconClass(String iconClass) {
        this.iconClass = iconClass;
    }

    public long getExpireListeners() {
        Object obj;
        if (this.expireListeners != null) {
            return this.expireListeners;
        }
        ValueBinding vb = this.getValueBinding("expireListeners");
        if (vb != null && (obj = vb.getValue(this.getFacesContext())) instanceof Number) {
            return ((Number)obj).longValue();
        }
        return 28800000L;
    }

    public void setExpireListeners(long expireListeners) {
        this.expireListeners = new Long(expireListeners);
    }

    public String getFamily() {
        return "org.apache.myfaces.HtmlTree";
    }

    public void expandPath(TreePath path, FacesContext context) {
        TreeModel model = this.getModel(context);
        if (path != null && model != null && !model.isLeaf(path.getLastPathComponent())) {
            int[] translatedPath = HtmlTreeNode.translatePath(path, this.getModel(context));
            HtmlTreeNode rootNode = this.getRootNode();
            if (rootNode == null) {
                this.createRootNode(context);
                rootNode = this.getRootNode();
            }
            if (!rootNode.isExpanded()) {
                rootNode.setExpanded(true);
            }
            rootNode.expandPath(translatedPath, 0);
        }
    }

    public void collapsePath(TreePath path, FacesContext context) {
        HtmlTreeNode node = this.findNode(path, context);
        if (node != null) {
            node.setExpanded(false);
        }
    }

    public boolean isExpanded(TreePath path, FacesContext context) {
        if (path == null) {
            return false;
        }
        return this.findNode(path, context) != null;
    }

    private HtmlTreeNode findNode(TreePath path, FacesContext context) {
        HtmlTreeNode node = this.getRootNode();
        int[] translatedPath = HtmlTreeNode.translatePath(path, this.getModel(context));
        for (int i = 0; i < translatedPath.length; ++i) {
            if (!node.isExpanded()) {
                return null;
            }
            int index = translatedPath[i];
            node = (HtmlTreeNode)((Object)node.getChildren().get(index));
        }
        return node;
    }

    public TreePath getSelectionPath() {
        if (this.selectedPath == null) {
            return null;
        }
        return HtmlTreeNode.translatePath(this.selectedPath, this.getModel(FacesContext.getCurrentInstance()));
    }

    public void selectionChanged(HtmlTreeNode node) {
        TreePath oldPath = null;
        if (this.selectedPath != null) {
            oldPath = HtmlTreeNode.translatePath(this.selectedPath, this.getModel(FacesContext.getCurrentInstance()));
        }
        this.selectedPath = node.getTranslatedPath();
        if (node.isSelected()) {
            this.queueEvent(new TreeSelectionEvent((UIComponent)this, oldPath, node.getPath()));
        } else {
            this.queueEvent(new TreeSelectionEvent((UIComponent)this, oldPath, null));
        }
    }

    private void createRootNode(FacesContext context) {
        TreeModel model = this.getModel(context);
        Object root = model.getRoot();
        HtmlTreeNode node = (HtmlTreeNode)context.getApplication().createComponent("org.apache.myfaces.HtmlTreeNode");
        String id = this.createUniqueId(context);
        node.setId(id);
        node.setPath(new TreePath(new Object[]{root}));
        node.setUserObject(root);
        node.setLayout(new int[]{13});
        this.getFacets().put(FACET_ROOTNODE, node);
    }

    public HtmlTreeNode getRootNode() {
        return (HtmlTreeNode)this.getFacet(FACET_ROOTNODE);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.iconChildFirst, this.iconChildMiddle, this.iconChildLast, this.iconLine, this.iconNodeClose, this.iconNodeCloseFirst, this.iconNodeCloseLast, this.iconNodeCloseMiddle, this.iconNodeOpen, this.iconNodeOpenFirst, this.iconNodeOpenLast, this.iconNodeOpenMiddle, this.iconNoline, this.var, this.nodeClass, this.selectedNodeClass, new Integer(this.uniqueIdCounter), this.selectedPath, this.iconClass, new Integer(this.internalId), this.expireListeners, this.rowClasses, this.columnClasses};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.iconChildFirst = (String)values[1];
        this.iconChildMiddle = (String)values[2];
        this.iconChildLast = (String)values[3];
        this.iconLine = (String)values[4];
        this.iconNodeClose = (String)values[5];
        this.iconNodeCloseFirst = (String)values[6];
        this.iconNodeCloseLast = (String)values[7];
        this.iconNodeCloseMiddle = (String)values[8];
        this.iconNodeOpen = (String)values[9];
        this.iconNodeOpenFirst = (String)values[10];
        this.iconNodeOpenLast = (String)values[11];
        this.iconNodeOpenMiddle = (String)values[12];
        this.iconNoline = (String)values[13];
        this.var = (String)values[14];
        this.nodeClass = (String)values[15];
        this.selectedNodeClass = (String)values[16];
        this.uniqueIdCounter = (Integer)values[17];
        this.selectedPath = (int[])values[18];
        this.iconClass = (String)values[19];
        this.internalId = (Integer)values[20];
        this.expireListeners = (Long)values[21];
        this.rowClasses = (String)values[22];
        this.columnClasses = (String)values[23];
        this.addToModelListeners();
    }

    public void decode(FacesContext context) {
        super.decode(context);
        context.getExternalContext().getRequestMap().put(PREVIOUS_VIEW_ROOT, context.getViewRoot());
        this.itemStatesRestored = true;
    }

    public void processDecodes(FacesContext context) {
        this.addToModelListeners();
        super.processDecodes(context);
    }

    public void processValidators(FacesContext context) {
        this.addToModelListeners();
        super.processValidators(context);
    }

    public void processUpdates(FacesContext context) {
        this.addToModelListeners();
        super.processUpdates(context);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        UIViewRoot previousRoot;
        this.addToModelListeners();
        this.processModelEvents();
        HtmlTreeNode node = this.getRootNode();
        if (node == null) {
            this.createRootNode(context);
        }
        if (!this.itemStatesRestored && (previousRoot = (UIViewRoot)context.getExternalContext().getRequestMap().get(PREVIOUS_VIEW_ROOT)) != null) {
            this.restoreItemStates(context, previousRoot);
        }
        super.encodeBegin(context);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
    }

    public void restoreItemStates(FacesContext facesContext, UIViewRoot previousRoot) {
        HtmlTree previousTree = (HtmlTree)previousRoot.findComponent(this.getClientId(facesContext));
        if (previousTree != null) {
            HtmlTreeNode node = previousTree.getRootNode();
            if (node != null) {
                this.getRootNode().restoreItemState(node);
            }
            this.selectedPath = previousTree.selectedPath;
        }
    }

    public void treeNodesChanged(TreeModelEvent e) {
        FacesContext context;
        TreePath path = e.getTreePath();
        HtmlTreeNode node = this.findNode(path, context = FacesContext.getCurrentInstance());
        if (node != null) {
            node.childrenChanged(e.getChildIndices(), context);
        }
    }

    public void treeNodesInserted(TreeModelEvent e) {
        FacesContext context;
        TreePath path = e.getTreePath();
        HtmlTreeNode node = this.findNode(path, context = FacesContext.getCurrentInstance());
        if (node != null) {
            node.childrenAdded(e.getChildIndices(), context);
        }
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        FacesContext context;
        TreePath path = e.getTreePath();
        HtmlTreeNode node = this.findNode(path, context = FacesContext.getCurrentInstance());
        if (node != null) {
            node.childrenRemoved(e.getChildIndices());
        }
    }

    public void treeStructureChanged(TreeModelEvent e) {
        FacesContext context;
        TreePath path = e.getTreePath();
        if (this.isExpanded(path, context = FacesContext.getCurrentInstance())) {
            this.collapsePath(path, context);
            this.expandPath(path, context);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HtmlTree)) {
            return false;
        }
        HtmlTree other = (HtmlTree)obj;
        return other.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getClientId(FacesContext.getCurrentInstance()).hashCode();
    }

    public void addToModelListeners() {
        Collection listeners = this.getModel(FacesContext.getCurrentInstance()).getTreeModelListeners();
        long currentTime = System.currentTimeMillis();
        boolean found = false;
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            ModelListener listener = (ModelListener)iterator.next();
            if (listener.getId() == this.internalId) {
                found = true;
                continue;
            }
            if (currentTime - listener.getLastAccessTime() <= this.getExpireListeners()) continue;
            iterator.remove();
        }
        if (!found) {
            listeners.add(new ModelListener(this.internalId));
        }
    }

    private void processModelEvents() {
        Collection listeners = this.getModel(FacesContext.getCurrentInstance()).getTreeModelListeners();
        for (ModelListener listener : listeners) {
            if (listener.getId() != this.internalId) continue;
            Iterator events = listener.getEvents().iterator();
            while (events.hasNext()) {
                Event event = (Event)events.next();
                event.process(this);
                events.remove();
            }
            break block0;
        }
    }

    public void collapseAll() {
        HtmlTreeNode root = this.getRootNode();
        FacesContext context = FacesContext.getCurrentInstance();
        this.collapsePath(root.getPath(), context);
        for (int i = 0; i < root.getChildren().size(); ++i) {
            HtmlTreeNode child = (HtmlTreeNode)((Object)root.getChildren().get(i));
            this.collapsePath(child.getPath(), context);
            if (child.isLeaf(context)) continue;
            this.collapseChildren(context, child);
        }
    }

    private void collapseChildren(FacesContext context, HtmlTreeNode parent) {
        for (int i = 0; i < parent.getChildren().size(); ++i) {
            HtmlTreeNode child = (HtmlTreeNode)((Object)parent.getChildren().get(i));
            this.collapsePath(child.getPath(), context);
            if (child.isLeaf(context)) continue;
            this.collapseChildren(context, child);
        }
    }

    public void expandAll() {
        HtmlTreeNode root = this.getRootNode();
        FacesContext context = FacesContext.getCurrentInstance();
        this.expandPath(root.getPath(), context);
        for (int i = 0; i < root.getChildren().size(); ++i) {
            HtmlTreeNode child = (HtmlTreeNode)((Object)root.getChildren().get(i));
            this.expandPath(child.getPath(), context);
            if (child.isLeaf(context)) continue;
            this.expandChildren(context, child);
        }
    }

    private void expandChildren(FacesContext context, HtmlTreeNode parent) {
        for (int i = 0; i < parent.getChildren().size(); ++i) {
            HtmlTreeNode child = (HtmlTreeNode)((Object)parent.getChildren().get(i));
            this.expandPath(child.getPath(), context);
            if (child.isLeaf(context)) continue;
            this.expandChildren(context, child);
        }
    }

    private static class Event {
        private int kind;
        private TreeModelEvent event;

        public Event(int kind, TreeModelEvent event) {
            this.kind = kind;
            this.event = event;
        }

        public void process(HtmlTree tree) {
            switch (this.kind) {
                case 0: {
                    tree.treeNodesChanged(this.event);
                    break;
                }
                case 1: {
                    tree.treeNodesInserted(this.event);
                    break;
                }
                case 2: {
                    tree.treeNodesRemoved(this.event);
                    break;
                }
                case 3: {
                    tree.treeStructureChanged(this.event);
                }
            }
        }
    }

    private static class ModelListener
    implements TreeModelListener,
    Serializable {
        private long lastAccessTime = System.currentTimeMillis();
        private LinkedList events = new LinkedList();
        int id;

        public ModelListener(int id) {
            this.id = id;
        }

        public List getEvents() {
            this.lastAccessTime = System.currentTimeMillis();
            return this.events;
        }

        public int getId() {
            return this.id;
        }

        public long getLastAccessTime() {
            return this.lastAccessTime;
        }

        public void treeNodesChanged(TreeModelEvent e) {
            this.events.addLast(new Event(0, e));
        }

        public void treeNodesInserted(TreeModelEvent e) {
            this.events.addLast(new Event(1, e));
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            this.events.addLast(new Event(2, e));
        }

        public void treeStructureChanged(TreeModelEvent e) {
            this.events.addLast(new Event(3, e));
        }
    }
}

