/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.ext;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectOne;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.custom.radio.HtmlRadio;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRadioRendererBase;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.util.JavascriptUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlRadioRenderer
extends HtmlRadioRendererBase {
    private static final String LAYOUT_SPREAD = "spread";
    private static final String[] LABEL_STYLES = new String[]{"labelStyle", "labelStyleClass"};

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        if (component instanceof HtmlRadio) {
            this.renderRadio(context, (HtmlRadio)component);
        } else if (HtmlRendererUtils.isDisplayValueOnly(component)) {
            HtmlRendererUtils.renderDisplayValueOnlyForSelects(context, component);
        } else if (component instanceof UISelectOne) {
            String layout = this.getLayout(component);
            if (layout != null && layout.equals(LAYOUT_SPREAD)) {
                return;
            }
            super.encodeEnd(context, component);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    protected void renderRadio(FacesContext facesContext, HtmlRadio radio) throws IOException {
        Converter converter;
        String forAttr = radio.getFor();
        if (forAttr == null) {
            throw new IllegalStateException("mandatory attribute 'for'");
        }
        int index = radio.getIndex();
        if (index < 0) {
            throw new IllegalStateException("positive index must be given");
        }
        UIComponent uiComponent = radio.findComponent(forAttr);
        if (uiComponent == null) {
            throw new IllegalStateException("Could not find component '" + forAttr + "' (calling findComponent on component '" + radio.getClientId(facesContext) + "')");
        }
        if (!(uiComponent instanceof UISelectOne)) {
            throw new IllegalStateException("UISelectOne expected");
        }
        UISelectOne uiSelectOne = (UISelectOne)uiComponent;
        List selectItemList = RendererUtils.getSelectItemList(uiSelectOne);
        if (index >= selectItemList.size()) {
            throw new IndexOutOfBoundsException("index " + index + " >= " + selectItemList.size());
        }
        try {
            converter = RendererUtils.findUIOutputConverter(facesContext, (UIOutput)uiSelectOne);
        }
        catch (FacesException e) {
            converter = null;
        }
        Object currentValue = RendererUtils.getObjectValue((UIComponent)uiSelectOne);
        currentValue = RendererUtils.getConvertedStringValue(facesContext, (UIComponent)uiSelectOne, converter, currentValue);
        SelectItem selectItem = (SelectItem)selectItemList.get(index);
        String itemStrValue = RendererUtils.getConvertedStringValue(facesContext, (UIComponent)uiSelectOne, converter, selectItem.getValue());
        ResponseWriter writer = facesContext.getResponseWriter();
        String itemId = this.renderRadio(facesContext, uiSelectOne, radio, itemStrValue, selectItem.isDisabled(), itemStrValue.equals(currentValue), false, index);
        boolean componentDisabled = this.isDisabled(facesContext, (UIComponent)uiSelectOne);
        boolean itemDisabled = selectItem.isDisabled();
        boolean disabled = componentDisabled || itemDisabled;
        HtmlRadioRenderer.renderLabel(writer, (UIComponent)radio, (UIComponent)uiSelectOne, itemId, selectItem, disabled);
    }

    protected String renderRadio(FacesContext facesContext, UISelectOne uiComponent, HtmlRadio radio, String value, boolean disabled, boolean checked, boolean renderId, Integer itemNum) throws IOException {
        String clientId = uiComponent.getClientId(facesContext);
        String itemId = radio.isRenderLogicalId() ? clientId + UINamingContainer.getSeparatorChar((FacesContext)facesContext) + itemNum : radio.getClientId(facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", (UIComponent)uiComponent);
        writer.writeAttribute("id", (Object)itemId, null);
        writer.writeAttribute("type", (Object)"radio", null);
        writer.writeAttribute("name", (Object)clientId, null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        Map behaviors = null;
        if (uiComponent instanceof ClientBehaviorHolder && JavascriptUtils.isJavascriptAllowed(facesContext.getExternalContext())) {
            behaviors = ((ClientBehaviorHolder)uiComponent).getClientBehaviors();
            HtmlRadioRenderer.renderBehaviorizedOnchangeEventHandler(facesContext, writer, (UIComponent)radio, (UIComponent)uiComponent, itemId, behaviors);
            HtmlRadioRenderer.renderBehaviorizedEventHandlers(facesContext, writer, (UIComponent)radio, (UIComponent)uiComponent, itemId, behaviors);
            HtmlRadioRenderer.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, (UIComponent)radio, (UIComponent)uiComponent, itemId, behaviors);
            HtmlRadioRenderer.renderHTMLAttributes(writer, (UIComponent)radio, (UIComponent)uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);
        } else {
            HtmlRadioRenderer.renderHTMLAttributes(writer, (UIComponent)radio, (UIComponent)uiComponent, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        }
        if (this.isDisabled(facesContext, (UIComponent)uiComponent)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        writer.endElement("input");
        return itemId;
    }

    public static void renderLabel(ResponseWriter writer, UIComponent radio, UIComponent component, String forClientId, SelectItem item, boolean disabled) throws IOException {
        writer.startElement("label", component);
        writer.writeAttribute("for", (Object)forClientId, null);
        String labelClass = null;
        if (disabled) {
            labelClass = (String)radio.getAttributes().get("disabledClass");
            if (labelClass == null) {
                labelClass = (String)component.getAttributes().get("disabledClass");
            }
        } else {
            labelClass = (String)radio.getAttributes().get("enabledClass");
            if (labelClass == null) {
                labelClass = (String)component.getAttributes().get("enabledClass");
            }
        }
        if (labelClass != null) {
            writer.writeAttribute("class", (Object)labelClass, "labelClass");
        }
        if (item.getLabel() != null && item.getLabel().length() > 0) {
            writer.write(" ");
            if (item.isEscape()) {
                writer.writeText((Object)item.getLabel(), null);
            } else {
                writer.write(item.getLabel());
            }
        }
        writer.endElement("label");
    }

    private static boolean renderHTMLAttributes(ResponseWriter writer, UIComponent radio, UIComponent selectOne, String[] attributes) throws IOException {
        boolean somethingDone = false;
        for (String attrName : attributes) {
            Object value = radio.getAttributes().get(attrName);
            if (value == null) {
                value = selectOne.getAttributes().get(attrName);
            }
            if (!HtmlRendererUtils.renderHTMLAttribute(writer, attrName, attrName, value)) continue;
            somethingDone = true;
        }
        return somethingDone;
    }

    private static boolean renderBehaviorizedOnchangeEventHandler(FacesContext facesContext, ResponseWriter writer, UIComponent radio, UIComponent uiComponent, String targetClientId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        boolean hasChange = HtmlRendererUtils.hasClientBehavior("change", clientBehaviors, facesContext);
        boolean hasValueChange = HtmlRendererUtils.hasClientBehavior("valueChange", clientBehaviors, facesContext);
        String value = (String)radio.getAttributes().get("onchange");
        if (value == null) {
            value = (String)uiComponent.getAttributes().get("onchange");
        }
        if (hasChange && hasValueChange) {
            String chain = HtmlRendererUtils.buildBehaviorChain(facesContext, uiComponent, targetClientId, "change", null, "valueChange", null, clientBehaviors, value, null);
            return HtmlRendererUtils.renderHTMLAttribute(writer, "onchange", "onchange", (Object)chain);
        }
        if (hasChange) {
            return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onchange", uiComponent, targetClientId, "change", null, clientBehaviors, "onchange", value);
        }
        if (hasValueChange) {
            return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, "onchange", uiComponent, targetClientId, "valueChange", null, clientBehaviors, "onchange", value);
        }
        return HtmlRendererUtils.renderHTMLAttribute(writer, "onchange", "onchange", (Object)value);
    }

    private static void renderBehaviorizedEventHandlers(FacesContext facesContext, ResponseWriter writer, UIComponent radio, UIComponent uiComponent, String targetClientId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        HtmlRadioRenderer.renderBehaviorizedAttribute(facesContext, writer, "onclick", radio, uiComponent, targetClientId, "click", clientBehaviors, "onclick");
        HtmlRadioRenderer.renderBehaviorizedAttribute(facesContext, writer, "ondblclick", radio, uiComponent, targetClientId, "dblclick", clientBehaviors, "ondblclick");
        HtmlRadioRenderer.renderBehaviorizedAttribute(facesContext, writer, "onmousedown", radio, uiComponent, targetClientId, "mousedown", clientBehaviors, "onmousedown");
        HtmlRadioRenderer.renderBehaviorizedAttribute(facesContext, writer, "onmouseup", radio, uiComponent, targetClientId, "mouseup", clientBehaviors, "onmouseup");
        HtmlRadioRenderer.renderBehaviorizedAttribute(facesContext, writer, "onmouseover", radio, uiComponent, targetClientId, "mouseover", clientBehaviors, "onmouseover");
        HtmlRadioRenderer.renderBehaviorizedAttribute(facesContext, writer, "onmousemove", radio, uiComponent, targetClientId, "mousemove", clientBehaviors, "onmousemove");
        HtmlRadioRenderer.renderBehaviorizedAttribute(facesContext, writer, "onmouseout", radio, uiComponent, targetClientId, "mouseout", clientBehaviors, "onmouseout");
        HtmlRadioRenderer.renderBehaviorizedAttribute(facesContext, writer, "onkeypress", radio, uiComponent, targetClientId, "keypress", clientBehaviors, "onkeypress");
        HtmlRadioRenderer.renderBehaviorizedAttribute(facesContext, writer, "onkeydown", radio, uiComponent, targetClientId, "keydown", clientBehaviors, "onkeydown");
        HtmlRadioRenderer.renderBehaviorizedAttribute(facesContext, writer, "onkeyup", radio, uiComponent, targetClientId, "keyup", clientBehaviors, "onkeyup");
    }

    private static void renderBehaviorizedFieldEventHandlersWithoutOnchange(FacesContext facesContext, ResponseWriter writer, UIComponent radio, UIComponent uiComponent, String targetClientId, Map<String, List<ClientBehavior>> clientBehaviors) throws IOException {
        HtmlRadioRenderer.renderBehaviorizedAttribute(facesContext, writer, "onfocus", radio, uiComponent, targetClientId, "focus", clientBehaviors, "onfocus");
        HtmlRadioRenderer.renderBehaviorizedAttribute(facesContext, writer, "onblur", radio, uiComponent, targetClientId, "blur", clientBehaviors, "onblur");
        HtmlRadioRenderer.renderBehaviorizedAttribute(facesContext, writer, "onselect", radio, uiComponent, targetClientId, "select", clientBehaviors, "onselect");
    }

    private static boolean renderBehaviorizedAttribute(FacesContext facesContext, ResponseWriter writer, String componentProperty, UIComponent radio, UIComponent component, String targetClientId, String eventName, Map<String, List<ClientBehavior>> clientBehaviors, String htmlAttrName) throws IOException {
        String attributeValue = (String)radio.getAttributes().get(componentProperty);
        if (attributeValue == null) {
            attributeValue = (String)component.getAttributes().get(componentProperty);
        }
        return HtmlRendererUtils.renderBehaviorizedAttribute(facesContext, writer, componentProperty, component, targetClientId, eventName, null, clientBehaviors, htmlAttrName, attributeValue);
    }

    @Override
    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (!UserRoleUtils.isEnabledOnUserRole(uiComponent)) {
            return true;
        }
        return super.isDisabled(facesContext, uiComponent);
    }

    @Override
    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        if (uiComponent instanceof HtmlRadio) {
            List clientBehaviorList;
            Map paramMap;
            String behaviorEventName;
            ClientBehaviorHolder clientBehaviorHolder;
            Map clientBehaviors;
            HtmlRadio radio = (HtmlRadio)uiComponent;
            String forAttr = radio.getFor();
            if (forAttr == null) {
                throw new IllegalStateException("mandatory attribute 'for'");
            }
            int index = radio.getIndex();
            if (index < 0) {
                throw new IllegalStateException("positive index must be given");
            }
            UIComponent uiSelectOne = radio.findComponent(forAttr);
            if (uiSelectOne == null) {
                throw new IllegalStateException("Could not find component '" + forAttr + "' (calling findComponent on component '" + radio.getClientId(facesContext) + "')");
            }
            if (!(uiSelectOne instanceof UISelectOne)) {
                throw new IllegalStateException("UISelectOne expected");
            }
            if (uiSelectOne instanceof ClientBehaviorHolder && (clientBehaviors = (clientBehaviorHolder = (ClientBehaviorHolder)uiSelectOne).getClientBehaviors()) != null && !clientBehaviors.isEmpty() && (behaviorEventName = (String)(paramMap = facesContext.getExternalContext().getRequestParameterMap()).get("javax.faces.behavior.event")) != null && (clientBehaviorList = (List)clientBehaviors.get(behaviorEventName)) != null && !clientBehaviorList.isEmpty()) {
                String clientId = (String)paramMap.get("javax.faces.source");
                if (radio.getClientId().equals(clientId)) {
                    for (ClientBehavior clientBehavior : clientBehaviorList) {
                        clientBehavior.decode(facesContext, (UIComponent)radio);
                    }
                }
            }
        } else {
            super.decode(facesContext, uiComponent);
        }
    }
}

