/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.selectitems;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;

public abstract class AbstractUISelectItems
extends UISelectItems {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.UISelectItems";

    public abstract String getVar();

    public abstract Object getItemLabel();

    public abstract Object getItemValue();

    public abstract Object getItemLabelEscaped();

    public abstract Object getItemDescription();

    public abstract Object getItemDisabled();

    public abstract boolean isUseEntryAsItem();

    public Object getValue() {
        Object value = super.getValue();
        String var = this.getVar();
        if (var != null && var.length() > 0) {
            return this.createSelectItems(value);
        }
        return value;
    }

    private SelectItem[] createSelectItems(Object value) {
        ArrayList<SelectItem> items;
        block9: {
            block8: {
                items = new ArrayList<SelectItem>();
                if (value instanceof SelectItem[]) {
                    return (SelectItem[])value;
                }
                if (!(value instanceof Collection)) break block8;
                Collection collection = (Collection)value;
                for (Object currentItem : collection) {
                    if (currentItem instanceof SelectItemGroup) {
                        SelectItemGroup itemGroup = (SelectItemGroup)currentItem;
                        SelectItem[] itemsFromGroup = itemGroup.getSelectItems();
                        for (int i = 0; i < itemsFromGroup.length; ++i) {
                            items.add(itemsFromGroup[i]);
                        }
                        continue;
                    }
                    this.putIteratorToRequestParam(currentItem);
                    SelectItem selectItem = this.createSelectItem();
                    this.removeIteratorFromRequestParam();
                    items.add(selectItem);
                }
                break block9;
            }
            if (!(value instanceof Map)) break block9;
            Map map = (Map)value;
            if (this.isUseEntryAsItem()) {
                for (Map.Entry currentItem : map.entrySet()) {
                    this.putIteratorToRequestParam(currentItem);
                    SelectItem selectItem = this.createSelectItem();
                    this.removeIteratorFromRequestParam();
                    items.add(selectItem);
                }
            } else {
                for (Map.Entry currentItem : map.entrySet()) {
                    this.putIteratorToRequestParam(currentItem.getValue());
                    SelectItem selectItem = this.createSelectItem();
                    this.removeIteratorFromRequestParam();
                    items.add(selectItem);
                }
            }
        }
        return items.toArray(new SelectItem[0]);
    }

    private SelectItem createSelectItem() {
        SelectItem item = null;
        Object value = this.getItemValue();
        String label = this.getItemLabel() != null ? this.getItemLabel().toString() : null;
        String description = this.getItemDescription() != null ? this.getItemDescription().toString() : null;
        Boolean disabled = (Boolean)(this.getItemDisabled() != null ? this.getItemDisabled() : Boolean.FALSE);
        Boolean escaped = (Boolean)(this.getItemLabelEscaped() != null ? this.getItemLabelEscaped() : Boolean.TRUE);
        item = label != null ? new SelectItem(value, label, description, disabled.booleanValue(), escaped.booleanValue()) : new SelectItem(value, value == null ? null : value.toString(), description, disabled.booleanValue(), escaped.booleanValue());
        return item;
    }

    private void putIteratorToRequestParam(Object object) {
        FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(this.getVar(), object);
    }

    private void removeIteratorFromRequestParam() {
        FacesContext.getCurrentInstance().getExternalContext().getRequestMap().remove(this.getVar());
    }
}

