/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.calendar;

import javax.faces.component.UIComponent;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import org.apache.myfaces.custom.calendar.AbstractHtmlInputCalendar;
import org.apache.myfaces.custom.calendar.DateBusinessConverter;
import org.apache.myfaces.shared_tomahawk.util.ClassUtils;

public class HtmlInputCalendarTagHandler
extends ComponentHandler {
    public HtmlInputCalendarTagHandler(ComponentConfig config) {
        super(config);
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        MetaRuleset m = super.createMetaRuleset(type).alias("class", "styleClass");
        m.addRule((MetaRule)DateBusinessConverterRule.INSTANCE);
        return m;
    }

    public static class DateBusinessConverterRule
    extends MetaRule {
        public static final DateBusinessConverterRule INSTANCE = new DateBusinessConverterRule();

        public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
            if (meta.isTargetInstanceOf(AbstractHtmlInputCalendar.class) && "dateBusinessConverter".equals(name)) {
                if (attribute.isLiteral()) {
                    return new LiteralConverterMetadata(attribute.getValue());
                }
                return new DynamicConverterMetadata(attribute);
            }
            return null;
        }

        static final class DynamicConverterMetadata
        extends Metadata {
            private final TagAttribute attr;

            public DynamicConverterMetadata(TagAttribute attr) {
                this.attr = attr;
            }

            public void applyMetadata(FaceletContext ctx, Object instance) {
                ((UIComponent)instance).setValueExpression("dateBusinessConverter", this.attr.getValueExpression(ctx, DateBusinessConverter.class));
            }
        }

        static final class LiteralConverterMetadata
        extends Metadata {
            private final Class dateBusinessConverterClass;

            public LiteralConverterMetadata(String dateBusinessConverterClass) {
                try {
                    this.dateBusinessConverterClass = ClassUtils.classForName(dateBusinessConverterClass);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Class referenced in calendarConverter not found: " + dateBusinessConverterClass);
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Class referenced in calendarConverter is not instance of org.apache.myfaces.custom.calendar.CalendarConverter: " + dateBusinessConverterClass);
                }
            }

            public void applyMetadata(FaceletContext ctx, Object instance) {
                ((AbstractHtmlInputCalendar)instance).setDateBusinessConverter((DateBusinessConverter)ClassUtils.newInstance(this.dateBusinessConverterClass));
            }
        }
    }
}

