/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp.filter;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.webapp.filter.servlet.ServletChacheFileSizeErrorsFileUpload;

public class MultipartRequestWrapper
extends HttpServletRequestWrapper {
    private static Log log = LogFactory.getLog((Class)MultipartRequestWrapper.class);
    public static final String UPLOADED_FILES_ATTRIBUTE = "org.apache.myfaces.uploadedFiles";
    public static final String WWW_FORM_URLENCODED_TYPE = "application/x-www-form-urlencoded";
    HttpServletRequest request = null;
    HashMap parametersMap = null;
    ServletFileUpload fileUpload = null;
    HashMap fileItems = null;
    long maxFileSize;
    long maxSize;
    int thresholdSize;
    String repositoryPath;
    boolean cacheFileSizeErrors;

    public MultipartRequestWrapper(HttpServletRequest request, int maxFileSize, int thresholdSize, String repositoryPath) {
        super(request);
        this.request = request;
        this.maxFileSize = maxFileSize;
        this.thresholdSize = thresholdSize;
        this.repositoryPath = repositoryPath;
        this.maxSize = maxFileSize;
        this.cacheFileSizeErrors = false;
    }

    public MultipartRequestWrapper(HttpServletRequest request, int maxFileSize, int thresholdSize, String repositoryPath, int maxRequestSize, boolean cacheFileSizeErrors) {
        super(request);
        this.request = request;
        this.maxFileSize = maxFileSize;
        this.maxSize = maxRequestSize;
        this.thresholdSize = thresholdSize;
        this.repositoryPath = repositoryPath;
        this.cacheFileSizeErrors = cacheFileSizeErrors;
    }

    public MultipartRequestWrapper(HttpServletRequest request, long maxFileSize, int thresholdSize, String repositoryPath) {
        super(request);
        this.request = request;
        this.maxFileSize = maxFileSize;
        this.thresholdSize = thresholdSize;
        this.repositoryPath = repositoryPath;
        this.maxSize = maxFileSize;
        this.cacheFileSizeErrors = false;
    }

    public MultipartRequestWrapper(HttpServletRequest request, long maxFileSize, int thresholdSize, String repositoryPath, long maxRequestSize, boolean cacheFileSizeErrors) {
        super(request);
        this.request = request;
        this.maxFileSize = maxFileSize;
        this.maxSize = maxRequestSize;
        this.thresholdSize = thresholdSize;
        this.repositoryPath = repositoryPath;
        this.cacheFileSizeErrors = cacheFileSizeErrors;
    }

    private void parseRequest() {
        this.fileUpload = this.cacheFileSizeErrors ? new ServletChacheFileSizeErrorsFileUpload() : new ServletFileUpload();
        this.fileUpload.setSizeMax(this.maxSize);
        this.fileUpload.setFileSizeMax(this.maxFileSize);
        if (this.repositoryPath != null && this.repositoryPath.trim().length() > 0) {
            this.fileUpload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory(this.thresholdSize, new File(this.repositoryPath)));
        } else {
            this.fileUpload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory(this.thresholdSize, new File(System.getProperty("java.io.tmpdir"))));
        }
        String charset = this.request.getCharacterEncoding();
        this.fileUpload.setHeaderEncoding(charset);
        List requestParameters = null;
        try {
            requestParameters = this.cacheFileSizeErrors ? ((ServletChacheFileSizeErrorsFileUpload)this.fileUpload).parseRequestCatchingFileSizeErrors(this.request, (FileUpload)this.fileUpload) : this.fileUpload.parseRequest(this.request);
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            this.request.setAttribute("org.apache.myfaces.custom.fileupload.exception", (Object)"fileSizeLimitExceeded");
            this.request.setAttribute("org.apache.myfaces.custom.fileupload.maxSize", (Object)new Integer((int)this.maxFileSize));
            if (log.isWarnEnabled()) {
                log.warn((Object)"FileSizeLimitExceededException while uploading file.", (Throwable)e);
            }
            requestParameters = Collections.EMPTY_LIST;
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            this.request.setAttribute("org.apache.myfaces.custom.fileupload.exception", (Object)"sizeLimitExceeded");
            this.request.setAttribute("org.apache.myfaces.custom.fileupload.maxSize", (Object)new Integer((int)this.maxSize));
            if (log.isWarnEnabled()) {
                log.warn((Object)"SizeLimitExceededException while uploading file.", (Throwable)e);
            }
            requestParameters = Collections.EMPTY_LIST;
        }
        catch (FileUploadException fue) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Exception while uploading file.", (Throwable)fue);
            }
            requestParameters = Collections.EMPTY_LIST;
        }
        this.parametersMap = new HashMap(requestParameters.size());
        this.fileItems = new HashMap();
        Iterator iter = requestParameters.iterator();
        while (iter.hasNext()) {
            FileItem fileItem = (FileItem)iter.next();
            if (fileItem.isFormField()) {
                String name = fileItem.getFieldName();
                String value = null;
                if (charset == null) {
                    value = fileItem.getString();
                } else {
                    try {
                        value = new String(fileItem.get(), charset);
                    }
                    catch (UnsupportedEncodingException e) {
                        value = fileItem.getString();
                    }
                }
                this.addTextParameter(name, value);
                continue;
            }
            if (fileItem.getName() == null) continue;
            this.fileItems.put(fileItem.getFieldName(), fileItem);
        }
    }

    private void addTextParameter(String name, String value) {
        if (!this.parametersMap.containsKey(name)) {
            String[] valuesArray = new String[]{value};
            this.parametersMap.put(name, valuesArray);
        } else {
            String[] storedValues = (String[])this.parametersMap.get(name);
            int lengthSrc = storedValues.length;
            String[] valuesArray = new String[lengthSrc + 1];
            System.arraycopy(storedValues, 0, valuesArray, 0, lengthSrc);
            valuesArray[lengthSrc] = value;
            this.parametersMap.put(name, valuesArray);
        }
    }

    public Enumeration getParameterNames() {
        if (this.parametersMap == null) {
            this.parseRequest();
        }
        HashSet mergedNames = new HashSet(this.request.getParameterMap().keySet());
        mergedNames.addAll(this.parametersMap.keySet());
        return Collections.enumeration(mergedNames);
    }

    public String getParameter(String name) {
        String[] values;
        if (this.parametersMap == null) {
            this.parseRequest();
        }
        if ((values = (String[])this.parametersMap.get(name)) != null) {
            return values[0];
        }
        if (this.parametersMap.containsKey(name)) {
            return null;
        }
        return this.request.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        String[] values;
        if (this.parametersMap == null) {
            this.parseRequest();
        }
        if ((values = (String[])this.parametersMap.get(name)) != null) {
            return values;
        }
        if (this.parametersMap.containsKey(name)) {
            return null;
        }
        return this.request.getParameterValues(name);
    }

    public Map getParameterMap() {
        if (this.parametersMap == null) {
            this.parseRequest();
        }
        HashMap mergedMap = new HashMap(this.request.getParameterMap());
        mergedMap.putAll(this.parametersMap);
        return mergedMap;
    }

    public FileItem getFileItem(String fieldName) {
        if (this.fileItems == null) {
            this.parseRequest();
        }
        return (FileItem)this.fileItems.get(fieldName);
    }

    public Map getFileItems() {
        if (this.fileItems == null) {
            this.parseRequest();
        }
        return this.fileItems;
    }

    public Object getAttribute(String string) {
        if (string.equals(UPLOADED_FILES_ATTRIBUTE)) {
            return this.getFileItems();
        }
        return super.getAttribute(string);
    }

    public String getContentType() {
        return WWW_FORM_URLENCODED_TYPE;
    }
}

