/* Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

package org.apache.myfaces.portlet.faces.testsuite.tests.chapter_5.section_5_2;

import java.io.IOException;

import java.io.PrintWriter;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import javax.portlet.faces.BridgeInvalidViewPathException;
import javax.portlet.faces.BridgeUninitializedException;
import javax.portlet.faces.GenericFacesPortlet;

import org.apache.myfaces.portlet.faces.testsuite.annotation.BridgeTest;
import org.apache.myfaces.portlet.faces.testsuite.common.Constants;
import org.apache.myfaces.portlet.faces.testsuite.common.portlet.GenericFacesTestSuitePortlet;
import org.apache.myfaces.portlet.faces.testsuite.common.util.BridgeTCKResultWriter;

public class ManualBridgeInvokePortlet
  extends GenericFacesTestSuitePortlet
{
  private static final String EXCEPTIONTHROWN_NODEFAULTVIEWID_TEST = "exceptionThrownWhenNoDefaultViewIdTest";
  private static final String VIEWIDWITHPARAM_TEST = "viewIdWithParam_1_Test";
  private static final String FACESCONTEXTRELEASED_ACTION_TEST = "facesContextReleasedActionTest";
  private static final String PORTLETPHASEREMOVED_ACTION_TEST = "portletPhaseRemovedActionTest";
  private static final String FACESCONTEXTRELEASED_RENDER_TEST = "facesContextReleasedRenderTest";
  private static final String PORTLETPHASEREMOVED_RENDER_TEST = "portletPhaseRemovedRenderTest";
  private static final String BRIDGESETSCONTENTTYPE_TEST = "bridgeSetsContentTypeTest";


  public void init(PortletConfig config)
    throws PortletException
  {
    super.init(config);

  }
  
  public void processAction(ActionRequest request, ActionResponse response) throws
    PortletException, PortletSecurityException, IOException
  {
    super.processAction(request, response);
    if (getTestName().equals(FACESCONTEXTRELEASED_ACTION_TEST))
    {
      if (request.getPortletSession(true).getAttribute("org.apache.portlet.faces.tck.facesContextReleased") != null)
      {
        request.getPortletSession().setAttribute("org.apache.portlet.faces.tck.testResult", Boolean.TRUE);
        request.getPortletSession().setAttribute("org.apache.portlet.faces.tck.testDetail", "Correctly released FacesContext at end of doFacesRequest (action).");
        request.getPortletSession().removeAttribute("org.apache.portlet.faces.tck.facesContextReleased");
      }
      else
      {
        request.getPortletSession().setAttribute("org.apache.portlet.faces.tck.testResult", Boolean.FALSE);
        request.getPortletSession().setAttribute("org.apache.portlet.faces.tck.testDetail", "Didn't release FacesContext at end of doFacesRequest (action).");        
      }
      
    }
    else if (getTestName().equals(PORTLETPHASEREMOVED_ACTION_TEST))
    {
      if (request.getAttribute(Bridge.PORTLET_LIFECYCLE_PHASE) == null)
      {
        request.getPortletSession(true).setAttribute("org.apache.portlet.faces.tck.testResult", Boolean.TRUE);
        request.getPortletSession().setAttribute("org.apache.portlet.faces.tck.testDetail", "Correctly removed PortletPhase attrbiute at end of doFacesRequest (action).");
      }
      else
      {
        request.getPortletSession(true).setAttribute("org.apache.portlet.faces.tck.testResult", Boolean.FALSE);
        request.getPortletSession().setAttribute("org.apache.portlet.faces.tck.testDetail", "Didn't removed PortletPhase attrbiute at end of doFacesRequest (action).");        
      }
    }
  }


  public void doDispatch(RenderRequest renderRequest, 
                         RenderResponse renderResponse)
    throws PortletException, IOException
  {
    if (getTestName().equals(EXCEPTIONTHROWN_NODEFAULTVIEWID_TEST))
    {

      Bridge bridge = super.getFacesBridge(renderRequest, renderResponse);
      try
      {
        bridge.doFacesRequest(renderRequest, renderResponse);
      }
      catch (BridgeDefaultViewNotSpecifiedException e)
      {
        outputTestResult(renderResponse, Boolean.TRUE, "Correctly threw BridgeDefaultViewNotSpecifiedException when no default defined.");
      }
      catch (Exception e)
      {
        outputTestResult(renderResponse, Boolean.FALSE, "Didn't throw BridgeDefaultViewNotSpecifiedException when no default defined.");
      }
    }
    else if (getTestName().equals(BRIDGESETSCONTENTTYPE_TEST))
    {
      // By invoking the bridge directly (and not setting the contentType)
      // we force the bridge to have to do the work
      Bridge bridge = super.getFacesBridge(renderRequest, renderResponse);
      bridge.doFacesRequest(renderRequest, renderResponse);
    }
    else if (getTestName().equals(VIEWIDWITHPARAM_TEST))
    {
      renderRequest.setAttribute(Bridge.VIEW_ID, "/tests/SingleRequestTest.jsp?param1=testValue");
      super.doDispatch(renderRequest, renderResponse);
    }
    else if (getTestName().equals(FACESCONTEXTRELEASED_ACTION_TEST) || getTestName().equals(PORTLETPHASEREMOVED_ACTION_TEST))
    {
      // Output in the Test method fort his test
      super.doDispatch(renderRequest, renderResponse);
    }
    else if (getTestName().equals(FACESCONTEXTRELEASED_RENDER_TEST))
    {
      super.doDispatch(renderRequest, renderResponse);
      if (renderRequest.getPortletSession(true).getAttribute("org.apache.portlet.faces.tck.facesContextReleased") != null)
      {
        outputTestResult(renderResponse, Boolean.TRUE, "Correctly release FacesContext at end of render.");
        renderRequest.getPortletSession().removeAttribute("org.apache.portlet.faces.tck.facesContextReleased");
      }
      else
      {
        outputTestResult(renderResponse, Boolean.FALSE, "FacesContext not release at end of render.");        
      }      
    }
    else if (getTestName().equals(PORTLETPHASEREMOVED_RENDER_TEST))
    {
      super.doDispatch(renderRequest, renderResponse);
      if (renderRequest.getAttribute(Bridge.PORTLET_LIFECYCLE_PHASE) == null)
      {
        outputTestResult(renderResponse, Boolean.TRUE, "Correctly removed Portlet Phase attribute at end of render.");
      }
      else
      {
        outputTestResult(renderResponse, Boolean.FALSE, "Didn't remove Portlet Phase attribute at end of render.");        
      }       
    }
  }

  private void outputTestResult(RenderResponse response, 
                                               Boolean pass, String detail)
    throws IOException
  {
    response.setContentType("text/html");
    PrintWriter out = response.getWriter();
    BridgeTCKResultWriter resultWriter = 
    new BridgeTCKResultWriter(getTestName());

    if (pass.booleanValue())
    {
      resultWriter.setStatus(BridgeTCKResultWriter.PASS);
      resultWriter.setDetail(detail);
    }
    else
    {
      resultWriter.setStatus(BridgeTCKResultWriter.FAIL);
      resultWriter.setDetail(detail);
    }

    out.println(resultWriter.toString());
  }
}
