/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.internal.component.AbstractUIPanelBase;
import org.apache.myfaces.tobago.model.CollapseMode;

public abstract class AbstractUICollapsiblePanel
extends AbstractUIPanelBase {
    private transient Boolean submittedCollapsed;

    public void processDecodes(FacesContext facesContext) {
        if (this.isNormalLifecycle()) {
            super.processDecodes(facesContext);
        } else {
            UIComponent label;
            this.decode(facesContext);
            UIComponent bar = this.getFacet("bar");
            if (bar != null) {
                bar.processDecodes(facesContext);
            }
            if ((label = this.getFacet("label")) != null) {
                label.processDecodes(facesContext);
            }
        }
    }

    public void processValidators(FacesContext facesContext) {
        if (this.isNormalLifecycle()) {
            super.processValidators(facesContext);
        } else {
            UIComponent label;
            UIComponent bar = this.getFacet("bar");
            if (bar != null) {
                bar.processValidators(facesContext);
            }
            if ((label = this.getFacet("label")) != null) {
                label.processValidators(facesContext);
            }
        }
    }

    public void processUpdates(FacesContext facesContext) {
        if (this.isNormalLifecycle()) {
            super.processUpdates(facesContext);
        } else {
            UIComponent label;
            UIComponent bar = this.getFacet("bar");
            if (bar != null) {
                bar.processUpdates(facesContext);
            }
            if ((label = this.getFacet("label")) != null) {
                label.processUpdates(facesContext);
            }
        }
    }

    public boolean isNormalLifecycle() {
        return this.getCollapsedMode() == CollapseMode.hidden || !this.isCollapsed();
    }

    public abstract boolean isCollapsed();

    public abstract void setCollapsed(boolean var1);

    public abstract CollapseMode getCollapsedMode();

    public void setSubmittedCollapsed(Boolean submittedCollapsed) {
        this.submittedCollapsed = submittedCollapsed;
    }

    public void processState() {
        if (this.submittedCollapsed != null) {
            ValueExpression valueExpression = this.getValueExpression(Attributes.collapsed.name());
            if (valueExpression != null) {
                valueExpression.setValue(FacesContext.getCurrentInstance().getELContext(), (Object)this.submittedCollapsed);
            } else {
                this.setCollapsed(this.submittedCollapsed);
            }
            this.submittedCollapsed = null;
        }
    }
}

