/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.myfaces.tobago.application.Toast;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIReload;
import org.apache.myfaces.tobago.internal.component.AbstractUIStyle;
import org.apache.myfaces.tobago.internal.component.AbstractUIToasts;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.layout.Placement;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.Arias;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlRoleValues;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.ResourceUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToastsRenderer<T extends AbstractUIToasts>
extends RendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String SUFFIX_STATES = "states";

    @Override
    public void decodeInternal(FacesContext facesContext, T component) {
        super.decodeInternal(facesContext, component);
        String clientId = component.getClientId(facesContext);
        String statesInputId = clientId + "::" + SUFFIX_STATES;
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(statesInputId)) {
            String json = (String)requestParameterMap.get(statesInputId);
            Map<String, StateData> states = this.decodeStates(json);
            Object toasts = ((AbstractUIToasts)component).getValue();
            List toastIds = toasts.stream().map(toast -> clientId + "::" + toast.getId()).collect(Collectors.toList());
            ArrayList idsForRemoval = new ArrayList();
            states.forEach((key, value) -> {
                if (((StateData)value).state.equals((Object)StateEnum.closed) || ((StateData)value).hideTime != null && ((StateData)value).hideTime.isBefore(LocalTime.now()) || !toastIds.contains(key)) {
                    idsForRemoval.add(key);
                }
            });
            toasts.removeIf(toast -> idsForRemoval.contains(clientId + "::" + toast.getId()));
            states.entrySet().removeIf(entry -> idsForRemoval.contains(entry.getKey()));
            ((AbstractUIToasts)component).setStates(states);
        }
    }

    private Map<String, StateData> decodeStates(String input) {
        if (input == null) {
            return null;
        }
        String string = input.trim().replaceAll("&quot;", "\"");
        HashMap<String, StateData> result = new HashMap<String, StateData>();
        if (string.length() < 2 || string.charAt(0) != '{' || string.charAt(string.length() - 1) != '}') {
            LOG.warn("Can't parse: no surrounding curly brackets: '{}'", (Object)string);
        } else {
            string = string.substring(1, string.length() - 1);
            StringTokenizer tokenizer = new StringTokenizer(string, "\",{}");
            String id = null;
            StateEnum state = null;
            LocalTime hideTime = null;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                if (token.equals(":") || token.equals("state") || token.equals("hideTime")) continue;
                if (id == null) {
                    id = token;
                    continue;
                }
                if (state == null) {
                    state = StateEnum.valueOf(token);
                    continue;
                }
                if (!token.equals(":null")) {
                    hideTime = LocalTime.parse(token);
                }
                result.put(id, new StateData(state, hideTime));
                id = null;
                state = null;
                hideTime = null;
            }
        }
        return result;
    }

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId(facesContext);
        Placement placement = ((AbstractUIToasts)component).getPlacement();
        Integer disposeDelay = ((AbstractUIToasts)component).getDisposeDelay();
        Markup markup = component.getMarkup() != null ? component.getMarkup() : Markup.NULL;
        Map<String, StateData> states = ((AbstractUIToasts)component).getStates();
        this.insideBegin(facesContext, HtmlElements.TOBAGO_TOASTS);
        writer.startElement(HtmlElements.TOBAGO_TOASTS);
        writer.writeIdAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        AbstractUIReload reload = ComponentUtils.getReloadFacet(component);
        if (reload != null) {
            reload.encodeAll(facesContext);
        }
        Object toasts = ((AbstractUIToasts)component).getValue();
        UIComponent header = ComponentUtils.getFacet(component, Facets.header);
        List children = component.getChildren();
        if (toasts.size() == component.getRowCount()) {
            int rowIndex = component.getFirst();
            Iterator iterator = toasts.iterator();
            while (iterator.hasNext()) {
                Toast toast = (Toast)iterator.next();
                component.setRowIndex(rowIndex);
                if (!component.isRowAvailable()) break;
                String toastId = clientId + "::" + toast.getId();
                if (!states.containsKey(toastId)) {
                    states.put(toastId, new StateData(StateEnum.created, null));
                }
                StateData stateData = states.get(toastId);
                writer.startElement(HtmlElements.DIV);
                writer.writeIdAttribute(toastId);
                writer.writeClassAttribute(BootstrapClass.TOAST, component.getCustomClass(), markup.contains(Markup.HIDE_CLOSE_BUTTON) ? TobagoClass.HIDE_CLOSE_BUTTON : null);
                writer.writeAttribute(HtmlAttributes.NAME, toastId, false);
                writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.ALERT.toString(), false);
                writer.writeAttribute(Arias.LIVE, "assertive", false);
                writer.writeAttribute((MarkupLanguageAttributes)Arias.ATOMIC, true);
                writer.writeAttribute(DataAttributes.PLACEMENT, placement.name(), false);
                if (stateData.state.equals((Object)StateEnum.created)) {
                    writer.writeAttribute((MarkupLanguageAttributes)DataAttributes.DISPOSE_DELAY, disposeDelay);
                    if (disposeDelay > 0) {
                        LocalTime hideTime = LocalTime.now().plus(disposeDelay.intValue(), ChronoUnit.MILLIS);
                        states.put(toastId, new StateData(StateEnum.created, hideTime));
                    }
                } else if (stateData.state.equals((Object)StateEnum.showed)) {
                    if (stateData.hideTime != null) {
                        int decreasedDisposeDelay = (int)LocalTime.now().until(stateData.hideTime, ChronoUnit.MILLIS);
                        writer.writeAttribute((MarkupLanguageAttributes)DataAttributes.DISPOSE_DELAY, Math.max(decreasedDisposeDelay, 0));
                        if (decreasedDisposeDelay <= 0) {
                            states.put(toastId, new StateData(StateEnum.closed, null));
                        }
                    } else {
                        writer.writeAttribute((MarkupLanguageAttributes)DataAttributes.DISPOSE_DELAY, disposeDelay);
                    }
                }
                if (header != null) {
                    writer.startElement(HtmlElements.DIV);
                    writer.writeClassAttribute(BootstrapClass.TOAST_HEADER);
                    this.insideBegin(facesContext, Facets.header);
                    for (UIComponent child : RenderUtils.getFacetChildren(header)) {
                        child.encodeAll(facesContext);
                    }
                    this.encodeCloseButton(facesContext, writer);
                    this.insideEnd(facesContext, Facets.header);
                    writer.endElement(HtmlElements.DIV);
                }
                writer.startElement(HtmlElements.DIV);
                writer.writeClassAttribute(BootstrapClass.TOAST_BODY);
                if (header == null) {
                    this.encodeCloseButton(facesContext, writer);
                }
                for (UIComponent child : children) {
                    child.encodeAll(facesContext);
                }
                writer.endElement(HtmlElements.DIV);
                writer.endElement(HtmlElements.DIV);
                ++rowIndex;
            }
        }
        component.setRowIndex(-1);
        String statesInputId = clientId + "::" + SUFFIX_STATES;
        writer.startElement(HtmlElements.INPUT);
        writer.writeIdAttribute(statesInputId);
        writer.writeNameAttribute(statesInputId);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeAttribute(HtmlAttributes.VALUE, this.encodeStates(states), false);
        writer.endElement(HtmlElements.INPUT);
    }

    private void encodeCloseButton(FacesContext facesContext, TobagoResponseWriter writer) throws IOException {
        writer.startElement(HtmlElements.BUTTON);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.BUTTON);
        writer.writeClassAttribute(BootstrapClass.BTN_CLOSE, TobagoClass.CLOSE);
        writer.writeAttribute(DataAttributes.BS_DISMISS, "toast", false);
        writer.writeAttribute(Arias.LABEL, ResourceUtils.getString(facesContext, "toast.close"), false);
        writer.endElement(HtmlElements.BUTTON);
    }

    private String encodeStates(Map<String, StateData> states) {
        if (states == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean firstEntry = true;
        builder.append("{");
        for (Map.Entry<String, StateData> entry : states.entrySet()) {
            if (firstEntry) {
                firstEntry = false;
            } else {
                builder.append(",");
            }
            builder.append("\"");
            builder.append(entry.getKey());
            builder.append("\":{\"state\":\"");
            builder.append((Object)entry.getValue().state);
            builder.append("\",\"hideTime\":");
            if (entry.getValue().hideTime != null) {
                builder.append("\"");
                builder.append(entry.getValue().hideTime);
                builder.append("\"");
            } else {
                builder.append("null");
            }
            builder.append("}");
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.TOBAGO_TOASTS);
        this.insideEnd(facesContext, HtmlElements.TOBAGO_TOASTS);
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeChildrenInternal(FacesContext facesContext, T component) throws IOException {
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof AbstractUIStyle)) continue;
            child.encodeAll(facesContext);
        }
    }

    private static enum StateEnum {
        created,
        showed,
        closed;

    }

    public static class StateData {
        private final StateEnum state;
        private final LocalTime hideTime;

        public StateData(StateEnum state, LocalTime hideTime) {
            this.state = state;
            this.hideTime = hideTime;
        }

        public StateEnum getState() {
            return this.state;
        }

        public LocalTime getHideTime() {
            return this.hideTime;
        }
    }
}

