/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.component.UIInput;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.model.SelectItem;
import java.io.IOException;
import java.util.List;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectOneBase;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectOneListbox;
import org.apache.myfaces.tobago.internal.renderkit.renderer.SelectOneRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.SelectItemUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectOneListboxRenderer<T extends AbstractUISelectOneListbox>
extends SelectOneRendererBase<T> {
    @Override
    public HtmlElements getComponentTag() {
        return HtmlElements.TOBAGO_SELECT_ONE_LISTBOX;
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeBeginField(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId(facesContext);
        String fieldId = ((AbstractUISelectOneListbox)component).getFieldId(facesContext);
        List<SelectItem> items = SelectItemUtils.getItemList(facesContext, component);
        boolean disabled = !items.iterator().hasNext() || ((AbstractUISelectOneBase)component).isDisabled() || ((AbstractUISelectOneBase)component).isReadonly();
        Markup markup = component.getMarkup() != null ? component.getMarkup() : Markup.NULL;
        Integer size = ((AbstractUISelectOneListbox)component).getSize();
        size = Math.max(size != null ? size.intValue() : items.size(), 2);
        writer.startElement(HtmlElements.SELECT);
        writer.writeIdAttribute(fieldId);
        writer.writeNameAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, ((AbstractUISelectOneBase)component).isReadonly());
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, component.isRequired());
        SelectOneListboxRenderer.renderFocus(clientId, ((AbstractUISelectOneBase)component).isFocus(), ((AbstractUISelectOneBase)component).isError(), facesContext, writer);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, ((AbstractUISelectOneBase)component).getTabIndex());
        writer.writeClassAttribute(BootstrapClass.FORM_SELECT, markup.contains(Markup.LARGE) ? BootstrapClass.FORM_SELECT_LG : null, markup.contains(Markup.SMALL) ? BootstrapClass.FORM_SELECT_SM : null, BootstrapClass.validationColor(ComponentUtils.getMaximumSeverity(component)), component.getCustomClass(), markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
        writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.SIZE, size);
        this.renderSelectItems((UIInput)component, null, (Iterable<SelectItem>)items, component.getValue(), (String)component.getSubmittedValue(), writer, facesContext);
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.SELECT);
        this.encodeBehavior(writer, facesContext, (ClientBehaviorHolder)component);
    }

    @Override
    protected String getFieldId(FacesContext facesContext, T component) {
        return ((AbstractUISelectOneListbox)component).getFieldId(facesContext);
    }
}

