/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit;

import jakarta.faces.context.FacesContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.myfaces.tobago.component.ClientBehaviors;
import org.apache.myfaces.tobago.internal.renderkit.Command;

public class CommandMap {
    private static final String KEY = CommandMap.class.getName() + ".KEY";
    private Command click;
    private Map<ClientBehaviors, Command> other;

    public CommandMap() {
    }

    public CommandMap(Command click) {
        this.click = click;
    }

    public void setClick(Command click) {
        this.click = click;
    }

    public Command getClick() {
        return this.click;
    }

    public void addCommand(ClientBehaviors name, Command command) {
        if (name == ClientBehaviors.click) {
            this.setClick(command);
        } else {
            if (this.other == null) {
                this.other = new HashMap<ClientBehaviors, Command>();
            }
            this.other.put(name, command);
        }
    }

    public Map<ClientBehaviors, Command> getOther() {
        if (this.other != null) {
            return Collections.unmodifiableMap(this.other);
        }
        return null;
    }

    public static CommandMap merge(CommandMap m1, CommandMap m2) {
        if (m1 == null) {
            return m2;
        }
        if (m2 == null) {
            return m1;
        }
        Command c2 = m2.getClick();
        if (c2 != null) {
            Command c1 = m1.getClick();
            if (c1 == null) {
                m1.setClick(c2);
            } else {
                c1.merge(c2);
            }
        } else if (m1.other != null && m2.getOther() != null) {
            for (Map.Entry<ClientBehaviors, Command> entry : m2.getOther().entrySet()) {
                ClientBehaviors key = entry.getKey();
                Command value = entry.getValue();
                if (m1.other.containsKey((Object)key)) {
                    Command command = m1.other.get((Object)key);
                    command.merge(value);
                    continue;
                }
                m1.addCommand(key, value);
            }
        }
        return m1;
    }

    public static CommandMap restoreCommandMap(FacesContext facesContext) {
        return (CommandMap)facesContext.getAttributes().get(KEY);
    }

    public static void storeCommandMap(FacesContext facesContext, CommandMap map) {
        facesContext.getAttributes().put(KEY, map);
    }

    public boolean isEmpty() {
        return this.click == null && this.other == null;
    }
}

