/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.myfaces.tobago.internal.util.ResponseWriterBuffer;

public abstract class WriterHelper {
    protected static final char[] EMPTY = new char[0];
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    protected static final char[][] ISO8859_1_ENTITIES = new char[][]{"nbsp".toCharArray(), "iexcl".toCharArray(), "cent".toCharArray(), "pound".toCharArray(), "curren".toCharArray(), "yen".toCharArray(), "brvbar".toCharArray(), "sect".toCharArray(), "uml".toCharArray(), "copy".toCharArray(), "ordf".toCharArray(), "laquo".toCharArray(), "not".toCharArray(), "shy".toCharArray(), "reg".toCharArray(), "macr".toCharArray(), "deg".toCharArray(), "plusmn".toCharArray(), "sup2".toCharArray(), "sup3".toCharArray(), "acute".toCharArray(), "micro".toCharArray(), "para".toCharArray(), "middot".toCharArray(), "cedil".toCharArray(), "sup1".toCharArray(), "ordm".toCharArray(), "raquo".toCharArray(), "frac14".toCharArray(), "frac12".toCharArray(), "frac34".toCharArray(), "iquest".toCharArray(), "Agrave".toCharArray(), "Aacute".toCharArray(), "Acirc".toCharArray(), "Atilde".toCharArray(), "Auml".toCharArray(), "Aring".toCharArray(), "AElig".toCharArray(), "Ccedil".toCharArray(), "Egrave".toCharArray(), "Eacute".toCharArray(), "Ecirc".toCharArray(), "Euml".toCharArray(), "Igrave".toCharArray(), "Iacute".toCharArray(), "Icirc".toCharArray(), "Iuml".toCharArray(), "ETH".toCharArray(), "Ntilde".toCharArray(), "Ograve".toCharArray(), "Oacute".toCharArray(), "Ocirc".toCharArray(), "Otilde".toCharArray(), "Ouml".toCharArray(), "times".toCharArray(), "Oslash".toCharArray(), "Ugrave".toCharArray(), "Uacute".toCharArray(), "Ucirc".toCharArray(), "Uuml".toCharArray(), "Yacute".toCharArray(), "THORN".toCharArray(), "szlig".toCharArray(), "agrave".toCharArray(), "aacute".toCharArray(), "acirc".toCharArray(), "atilde".toCharArray(), "auml".toCharArray(), "aring".toCharArray(), "aelig".toCharArray(), "ccedil".toCharArray(), "egrave".toCharArray(), "eacute".toCharArray(), "ecirc".toCharArray(), "euml".toCharArray(), "igrave".toCharArray(), "iacute".toCharArray(), "icirc".toCharArray(), "iuml".toCharArray(), "eth".toCharArray(), "ntilde".toCharArray(), "ograve".toCharArray(), "oacute".toCharArray(), "ocirc".toCharArray(), "otilde".toCharArray(), "ouml".toCharArray(), "divide".toCharArray(), "oslash".toCharArray(), "ugrave".toCharArray(), "uacute".toCharArray(), "ucirc".toCharArray(), "uuml".toCharArray(), "yacute".toCharArray(), "thorn".toCharArray(), "yuml".toCharArray()};
    private final Writer out;
    private final ResponseWriterBuffer buffer;
    private final boolean utf8;

    @Deprecated
    public WriterHelper(Writer out, String characterEncoding) {
        this.out = out;
        this.buffer = new ResponseWriterBuffer(out);
        this.utf8 = UTF8.name().equalsIgnoreCase(characterEncoding);
    }

    public WriterHelper(Writer out, Charset charset) {
        this.out = out;
        this.buffer = new ResponseWriterBuffer(out);
        this.utf8 = UTF8.equals(charset);
    }

    public void writeAttributeValue(String text) throws IOException {
        this.writeEncodedValue(text.toCharArray(), 0, text.length(), true);
    }

    public void writeText(String text) throws IOException {
        this.writeEncodedValue(text.toCharArray(), 0, text.length(), false);
    }

    public void writeText(char[] text, int start, int length) throws IOException {
        this.writeEncodedValue(text, start, length, false);
    }

    protected abstract void writeEncodedValue(char[] var1, int var2, int var3, boolean var4) throws IOException;

    protected void writeDecRef(char ch) throws IOException {
        if (ch == 8364) {
            this.out.write("&euro;");
            return;
        }
        this.out.write("&#");
        int i = ch;
        if (i > 10000) {
            this.out.write(48 + i / 10000);
            this.out.write(48 + (i %= 10000) / 1000);
            this.out.write(48 + (i %= 1000) / 100);
            this.out.write(48 + (i %= 100) / 10);
            this.out.write(48 + (i %= 10));
        } else if (i > 1000) {
            this.out.write(48 + i / 1000);
            this.out.write(48 + (i %= 1000) / 100);
            this.out.write(48 + (i %= 100) / 10);
            this.out.write(48 + (i %= 10));
        } else {
            this.out.write(48 + i / 100);
            this.out.write(48 + (i %= 100) / 10);
            this.out.write(48 + (i %= 10));
        }
        this.out.write(59);
    }

    protected final Writer getOut() {
        return this.out;
    }

    protected final ResponseWriterBuffer getBuffer() {
        return this.buffer;
    }

    protected final boolean isUtf8() {
        return this.utf8;
    }
}

