/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIOut;
import org.apache.myfaces.tobago.internal.renderkit.renderer.DecorationPositionRendererBase;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.sanitizer.SanitizeMode;
import org.apache.myfaces.tobago.sanitizer.Sanitizer;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutRenderer<T extends AbstractUIOut>
extends DecorationPositionRendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    @Override
    protected boolean isOutputOnly(T component) {
        return true;
    }

    @Override
    public HtmlElements getComponentTag() {
        return HtmlElements.TOBAGO_OUT;
    }

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        boolean plain;
        boolean bl = plain = component.isPlain() || ((AbstractUIOut)component).isCompact() || !((AbstractUIOut)component).isCreateSpan();
        if (this.isInside(facesContext, HtmlElements.TOBAGO_IN)) {
            this.encodeBeginField(facesContext, component);
        } else if (plain) {
            this.encodeText(facesContext, component);
        } else {
            super.encodeBeginInternal(facesContext, component);
        }
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        boolean plain;
        boolean bl = plain = component.isPlain() || ((AbstractUIOut)component).isCompact() || !((AbstractUIOut)component).isCreateSpan();
        if (this.isInside(facesContext, HtmlElements.TOBAGO_IN)) {
            this.encodeEndField(facesContext, component);
        } else if (!plain) {
            super.encodeEndInternal(facesContext, component);
        }
    }

    @Override
    public void encodeBeginField(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        Markup markup = component.getMarkup();
        writer.startElement(this.isInside(facesContext, HtmlElements.TOBAGO_IN) ? HtmlElements.TOBAGO_OUT : HtmlElements.SPAN);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        writer.writeClassAttribute(markup != null && markup.contains(Markup.DELETED) ? TobagoClass.DELETED : null, markup != null && markup.contains(Markup.NUMBER) ? TobagoClass.NUMBER : null, component.getCustomClass(), this.isInside(facesContext, HtmlElements.TOBAGO_IN) ? BootstrapClass.INPUT_GROUP_TEXT : BootstrapClass.FORM_CONTROL_PLAINTEXT, BootstrapClass.textColor(markup), BootstrapClass.fontStyle(markup));
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        this.encodeText(facesContext, component);
    }

    private void encodeText(FacesContext facesContext, T out) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        boolean escape = ((AbstractUIOut)out).isEscape();
        boolean keepLineBreaks = ((AbstractUIOut)out).isKeepLineBreaks();
        String text = this.getCurrentValue(facesContext, out);
        if (text == null) {
            text = "";
        }
        if (((AbstractUIOut)out).isMessageFormat()) {
            text = this.getOutputFormatText(facesContext, text, out);
        }
        if (escape) {
            if (keepLineBreaks) {
                StringTokenizer tokenizer = new StringTokenizer(text, "\r\n");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    writer.writeText(token);
                    if (!tokenizer.hasMoreTokens()) continue;
                    writer.startElement(HtmlElements.BR);
                    writer.endElement(HtmlElements.BR);
                }
            } else {
                writer.writeText(text);
            }
        } else {
            writer.writeText("");
            if (SanitizeMode.auto == ((AbstractUIOut)out).getSanitize()) {
                Sanitizer sanitizer = TobagoConfig.getInstance(facesContext).getSanitizer();
                text = sanitizer.sanitize(text);
            }
            writer.write(text);
        }
    }

    private String getOutputFormatText(FacesContext facesContext, String pattern, T out) {
        Object[] args;
        if (out.getChildCount() > 0) {
            List<UIParameter> validParams = this.getValidUIParameterChildren(out);
            if (!validParams.isEmpty()) {
                ArrayList<Object> argsList = new ArrayList<Object>(validParams.size());
                for (UIParameter param : validParams) {
                    argsList.add(param.getValue());
                }
                args = argsList.toArray(EMPTY_OBJECT_ARRAY);
            } else {
                args = EMPTY_OBJECT_ARRAY;
            }
        } else {
            args = EMPTY_OBJECT_ARRAY;
        }
        MessageFormat format = new MessageFormat(pattern, facesContext.getViewRoot().getLocale());
        try {
            return format.format(args);
        }
        catch (Exception e) {
            LOG.error("Error formatting message of component with clientId='{}'", (Object)out.getClientId(facesContext));
            return pattern;
        }
    }

    private List<UIParameter> getValidUIParameterChildren(T out) {
        ArrayList<UIParameter> parameters = new ArrayList<UIParameter>();
        for (UIComponent child : out.getChildren()) {
            UIParameter param;
            if (!(child instanceof UIParameter) || (param = (UIParameter)child).isDisable() || !param.isRendered()) continue;
            parameters.add(param);
        }
        return parameters;
    }

    @Override
    public void encodeEndField(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(this.isInside(facesContext, HtmlElements.TOBAGO_IN) ? HtmlElements.TOBAGO_OUT : HtmlElements.SPAN);
    }

    @Override
    protected String getFieldId(FacesContext facesContext, T component) {
        return component.getClientId(facesContext);
    }
}

