/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.lang.invoke.MethodHandles;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRenderViewEvent;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.Visual;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.layout.Display;
import org.apache.myfaces.tobago.layout.GridSpan;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.Overflow;
import org.apache.myfaces.tobago.layout.Position;
import org.apache.myfaces.tobago.layout.TextAlign;
import org.apache.myfaces.tobago.renderkit.css.CustomClass;
import org.apache.myfaces.tobago.util.FacesVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public abstract class AbstractUIStyle
extends UIComponentBase {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void processEvent(ComponentSystemEvent event) {
        super.processEvent(event);
        FacesContext facesContext = this.getFacesContext();
        if (event instanceof PreRenderViewEvent) {
            if (StringUtils.isNotBlank(this.getFile())) {
                UIViewRoot root = facesContext.getViewRoot();
                root.addComponentResource(facesContext, (UIComponent)this);
            }
        } else if (event instanceof PostAddToViewEvent) {
            ValueExpression valueExpression;
            if (StringUtils.isNotBlank(this.getFile())) {
                if (FacesVersion.supports21() || !FacesVersion.isMyfaces()) {
                    facesContext.getViewRoot().subscribeToEvent(PreRenderViewEvent.class, (ComponentSystemEventListener)this);
                } else {
                    UIViewRoot root = facesContext.getViewRoot();
                    root.addComponentResource(facesContext, (UIComponent)this);
                }
            }
            if ((valueExpression = this.getValueExpression(Attributes.customClass.getName())) != null) {
                UIComponent parent = this.getParent();
                if (parent instanceof Visual) {
                    parent.setValueExpression(Attributes.customClass.getName(), valueExpression);
                } else {
                    LOG.warn("The parent '{}' of a style component doesn't support styling!", (Object)parent.getClientId(facesContext));
                }
            } else {
                CustomClass customClass = this.getCustomClass();
                if (customClass != null) {
                    UIComponent parent = this.getParent();
                    if (parent instanceof Visual) {
                        ((Visual)parent).setCustomClass(customClass);
                    } else {
                        LOG.warn("The parent '{}' of a style component doesn't support styling!", (Object)parent.getClientId(facesContext));
                    }
                }
            }
        }
    }

    public abstract String getSelector();

    public abstract void setSelector(String var1);

    public abstract Measure getPaddingRight();

    public abstract Measure getMinHeight();

    public abstract Measure getMarginRight();

    public abstract String getFile();

    public abstract void setFile(String var1);

    public abstract Measure getPaddingBottom();

    public abstract Measure getTop();

    public abstract Measure getMaxHeight();

    public abstract Measure getPaddingTop();

    public abstract Measure getHeight();

    public abstract void setHeight(Measure var1);

    public abstract Measure getMaxWidth();

    public abstract TextAlign getTextAlign();

    public abstract Measure getBottom();

    public abstract Display getDisplay();

    public abstract Measure getMinWidth();

    public abstract Measure getRight();

    public abstract Measure getMarginLeft();

    public abstract Overflow getOverflowX();

    public abstract Overflow getOverflowY();

    public abstract Measure getLeft();

    public abstract Measure getWidth();

    public abstract void setWidth(Measure var1);

    public abstract CustomClass getCustomClass();

    public abstract Measure getMarginBottom();

    public abstract Position getPosition();

    public abstract Measure getPaddingLeft();

    public abstract Measure getMarginTop();

    public abstract String getBackgroundImage();

    public abstract void setBackgroundImage(String var1);

    public abstract Float getFlexGrow();

    public abstract void setFlexGrow(Float var1);

    public abstract Float getFlexShrink();

    public abstract void setFlexShrink(Float var1);

    public abstract Measure getFlexBasis();

    public abstract void setFlexBasis(Measure var1);

    public abstract String getGridTemplateColumns();

    public abstract void setGridTemplateColumns(String var1);

    public abstract String getGridTemplateRows();

    public abstract void setGridTemplateRows(String var1);

    public abstract GridSpan getGridColumn();

    public abstract void setGridColumn(GridSpan var1);

    public abstract GridSpan getGridRow();

    public abstract void setGridRow(GridSpan var1);
}

