/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIBadge;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class BadgeRenderer<T extends AbstractUIBadge>
extends RendererBase<T> {
    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        Markup markup = component.getMarkup() != null ? component.getMarkup() : Markup.NULL;
        String tip = ((AbstractUIBadge)component).getTip();
        String value = this.getCurrentValue(facesContext, component);
        writer.startElement(HtmlElements.TOBAGO_BADGE);
        writer.writeIdAttribute(component.getClientId(facesContext));
        writer.writeClassAttribute(BootstrapClass.BADGE, this.getBadgeColor(markup), markup.contains(Markup.PILL) ? BootstrapClass.ROUNDED_PILL : null, this.isInside(facesContext, HtmlElements.TOBAGO_BUTTONS) ? BootstrapClass.BTN : null, component.getCustomClass());
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        if (tip != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, tip, true);
        }
        if (value != null) {
            writer.writeText(value);
        }
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.TOBAGO_BADGE);
    }

    private BootstrapClass getBadgeColor(Markup markup) {
        if (markup.contains(Markup.NONE)) {
            return null;
        }
        if (markup.contains(Markup.PRIMARY)) {
            return BootstrapClass.TEXT_BG_PRIMARY;
        }
        if (markup.contains(Markup.SECONDARY)) {
            return BootstrapClass.TEXT_BG_SECONDARY;
        }
        if (markup.contains(Markup.SUCCESS)) {
            return BootstrapClass.TEXT_BG_SUCCESS;
        }
        if (markup.contains(Markup.DANGER)) {
            return BootstrapClass.TEXT_BG_DANGER;
        }
        if (markup.contains(Markup.WARNING)) {
            return BootstrapClass.TEXT_BG_WARNING;
        }
        if (markup.contains(Markup.INFO)) {
            return BootstrapClass.TEXT_BG_INFO;
        }
        if (markup.contains(Markup.LIGHT)) {
            return BootstrapClass.TEXT_BG_LIGHT;
        }
        if (markup.contains(Markup.DARK)) {
            return BootstrapClass.TEXT_BG_DARK;
        }
        return null;
    }
}

