/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class AjaxUtils {
    public static boolean isAjaxRequest(FacesContext facesContext) {
        return facesContext.getPartialViewContext().isAjaxRequest();
    }

    public static boolean isAjaxRequest(ServletRequest request) {
        String requestType = null;
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            requestType = httpServletRequest.getHeader("Faces-Request");
        }
        return "partial/ajax".equalsIgnoreCase(requestType) || "true".equalsIgnoreCase(request.getParameter("javax.faces.partial.ajax"));
    }

    public static void addRenderIds(String ... renderIds) {
        AjaxUtils.addRenderIds(FacesContext.getCurrentInstance(), renderIds);
    }

    public static void addRenderIds(FacesContext facesContext, String ... renderIds) {
        Collections.addAll(facesContext.getPartialViewContext().getRenderIds(), renderIds);
    }

    public static void removeRenderIds(String ... renderIds) {
        AjaxUtils.removeRenderIds(FacesContext.getCurrentInstance(), renderIds);
    }

    public static void removeRenderIds(FacesContext facesContext, String ... renderIds) {
        Collection collection = facesContext.getPartialViewContext().getRenderIds();
        for (String renderId : renderIds) {
            collection.remove(renderId);
        }
    }

    public static Set<String> getRenderIds(FacesContext facesContext) {
        return new HashSet<String>(facesContext.getPartialViewContext().getRenderIds());
    }

    public static void navigate(FacesContext facesContext, Object outcome) {
        Application application = facesContext.getApplication();
        NavigationHandler navigationHandler = application.getNavigationHandler();
        navigationHandler.handleNavigation(facesContext, null, outcome != null ? outcome.toString() : null);
        facesContext.renderResponse();
    }
}

