/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.ListenerFor;
import javax.faces.event.PhaseId;
import javax.faces.event.PreRenderComponentEvent;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.Visual;
import org.apache.myfaces.tobago.event.PageActionEvent;
import org.apache.myfaces.tobago.event.SheetStateChangeEvent;
import org.apache.myfaces.tobago.event.SheetStateChangeListener;
import org.apache.myfaces.tobago.event.SheetStateChangeSource;
import org.apache.myfaces.tobago.event.SortActionEvent;
import org.apache.myfaces.tobago.event.SortActionSource;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumnBase;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUIRow;
import org.apache.myfaces.tobago.internal.layout.Grid;
import org.apache.myfaces.tobago.internal.layout.OriginCell;
import org.apache.myfaces.tobago.internal.util.SortingUtils;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.MeasureList;
import org.apache.myfaces.tobago.layout.ShowPosition;
import org.apache.myfaces.tobago.model.ExpandedState;
import org.apache.myfaces.tobago.model.ScrollPosition;
import org.apache.myfaces.tobago.model.SelectedState;
import org.apache.myfaces.tobago.model.SheetState;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ListenerFor(systemEventClass=PreRenderComponentEvent.class)
public abstract class AbstractUISheet
extends AbstractUIData
implements SheetStateChangeSource,
SortActionSource,
ClientBehaviorHolder,
Visual,
ComponentSystemEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Deprecated
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.Data";
    public static final String SORTER_ID = "sorter";
    public static final String NOT_SORTABLE_COL_MESSAGE_ID = "org.apache.myfaces.tobago.UISheet.SORTING_COL";
    public static final String NOT_SORTABLE_MESSAGE_ID = "org.apache.myfaces.tobago.UISheet.SORTING";
    private SheetState state;
    private transient MeasureList columnLayout;
    private transient boolean autoLayout;
    private transient boolean lazyUpdate;
    private transient int lazyFirstRow;
    private transient Grid headerGrid;

    public void encodeAll(FacesContext facesContext) throws IOException {
        if (this.isLazy() && this.getRows() > 0) {
            LOG.warn("Sheet id={} has lazy=true AND the rows attribute set. Use 'lazyRows' instead.", (Object)this.getClientId(facesContext));
            if (this.getShowRowRange() != ShowPosition.none) {
                LOG.warn("Sheet id={} has lazy=true set, but also set showRowRange!=none!", (Object)this.getClientId(facesContext));
            }
            if (this.getShowPageRange() != ShowPosition.none) {
                LOG.warn("Sheet id={} has lazy=true set, but also set showPageRange!=none!", (Object)this.getClientId(facesContext));
            }
            if (this.getShowDirectLinks() != ShowPosition.none) {
                LOG.warn("Sheet id={} has lazy=true set, but also set showDirectLinks!=none!", (Object)this.getClientId(facesContext));
            }
        }
        super.encodeAll(facesContext);
    }

    @Override
    public void encodeBegin(FacesContext facesContext) throws IOException {
        SheetState theState = this.getSheetState(facesContext);
        int first = theState.getFirst();
        if (!(first <= -1 || this.hasRowCount() && first >= this.getRowCount())) {
            ValueExpression expression = this.getValueExpression(Attributes.first.getName());
            if (expression != null) {
                expression.setValue(facesContext.getELContext(), (Object)first);
            } else {
                this.setFirst(first);
            }
        }
        super.encodeBegin(facesContext);
    }

    public void setState(SheetState state) {
        this.state = state;
    }

    public SheetState getState() {
        return this.getSheetState(FacesContext.getCurrentInstance());
    }

    public SheetState getSheetState(FacesContext facesContext) {
        if (this.state != null) {
            return this.state;
        }
        ValueExpression expression = this.getValueExpression(Attributes.state.getName());
        if (expression != null) {
            ELContext elContext = facesContext.getELContext();
            SheetState sheetState = (SheetState)expression.getValue(elContext);
            if (sheetState == null) {
                sheetState = new SheetState(this.getMaxSortColumns());
                expression.setValue(elContext, (Object)sheetState);
            }
            return sheetState;
        }
        this.state = new SheetState(this.getMaxSortColumns());
        return this.state;
    }

    public abstract String getColumns();

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        super.processEvent(event);
        if (event instanceof PreRenderComponentEvent) {
            String columns = this.getColumns();
            if (columns != null) {
                this.columnLayout = MeasureList.parse(columns);
            }
            this.autoLayout = true;
            if (this.columnLayout != null) {
                for (Measure token : this.columnLayout) {
                    if (token == Measure.AUTO) continue;
                    this.autoLayout = false;
                    break;
                }
            }
            LOG.debug("autoLayout={}", (Object)this.autoLayout);
        }
    }

    public MeasureList getColumnLayout() {
        return this.columnLayout;
    }

    public boolean isAutoLayout() {
        return this.autoLayout;
    }

    public int getLastRowIndexOfCurrentPage() {
        if (!this.hasRowCount()) {
            throw new IllegalArgumentException("Can't determine the last row, because the row count of the model is unknown.");
        }
        if (this.isRowsUnlimited()) {
            return this.getRowCount();
        }
        int last = this.getFirst() + this.getRows();
        return Math.min(last, this.getRowCount());
    }

    public int getCurrentPage() {
        int rows = this.getRows();
        if (rows == 0) {
            return 0;
        }
        int first = this.getFirst();
        if (this.hasRowCount() && first >= this.getRowCount()) {
            return this.getPages() - 1;
        }
        return first / rows;
    }

    public int getPages() {
        if (this.isRowsUnlimited()) {
            return 1;
        }
        if (!this.hasRowCount()) {
            throw new IllegalArgumentException("Can't determine the number of pages, because the row count of the model is unknown.");
        }
        return (this.getRowCount() - 1) / this.getRows() + 1;
    }

    public List<UIComponent> getRenderedChildrenOf(UIColumn column) {
        ArrayList<UIComponent> children = new ArrayList<UIComponent>();
        for (UIComponent kid : column.getChildren()) {
            if (!kid.isRendered()) continue;
            children.add(kid);
        }
        return children;
    }

    public boolean isAtBeginning() {
        return this.getFirst() == 0;
    }

    public boolean hasRowCount() {
        return this.getRowCount() != -1;
    }

    public boolean isPagingVisible() {
        return this.isShowPagingAlways() || this.needMoreThanOnePage();
    }

    public boolean needMoreThanOnePage() {
        if (this.isRowsUnlimited()) {
            return false;
        }
        if (!this.hasRowCount()) {
            return true;
        }
        return this.getRowCount() > this.getRows();
    }

    public abstract boolean isShowPagingAlways();

    public boolean isAtEnd() {
        if (!this.hasRowCount()) {
            int old = this.getRowIndex();
            this.setRowIndex(this.getFirst() + this.getRows() + 1);
            boolean atEnd = !this.isRowAvailable();
            this.setRowIndex(old);
            return atEnd;
        }
        return this.getFirst() >= this.getFirstRowIndexOfLastPage();
    }

    public int getFirstRowIndexOfLastPage() {
        int rowCount;
        if (this.isRowsUnlimited()) {
            return 0;
        }
        if (!this.hasRowCount()) {
            throw new IllegalArgumentException("Can't determine the last page, because the row count of the model is unknown.");
        }
        int rows = this.getRows();
        int tail = (rowCount = this.getRowCount()) % rows;
        return rowCount - (tail != 0 ? tail : rows);
    }

    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        SheetState sheetState = this.getSheetState(context);
        if (sheetState != null) {
            List<Integer> list = (List<Integer>)ComponentUtils.getAttribute((UIComponent)this, Attributes.selectedListString);
            sheetState.setSelectedRows(list != null ? list : Collections.emptyList());
            ComponentUtils.removeAttribute((UIComponent)this, Attributes.selectedListString);
            ComponentUtils.removeAttribute((UIComponent)this, Attributes.scrollPosition);
        }
    }

    public Object saveState(FacesContext context) {
        Object[] saveState = new Object[]{super.saveState(context), this.state};
        return saveState;
    }

    public void restoreState(FacesContext context, Object savedState) {
        Object[] values = (Object[])savedState;
        super.restoreState(context, values[0]);
        this.state = (SheetState)values[1];
    }

    public List<AbstractUIColumnBase> getAllColumns() {
        ArrayList<AbstractUIColumnBase> result = new ArrayList<AbstractUIColumnBase>();
        this.findColumns((UIComponent)this, result, true);
        return result;
    }

    private void findColumns(UIComponent component, List<AbstractUIColumnBase> result, boolean all) {
        for (UIComponent child : component.getChildren()) {
            if (!all && !child.isRendered()) continue;
            if (child instanceof AbstractUIColumnBase) {
                result.add((AbstractUIColumnBase)child);
                continue;
            }
            if (child instanceof AbstractUIData) continue;
            this.findColumns(child, result, all);
        }
    }

    public void queueEvent(FacesEvent facesEvent) {
        UIComponent parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("Component is not a descendant of a UIViewRoot");
        }
        if (facesEvent.getComponent() == this && (facesEvent instanceof SheetStateChangeEvent || facesEvent instanceof PageActionEvent)) {
            facesEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
            parent.queueEvent(facesEvent);
        } else {
            super.queueEvent(facesEvent);
        }
    }

    public void broadcast(FacesEvent facesEvent) throws AbortProcessingException {
        super.broadcast(facesEvent);
        if (facesEvent instanceof SheetStateChangeEvent) {
            MethodExpression listener = this.getStateChangeListenerExpression();
            listener.invoke(this.getFacesContext().getELContext(), new Object[]{facesEvent});
        } else if (facesEvent instanceof PageActionEvent) {
            if (facesEvent.getComponent() == this) {
                MethodExpression listener = this.getStateChangeListenerExpression();
                if (listener != null) {
                    listener.invoke(this.getFacesContext().getELContext(), new Object[]{facesEvent});
                }
                this.performPaging((PageActionEvent)facesEvent);
            }
        } else if (facesEvent instanceof SortActionEvent) {
            this.getSheetState(this.getFacesContext()).updateSortState(((SortActionEvent)facesEvent).getColumn().getId());
            this.sort(this.getFacesContext(), (SortActionEvent)facesEvent);
        }
    }

    public void init(FacesContext facesContext) {
        this.sort(facesContext, null);
        this.layoutHeader();
    }

    private void layoutHeader() {
        UIComponent header = this.getHeader();
        if (header == null) {
            LOG.warn("This should not happen. Please file a bug in the issue tracker to reproduce this case.");
            return;
        }
        MeasureList tokens = new MeasureList();
        List<AbstractUIColumnBase> columns = this.getAllColumns();
        for (UIColumn uIColumn : columns) {
            if (uIColumn instanceof AbstractUIRow) continue;
            tokens.add(Measure.FRACTION1);
        }
        MeasureList rows = new MeasureList();
        rows.add(Measure.AUTO);
        Grid grid = new Grid(tokens, rows);
        for (UIComponent child : header.getChildren()) {
            if (!child.isRendered()) continue;
            int columnSpan = ComponentUtils.getIntAttribute(child, Attributes.columnSpan, 1);
            int rowSpan = ComponentUtils.getIntAttribute(child, Attributes.rowSpan, 1);
            grid.add(new OriginCell(child), columnSpan, rowSpan);
        }
        this.setHeaderGrid(grid);
    }

    protected void sort(FacesContext facesContext, SortActionEvent event) {
        SheetState sheetState = this.getSheetState(this.getFacesContext());
        if (sheetState.getToBeSortedLevel() > 0) {
            MethodExpression expression = this.getSortActionListenerExpression();
            if (expression != null) {
                try {
                    expression.invoke(facesContext.getELContext(), new Object[]{event != null ? event : new SortActionEvent(this, (UIColumn)this.findComponent(this.getSheetState(facesContext).getSortedColumnId()))});
                }
                catch (Exception e) {
                    LOG.warn("Sorting not possible!", (Throwable)e);
                }
            } else {
                SortingUtils.sort(this, null);
            }
            sheetState.sorted();
        }
    }

    @Override
    public void addStateChangeListener(SheetStateChangeListener listener) {
        this.addFacesListener(listener);
    }

    @Override
    public SheetStateChangeListener[] getStateChangeListeners() {
        return (SheetStateChangeListener[])this.getFacesListeners(SheetStateChangeListener.class);
    }

    @Override
    public void removeStateChangeListener(SheetStateChangeListener listener) {
        this.removeFacesListener(listener);
    }

    public void performPaging(PageActionEvent pageEvent) {
        int first;
        if (LOG.isDebugEnabled()) {
            LOG.debug("action = '" + pageEvent.getAction().name() + "'");
        }
        ScrollPosition scrollPosition = this.getState().getScrollPosition();
        scrollPosition.setTop(0);
        switch (pageEvent.getAction()) {
            case first: {
                first = 0;
                break;
            }
            case prev: {
                first = this.getFirst() - this.getRows();
                first = Math.max(first, 0);
                scrollPosition.setTop(Integer.MAX_VALUE);
                break;
            }
            case next: {
                if (this.hasRowCount()) {
                    first = this.getFirst() + this.getRows();
                    first = first > this.getRowCount() ? this.getFirstRowIndexOfLastPage() : first;
                    break;
                }
                if (this.isAtEnd()) {
                    first = this.getFirst();
                    break;
                }
                first = this.getFirst() + this.getRows();
                break;
            }
            case last: {
                first = this.getFirstRowIndexOfLastPage();
                break;
            }
            case toRow: {
                first = this.getToRow(pageEvent);
                break;
            }
            case lazy: {
                first = this.getToRow(pageEvent);
                this.setLazyUpdate(true);
                break;
            }
            case toPage: {
                int pageIndex = pageEvent.getValue() - 1;
                first = pageIndex * this.getRows();
                if (this.hasRowCount() && first > this.getFirstRowIndexOfLastPage()) {
                    first = this.getFirstRowIndexOfLastPage();
                    break;
                }
                if (first >= 0) break;
                first = 0;
                break;
            }
            default: {
                first = -1;
            }
        }
        ValueExpression expression = this.getValueExpression(Attributes.first.getName());
        if (expression != null) {
            expression.setValue(this.getFacesContext().getELContext(), (Object)first);
        } else {
            this.setFirst(first);
        }
        this.getState().setFirst(first);
    }

    private int getToRow(PageActionEvent pageEvent) {
        int first = pageEvent.getValue() - 1;
        if (this.hasRowCount() && first > this.getFirstRowIndexOfLastPage()) {
            first = this.getFirstRowIndexOfLastPage();
        } else if (first < 0) {
            first = 0;
        }
        return first;
    }

    public boolean getLazyUpdate() {
        return this.lazyUpdate;
    }

    public void setLazyUpdate(boolean lazyUpdate) {
        this.lazyUpdate = lazyUpdate;
    }

    public int getLazyFirstRow() {
        return this.lazyFirstRow;
    }

    public void setLazyFirstRow(int lazyFirstRow) {
        this.lazyFirstRow = lazyFirstRow;
    }

    @Override
    public boolean isRendersRowContainer() {
        return true;
    }

    public abstract boolean isShowHeader();

    @Override
    public ExpandedState getExpandedState() {
        return this.getState().getExpandedState();
    }

    @Override
    public SelectedState getSelectedState() {
        return this.getState().getSelectedState();
    }

    public Grid getHeaderGrid() {
        return this.headerGrid;
    }

    public void setHeaderGrid(Grid headerGrid) {
        this.headerGrid = headerGrid;
    }

    public abstract boolean isShowDirectLinksArrows();

    public abstract boolean isShowPageRangeArrows();

    public abstract ShowPosition getShowRowRange();

    public abstract ShowPosition getShowPageRange();

    public abstract ShowPosition getShowDirectLinks();

    public abstract boolean isLazy();

    public abstract Integer getMaxSortColumns();

    public abstract Integer getLazyRows();
}

