/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.ManagedBean;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.util.AuthorizationHelperCdi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedBean
@ApplicationScoped
public class AuthorizationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationHelper.class);
    public static final String AUTHORIZATION_HELPER = "authorizationHelper";
    private static final Pattern PATTERN = Pattern.compile("#\\{(\\w+(?:\\.\\w+)*)\\.(\\w+)(?:\\(.*\\))?}");
    private static final String CC_ATTRS = "cc.attrs.";
    private static final Annotation NULL_VALUE = new Annotation(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return null;
        }

        @Override
        public String toString() {
            return "(NULL)";
        }
    };
    private final Map<String, Object> cache = new ConcurrentHashMap<String, Object>();
    private AuthorizationHelperCdi cdi;

    public AuthorizationHelper() {
        try {
            Class.forName("javax.enterprise.inject.spi.BeanManager");
            this.cdi = new AuthorizationHelperCdi();
            if (!this.cdi.hasBeanManager()) {
                this.cdi = null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static AuthorizationHelper getInstance(FacesContext facesContext) {
        return (AuthorizationHelper)facesContext.getELContext().getELResolver().getValue(facesContext.getELContext(), null, (Object)AUTHORIZATION_HELPER);
    }

    public boolean isAuthorized(FacesContext facesContext, UIComponent component, String expression) {
        Annotation securityAnnotation = this.getSecurityAnnotation(facesContext, component, expression);
        if (securityAnnotation == null) {
            return true;
        }
        if (securityAnnotation instanceof DenyAll) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("DenyAll");
            }
            return false;
        }
        if (securityAnnotation instanceof RolesAllowed) {
            String[] roles = ((RolesAllowed)securityAnnotation).value();
            if (LOG.isDebugEnabled()) {
                LOG.debug("RolesAllowed " + Arrays.asList(((RolesAllowed)securityAnnotation).value()));
            }
            for (String role : roles) {
                boolean authorised = facesContext.getExternalContext().isUserInRole(role);
                if (!authorised) continue;
                return true;
            }
            return false;
        }
        if (securityAnnotation instanceof PermitAll) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("PermitAll");
            }
            return true;
        }
        return true;
    }

    private Annotation getSecurityAnnotation(FacesContext facesContext, UIComponent component, String expression) {
        Annotation securityAnnotation = null;
        if (this.cache.containsKey(expression)) {
            Object obj = this.cache.get(expression);
            if (obj instanceof Annotation) {
                securityAnnotation = (Annotation)obj;
            }
        } else {
            Matcher matcher = PATTERN.matcher(expression);
            if (matcher.matches()) {
                String beanString = matcher.group(1);
                String methodString = matcher.group(2);
                Object bean = this.cdi != null ? this.cdi.getObject(beanString) : facesContext.getELContext().getELResolver().getValue(facesContext.getELContext(), null, (Object)beanString);
                if (bean != null) {
                    List<Method> methods = this.findMethods(bean, methodString);
                    switch (methods.size()) {
                        case 0: {
                            LOG.error("No Method '" + methodString + "' in class " + bean.getClass());
                            break;
                        }
                        case 1: {
                            securityAnnotation = this.getSecurityAnnotations(methods.get(0));
                            break;
                        }
                        default: {
                            LOG.warn("Method name ambiguous '" + methodString + "' in class " + bean.getClass() + ". Found " + methods.size() + " but only 1 is supported, yet.");
                        }
                    }
                    if (securityAnnotation == null) {
                        securityAnnotation = this.getSecurityAnnotations(bean.getClass());
                    }
                }
            }
            if (securityAnnotation == null) {
                securityAnnotation = NULL_VALUE;
            }
            this.cache.put(expression, securityAnnotation);
            if (LOG.isInfoEnabled()) {
                LOG.info("Security annotation '{}' saved for expression '{}'", (Object)securityAnnotation, (Object)expression);
            }
        }
        if (securityAnnotation == NULL_VALUE && expression.contains(CC_ATTRS)) {
            UIComponent compositeComponent = this.getParentCompositeComponent(component);
            if (compositeComponent != null) {
                int attrNameStart;
                int attrNameEnd = expression.substring(attrNameStart = expression.indexOf(CC_ATTRS) + CC_ATTRS.length()).contains(".") ? attrNameStart + expression.substring(attrNameStart).indexOf(".") : attrNameStart + expression.substring(attrNameStart).indexOf("}");
                String attrName = expression.substring(attrNameStart, attrNameEnd);
                ValueExpression valueExpression = compositeComponent.getValueExpression(attrName);
                if (valueExpression != null) {
                    String ccExpression = valueExpression.getExpressionString();
                    int bracketStart = ccExpression.indexOf(123);
                    int bracketEnd = ccExpression.indexOf("}");
                    String trimmedCcExpression = ccExpression.substring(bracketStart + 1, bracketEnd).trim();
                    return this.getSecurityAnnotation(facesContext, component, expression.replace(CC_ATTRS + attrName, trimmedCcExpression));
                }
                MethodExpression methodExpression = (MethodExpression)compositeComponent.getAttributes().get(attrName);
                if (methodExpression != null) {
                    return this.getSecurityAnnotation(facesContext, component, methodExpression.getExpressionString().replaceAll(" ", ""));
                }
                return securityAnnotation;
            }
            return securityAnnotation;
        }
        return securityAnnotation;
    }

    private UIComponent getParentCompositeComponent(UIComponent component) {
        if (component == null) {
            return null;
        }
        if (UIComponent.isCompositeComponent((UIComponent)component)) {
            return component;
        }
        return this.getParentCompositeComponent(component.getParent());
    }

    private Annotation getSecurityAnnotations(AnnotatedElement annotatedElement) {
        RolesAllowed annotation = annotatedElement.getAnnotation(RolesAllowed.class);
        if (annotation != null) {
            return annotation;
        }
        annotation = annotatedElement.getAnnotation(DenyAll.class);
        if (annotation != null) {
            return annotation;
        }
        annotation = annotatedElement.getAnnotation(PermitAll.class);
        return annotation;
    }

    private List<Method> findMethods(Object bean, String name) {
        Class clazz = this.cdi != null ? this.cdi.getBeanClass(bean) : bean.getClass();
        Method[] methods = clazz.getMethods();
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : methods) {
            if (!method.getName().equals(name)) continue;
            result.add(method);
        }
        return result;
    }
}

