/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectOneRadio;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectReference;
import org.apache.myfaces.tobago.internal.renderkit.renderer.SelectOneRendererBase;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.ObjectUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.SelectItemUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectOneRadioRenderer
extends SelectOneRendererBase {
    @Override
    protected void encodeBeginField(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUISelectOneRadio select = (AbstractUISelectOneRadio)component;
        AbstractUISelectReference reference = select.getRenderRangeReference();
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String id = select.getClientId(facesContext);
        String referenceId = reference != null ? reference.getClientId(facesContext) : id;
        Iterable<SelectItem> items = SelectItemUtils.getItemIterator(facesContext, (UIComponent)select);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)select);
        boolean disabled = select.isDisabled();
        boolean readonly = select.isReadonly();
        boolean required = select.isRequired();
        boolean inline = select.isInline();
        Markup markup = select.getMarkup();
        writer.startElement(HtmlElements.DIV);
        if (select.isLabelLayoutSkip()) {
            writer.writeIdAttribute(referenceId);
            writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
        }
        writer.writeClassAttribute((CssItem)TobagoClass.SELECT_ONE_RADIO, TobagoClass.SELECT_ONE_RADIO.createMarkup(markup), new CssItem[]{inline ? TobagoClass.SELECT_ONE_RADIO__INLINE : null, select.getCustomClass()});
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)select);
        if (title != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        boolean first = true;
        Object value = select.getValue();
        String submittedValue = (String)select.getSubmittedValue();
        int i = 0;
        int[] renderRange = this.getRenderRangeList(select, reference);
        for (SelectItem item : items) {
            if (renderRange == null || ArrayUtils.contains(renderRange, i)) {
                String label;
                org.apache.myfaces.tobago.model.SelectItem tobagoItem;
                String image;
                boolean itemDisabled = item.isDisabled() || disabled;
                String itemId = id + "::" + i;
                writer.startElement(HtmlElements.DIV);
                writer.writeClassAttribute(BootstrapClass.CUSTOM_CONTROL, BootstrapClass.CUSTOM_RADIO, inline ? BootstrapClass.CUSTOM_CONTROL_INLINE : null);
                writer.startElement(HtmlElements.INPUT);
                writer.writeClassAttribute(BootstrapClass.CUSTOM_CONTROL_INPUT);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.RADIO);
                String formattedValue = ComponentUtils.getFormattedValue(facesContext, (UIComponent)select, item.getValue());
                boolean checked = submittedValue == null ? ObjectUtils.equals(item.getValue(), value) : ObjectUtils.equals(formattedValue, submittedValue);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.CHECKED, checked);
                writer.writeNameAttribute(id);
                writer.writeIdAttribute(itemId);
                writer.writeAttribute(HtmlAttributes.VALUE, formattedValue, true);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, itemDisabled);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.READONLY, readonly);
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.REQUIRED, required);
                if (first) {
                    HtmlRendererUtils.renderFocus(id, select.isFocus(), ComponentUtils.isError((UIInput)select), facesContext, writer);
                    first = false;
                }
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, select.getTabIndex());
                writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, select)));
                writer.endElement(HtmlElements.INPUT);
                writer.startElement(HtmlElements.LABEL);
                writer.writeClassAttribute((CssItem)BootstrapClass.CUSTOM_CONTROL_LABEL, this.getCssItems(facesContext, select), new CssItem[0]);
                writer.writeAttribute(HtmlAttributes.FOR, itemId, false);
                if (item instanceof org.apache.myfaces.tobago.model.SelectItem && (image = (tobagoItem = (org.apache.myfaces.tobago.model.SelectItem)item).getImage()) != null) {
                    writer.startElement(HtmlElements.IMG);
                    writer.writeAttribute(HtmlAttributes.SRC, image, true);
                    writer.writeAttribute(HtmlAttributes.ALT, "", false);
                    writer.endElement(HtmlElements.IMG);
                }
                if ((label = item.getLabel()) != null) {
                    writer.writeText(label);
                }
                writer.endElement(HtmlElements.LABEL);
                writer.endElement(HtmlElements.DIV);
            }
            ++i;
        }
    }

    private int[] getRenderRangeList(AbstractUISelectOneRadio select, AbstractUISelectReference reference) {
        int[] indices = StringUtils.getIndices(reference != null ? reference.getRenderRange() : select.getRenderRange());
        return (int[])(indices.length > 0 ? indices : null);
    }

    @Override
    protected void encodeEndField(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
    }

    protected CssItem[] getCssItems(FacesContext facesContext, AbstractUISelectOneRadio select) {
        return null;
    }

    @Override
    protected String getFieldId(FacesContext facesContext, UIComponent component) {
        return component.getClientId(facesContext);
    }
}

