/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.component.Tags;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIProgress;
import org.apache.myfaces.tobago.internal.component.AbstractUIStyle;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.StyleRenderUtils;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.Arias;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlRoleValues;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressRenderer
extends RendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(ProgressRenderer.class);

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIProgress progress = (AbstractUIProgress)component;
        double value = progress.getRangeValue();
        double max = progress.getRangeMax();
        double percent = value / max;
        Markup markup = progress.getMarkup();
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.startElement(HtmlElements.DIV);
        String clientId = progress.getClientId(facesContext);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(markup), false);
        writer.writeClassAttribute((CssItem)TobagoClass.PROGRESS, TobagoClass.PROGRESS.createMarkup(markup), new CssItem[]{BootstrapClass.PROGRESS, progress.getCustomClass()});
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)progress);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(BootstrapClass.PROGRESS_BAR);
        writer.writeAttribute(HtmlAttributes.ROLE, HtmlRoleValues.PROGRESSBAR.toString(), false);
        writer.writeAttribute((MarkupLanguageAttributes)Arias.VALUEMIN, 0);
        writer.writeAttribute((MarkupLanguageAttributes)Arias.VALUEMAX, 100);
        writer.writeAttribute(Arias.VALUENOW, String.valueOf((int)percent * 100), false);
        AbstractUIStyle style = (AbstractUIStyle)facesContext.getApplication().createComponent(facesContext, Tags.style.componentType(), RendererTypes.Style.name());
        style.setTransient(true);
        style.setSelector(StyleRenderUtils.encodeIdSelector(clientId) + ">." + BootstrapClass.PROGRESS_BAR.getName());
        style.setWidth(new Measure(percent * 100.0, Measure.Unit.PERCENT));
        progress.getChildren().add(style);
        writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, progress)));
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.endElement(HtmlElements.DIV);
        writer.endElement(HtmlElements.DIV);
    }
}

