/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.ThemeResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeImpl
implements Theme,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ThemeImpl.class);
    private String name;
    private String displayName;
    private ThemeImpl fallback;
    private String fallbackName;
    private List<Theme> fallbackList;
    private ThemeResources productionResources;
    private ThemeResources resources = new ThemeResources(false);
    private String[] productionScripts;
    private String[] productionStyles;
    private String[] scripts;
    private String[] styles;
    private boolean versioned;
    private String version;
    private boolean unmodifiable = false;

    public ThemeImpl() {
        this.productionResources = new ThemeResources(true);
    }

    private void checkLocked() throws IllegalStateException {
        if (this.unmodifiable) {
            throw new IllegalStateException("The configuration must not be changed after initialization!");
        }
    }

    public void lock() {
        this.unmodifiable = true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.checkLocked();
        this.name = name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.checkLocked();
        this.displayName = displayName;
    }

    public ThemeImpl getFallback() {
        return this.fallback;
    }

    public void setFallback(ThemeImpl fallback) {
        this.checkLocked();
        this.fallback = fallback;
    }

    public String getFallbackName() {
        return this.fallbackName;
    }

    public void setFallbackName(String fallbackName) {
        this.checkLocked();
        this.fallbackName = fallbackName;
    }

    @Override
    public List<Theme> getFallbackList() {
        return this.fallbackList;
    }

    public void resolveFallbacks() {
        this.checkLocked();
        this.fallbackList = new ArrayList<Theme>();
        for (ThemeImpl actual = this; actual != null; actual = actual.getFallback()) {
            this.fallbackList.add(actual);
        }
        this.fallbackList = Collections.unmodifiableList(this.fallbackList);
        if (LOG.isDebugEnabled()) {
            LOG.debug("fallbackList: {");
            for (Theme theme : this.fallbackList) {
                LOG.debug("  theme: {}", (Object)theme.getName());
            }
            LOG.debug("}");
        }
    }

    public void resolveResources() {
        this.checkLocked();
        ThemeImpl fallbackTheme = this.getFallback();
        if (fallbackTheme != null) {
            fallbackTheme.resolveResources();
            this.addResources(fallbackTheme.getProductionResources());
            this.addResources(fallbackTheme.getResources());
        }
    }

    public ThemeResources getResources() {
        return this.resources;
    }

    public ThemeResources getProductionResources() {
        return this.productionResources;
    }

    private void addResources(ThemeResources themeResources) {
        this.checkLocked();
        if (themeResources.isProduction()) {
            this.productionResources.merge(themeResources);
        } else {
            this.resources.merge(themeResources);
        }
    }

    public void init() {
        int i;
        this.checkLocked();
        this.productionScripts = new String[this.productionResources.getScriptList().size()];
        for (i = 0; i < this.productionResources.getScriptList().size(); ++i) {
            this.productionScripts[i] = this.productionResources.getScriptList().get(i).getName();
        }
        this.productionStyles = new String[this.productionResources.getStyleList().size()];
        for (i = 0; i < this.productionResources.getStyleList().size(); ++i) {
            this.productionStyles[i] = this.productionResources.getStyleList().get(i).getName();
        }
        this.scripts = new String[this.resources.getScriptList().size()];
        for (i = 0; i < this.resources.getScriptList().size(); ++i) {
            this.scripts[i] = this.resources.getScriptList().get(i).getName();
        }
        this.styles = new String[this.resources.getStyleList().size()];
        for (i = 0; i < this.resources.getStyleList().size(); ++i) {
            this.styles[i] = this.resources.getStyleList().get(i).getName();
        }
    }

    @Override
    public String[] getScriptResources(boolean production) {
        if (production) {
            return this.productionScripts;
        }
        return this.scripts;
    }

    @Override
    public String[] getStyleResources(boolean production) {
        if (production) {
            return this.productionStyles;
        }
        return this.styles;
    }

    public boolean isVersioned() {
        this.checkLocked();
        return this.versioned;
    }

    public void setVersioned(boolean versioned) {
        this.checkLocked();
        this.versioned = versioned;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.checkLocked();
        this.version = version;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Theme:  name='");
        builder.append(this.name);
        builder.append("' fallback=");
        if (this.fallback != null) {
            builder.append("'");
            builder.append(this.fallback.getName());
            builder.append("'");
        } else {
            builder.append("null");
        }
        builder.append(", \nproductionScripts=[");
        for (String s : this.productionScripts != null ? this.productionScripts : new String[]{}) {
            builder.append("\n");
            builder.append(s);
        }
        builder.append("], \nscripts=[");
        for (String s : this.scripts != null ? this.scripts : new String[]{}) {
            builder.append("\n");
            builder.append(s);
        }
        builder.append("], \nproductionStyles=[");
        for (String s : this.productionStyles != null ? this.productionStyles : new String[]{}) {
            builder.append("\n");
            builder.append(s);
        }
        builder.append("], \nstyles=[");
        for (String s : this.styles != null ? this.styles : new String[]{}) {
            builder.append("\n");
            builder.append(s);
        }
        return builder.toString();
    }
}

