/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeLabel;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeListbox;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeLabelRenderer
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(TreeLabelRenderer.class);

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIData data = (AbstractUIData)ComponentUtils.findAncestor((UIComponent)component, AbstractUIData.class);
        boolean listbox = data instanceof AbstractUITreeListbox;
        UITreeLabel label = (UITreeLabel)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        String text = StringUtils.defaultString((String)((String)label.getValue()));
        if (listbox) {
            writer.writeText(text);
        } else {
            writer.startElement("label", (UIComponent)label);
            writer.writeClassAttribute(Classes.create((UIComponent)label));
            HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)label);
            writer.writeStyleAttribute(this.createStyle(facesContext, label));
            String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)label);
            if (title != null) {
                writer.writeAttribute("title", title, true);
            }
            writer.writeText(text);
            writer.endElement("label");
        }
    }

    protected Style createStyle(FacesContext facesContext, UITreeLabel link) {
        return new Style(facesContext, (LayoutBase)link);
    }
}

