/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.tobago.component.SupportsAccessKey;
import org.apache.myfaces.tobago.component.UITreeCommand;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.CommandRendererBase;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.Command;
import org.apache.myfaces.tobago.renderkit.html.CommandMap;
import org.apache.myfaces.tobago.renderkit.html.JsonUtils;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeCommandRenderer
extends CommandRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(TreeCommandRenderer.class);

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        UITreeCommand command = (UITreeCommand)component;
        UITreeNode node = (UITreeNode)ComponentUtils.findAncestor((UIComponent)command, UITreeNode.class);
        command.setDisabled(node.isDisabled());
        super.prepareRender(facesContext, component);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        String title;
        UITreeCommand command = (UITreeCommand)component;
        String clientId = command.getClientId(facesContext);
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        LabelWithAccessKey label = new LabelWithAccessKey((SupportsAccessKey)command);
        boolean disabled = command.isDisabled();
        if (disabled) {
            writer.startElement("span", (UIComponent)command);
        } else {
            writer.startElement("a", (UIComponent)command);
            CommandMap map = new CommandMap(new Command(facesContext, (AbstractUICommand)command));
            writer.writeAttribute("data-tobago-commands", JsonUtils.encode(map), true);
            writer.writeNameAttribute(clientId);
        }
        writer.writeStyleAttribute(this.createStyle(facesContext, command));
        writer.writeClassAttribute(Classes.create((UIComponent)command));
        writer.writeIdAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)command);
        if (!disabled && label.getAccessKey() != null) {
            writer.writeAttribute("accesskey", Character.toString(label.getAccessKey().charValue()), false);
            AccessKeyLogger.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey(), (String)clientId);
        }
        if ((title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)command)) != null) {
            writer.writeAttribute("title", title, true);
        }
        writer.flush();
        HtmlRendererUtils.writeLabelWithAccessKey(writer, label);
    }

    protected Style createStyle(FacesContext facesContext, UITreeCommand link) {
        return new Style(facesContext, (LayoutBase)link);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UITreeCommand command = (UITreeCommand)component;
        ResponseWriter writer = facesContext.getResponseWriter();
        if (command.isDisabled()) {
            writer.endElement("span");
        } else {
            writer.endElement("a");
        }
    }
}

