/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.ThemeResource;
import org.apache.myfaces.tobago.context.ThemeResources;
import org.apache.myfaces.tobago.internal.config.RendererConfig;
import org.apache.myfaces.tobago.internal.config.RenderersConfig;
import org.apache.myfaces.tobago.internal.config.RenderersConfigImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeImpl
implements Theme,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ThemeImpl.class);
    private String name;
    private String displayName;
    private String resourcePath;
    private ThemeImpl fallback;
    private String fallbackName;
    private List<Theme> fallbackList;
    private RenderersConfigImpl renderersConfig;
    private ThemeResources productionResources;
    private ThemeResources resources = new ThemeResources(false);
    private String[] productionScripts;
    private String[] productionStyles;
    private String[] scripts;
    private String[] styles;
    private boolean versioned;
    private String version;
    private boolean unmodifiable = false;

    public ThemeImpl() {
        this.productionResources = new ThemeResources(true);
    }

    private void checkLocked() throws IllegalStateException {
        if (this.unmodifiable) {
            throw new RuntimeException("The configuration must not be changed after initialization!");
        }
    }

    public void lock() {
        this.unmodifiable = true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.checkLocked();
        this.name = name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.checkLocked();
        this.displayName = displayName;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.checkLocked();
        this.resourcePath = resourcePath;
    }

    public ThemeImpl getFallback() {
        return this.fallback;
    }

    public void setFallback(ThemeImpl fallback) {
        this.checkLocked();
        this.fallback = fallback;
    }

    public String getFallbackName() {
        return this.fallbackName;
    }

    public void setFallbackName(String fallbackName) {
        this.checkLocked();
        this.fallbackName = fallbackName;
    }

    @Override
    public List<Theme> getFallbackList() {
        return this.fallbackList;
    }

    public void resolveFallbacks() {
        this.checkLocked();
        this.fallbackList = new ArrayList<Theme>();
        for (ThemeImpl actual = this; actual != null; actual = actual.getFallback()) {
            this.fallbackList.add(actual);
        }
        this.fallbackList = Collections.unmodifiableList(this.fallbackList);
        if (LOG.isDebugEnabled()) {
            for (Theme theme : this.fallbackList) {
                LOG.debug("fallbackList: {}", (Object)theme.getName());
            }
        }
    }

    public void resolveRendererConfig(RenderersConfig rendererConfigFromTobagoConfig) {
        this.checkLocked();
        if (this.renderersConfig == null) {
            this.renderersConfig = new RenderersConfigImpl();
        }
        if (!this.renderersConfig.isMerged()) {
            ThemeImpl fallbackTheme = this.getFallback();
            if (fallbackTheme != null) {
                fallbackTheme.resolveRendererConfig(rendererConfigFromTobagoConfig);
                RenderersConfigImpl fallbackRenderersConfig = fallbackTheme.getRenderersConfigImpl();
                if (fallbackRenderersConfig != null) {
                    this.renderersConfig.merge(fallbackRenderersConfig, false);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("merge markupconfig from {} for {}", (Object)fallbackTheme.getName(), (Object)this.getName());
                    }
                }
            }
            if (rendererConfigFromTobagoConfig != null) {
                this.renderersConfig.merge(rendererConfigFromTobagoConfig, true);
            }
            this.renderersConfig.setMerged(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} {}", (Object)this.getName(), (Object)this.renderersConfig);
            }
        }
    }

    public void resolveResources() {
        this.checkLocked();
        ThemeImpl fallbackTheme = this.getFallback();
        if (fallbackTheme != null) {
            fallbackTheme.resolveResources();
            this.addResources(fallbackTheme.getProductionResources());
            this.addResources(fallbackTheme.getResources());
        }
    }

    public void setRenderersConfig(RenderersConfigImpl renderersConfig) {
        this.checkLocked();
        this.renderersConfig = renderersConfig;
    }

    @Override
    public RenderersConfig getRenderersConfig() {
        return this.renderersConfig;
    }

    RenderersConfigImpl getRenderersConfigImpl() {
        return this.renderersConfig;
    }

    public ThemeResources getResources() {
        return this.resources;
    }

    public ThemeResources getProductionResources() {
        return this.productionResources;
    }

    public void addResources(ThemeResources themeResources) {
        this.checkLocked();
        if (themeResources.isProduction()) {
            this.productionResources.merge(themeResources);
        } else {
            this.resources.merge(themeResources);
        }
    }

    public void init() {
        this.checkLocked();
        this.productionScripts = this.sort(this.productionResources.getScriptList());
        this.productionStyles = this.sort(this.productionResources.getStyleList());
        this.scripts = this.sort(this.resources.getScriptList());
        this.styles = this.sort(this.resources.getStyleList());
    }

    private String[] sort(List<? extends ThemeResource> list) {
        ArrayList<? extends ThemeResource> copy = new ArrayList<ThemeResource>(list);
        Collections.sort(copy, new ThemeResourceComparator());
        String[] result = new String[copy.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ((ThemeResource)copy.get(i)).getName();
        }
        return result;
    }

    @Override
    public String[] getScriptResources(boolean production) {
        if (production) {
            return this.productionScripts;
        }
        return this.scripts;
    }

    @Override
    public String[] getStyleResources(boolean production) {
        if (production) {
            return this.productionStyles;
        }
        return this.styles;
    }

    public boolean isVersioned() {
        this.checkLocked();
        return this.versioned;
    }

    public void setVersioned(boolean versioned) {
        this.checkLocked();
        this.versioned = versioned;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.checkLocked();
        this.version = version;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Theme: name='");
        builder.append(this.name);
        builder.append("' fallback=");
        if (this.fallback != null) {
            builder.append("'");
            builder.append(this.fallback.getName());
            builder.append("'");
        } else {
            builder.append("null");
        }
        builder.append(", \nproductionScripts=[");
        for (String s : this.productionScripts != null ? this.productionScripts : new String[]{}) {
            builder.append("\n");
            builder.append(s);
        }
        builder.append("], \nscripts=[");
        for (String s : this.scripts != null ? this.scripts : new String[]{}) {
            builder.append("\n");
            builder.append(s);
        }
        builder.append("], \nproductionStyles=[");
        for (String s : this.productionStyles != null ? this.productionStyles : new String[]{}) {
            builder.append("\n");
            builder.append(s);
        }
        builder.append("], \nstyles=[");
        for (String s : this.styles != null ? this.styles : new String[]{}) {
            builder.append("\n");
            builder.append(s);
        }
        if (this.renderersConfig != null) {
            builder.append("\n");
            for (RendererConfig config : this.renderersConfig.getRendererConfigs()) {
                builder.append(config);
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    private static class ThemeResourceComparator
    implements Comparator<ThemeResource> {
        private ThemeResourceComparator() {
        }

        @Override
        public int compare(ThemeResource o1, ThemeResource o2) {
            return o1.getPriority() - o2.getPriority();
        }
    }
}

