/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.jsp.JspException;
import org.apache.myfaces.tobago.component.UIScript;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScriptTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptTag.class);
    private ValueExpression file;
    private ValueExpression onunload;
    private ValueExpression onexit;
    private ValueExpression onsubmit;
    private ValueExpression script;
    private ValueExpression onload;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.Script";
    }

    public String getRendererType() {
        return "Script";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UIScript component = (UIScript)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.file != null) {
            component.setValueExpression("file", this.file);
        }
        if (this.onunload != null) {
            component.setValueExpression("onunload", this.onunload);
        }
        if (this.onexit != null) {
            component.setValueExpression("onexit", this.onexit);
        }
        if (this.onsubmit != null) {
            component.setValueExpression("onsubmit", this.onsubmit);
        }
        if (this.script != null) {
            component.setValueExpression("script", this.script);
        }
        if (this.onload != null) {
            component.setValueExpression("onload", this.onload);
        }
    }

    public ValueExpression getFile() {
        return this.file;
    }

    public void setFile(ValueExpression file) {
        this.file = file;
    }

    public ValueExpression getOnunload() {
        return this.onunload;
    }

    public void setOnunload(ValueExpression onunload) {
        this.onunload = onunload;
    }

    public ValueExpression getOnexit() {
        return this.onexit;
    }

    public void setOnexit(ValueExpression onexit) {
        this.onexit = onexit;
    }

    public ValueExpression getOnsubmit() {
        return this.onsubmit;
    }

    public void setOnsubmit(ValueExpression onsubmit) {
        this.onsubmit = onsubmit;
    }

    public ValueExpression getScript() {
        return this.script;
    }

    public void setScript(ValueExpression script) {
        this.script = script;
    }

    public ValueExpression getOnload() {
        return this.onload;
    }

    public void setOnload(ValueExpression onload) {
        this.onload = onload;
    }

    public int doAfterBody() throws JspException {
        String content = this.bodyContent.getString();
        this.bodyContent.clearBody();
        if (StringUtils.isNotBlank(content)) {
            UIScript component = (UIScript)this.getComponentInstance();
            component.setScript(content.trim());
        }
        return super.doAfterBody();
    }

    public void release() {
        super.release();
        this.file = null;
        this.onunload = null;
        this.onexit = null;
        this.onsubmit = null;
        this.script = null;
        this.onload = null;
    }
}

