/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.facelets.extension;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import org.apache.myfaces.tobago.component.UIDatePicker;
import org.apache.myfaces.tobago.component.UIForm;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.facelets.extension.TobagoLabelExtensionHandler;

public class DateExtensionHandler
extends TobagoLabelExtensionHandler {
    private TagAttribute pickerIdAttribute = this.getAttribute("pickerId");
    private TagAttribute formIdAttribute = this.getAttribute("formId");
    private TagAttribute markupAttribute = this.getAttribute("markup");

    public DateExtensionHandler(ComponentConfig config) {
        super(config);
    }

    @Override
    protected String getSubComponentType() {
        return "org.apache.myfaces.tobago.Date";
    }

    @Override
    protected String getSubRendererType() {
        return "Date";
    }

    @Override
    public void onComponentPopulated(FaceletContext faceletContext, UIComponent panel, UIComponent parent) {
        super.onComponentPopulated(faceletContext, panel, parent);
        if (!TobagoConfig.getInstance(faceletContext.getFacesContext()).isClassicDateTimePicker()) {
            return;
        }
        if (panel.getChildCount() == 2) {
            Application application = faceletContext.getFacesContext().getApplication();
            UIForm form = (UIForm)application.createComponent("org.apache.myfaces.tobago.Form");
            form.setRendererType("Form");
            String formId = this.formIdAttribute != null ? this.formIdAttribute.getValue(faceletContext) : panel.getId() + "_tx_form";
            form.setId(formId);
            panel.getChildren().add(form);
            UIDatePicker picker = (UIDatePicker)application.createComponent("org.apache.myfaces.tobago.DatePicker");
            picker.setRendererType("DatePicker");
            picker.setFor("@auto");
            String pickerId = this.pickerIdAttribute != null ? this.pickerIdAttribute.getValue(faceletContext) : panel.getId() + "_tx_picker";
            picker.setId(pickerId);
            if (picker.getAttributes().get("org.apache.myfaces.tobago.OnComponentCreated.MARKER") == null) {
                picker.getAttributes().put("org.apache.myfaces.tobago.OnComponentCreated.MARKER", Boolean.TRUE);
                picker.onComponentCreated(faceletContext.getFacesContext(), panel);
            }
            if (this.markupAttribute != null) {
                if (this.markupAttribute.isLiteral()) {
                    picker.setMarkup(Markup.valueOf(this.markupAttribute.getValue()));
                } else {
                    ValueExpression expression = this.markupAttribute.getValueExpression(faceletContext, Object.class);
                    picker.setValueExpression("markup", expression);
                }
            }
            form.getChildren().add(picker);
        }
    }

    @Override
    protected String getColumns(String first) {
        if (TobagoConfig.getInstance(FacesContext.getCurrentInstance()).isClassicDateTimePicker()) {
            return first + ";*;auto";
        }
        return super.getColumns(first);
    }
}

