/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.conversation.spring;

import org.apache.myfaces.orchestra.conversation.Conversation;
import org.apache.myfaces.orchestra.conversation.ConversationAccessLifetimeAspect;
import org.apache.myfaces.orchestra.conversation.ConversationContext;
import org.apache.myfaces.orchestra.conversation.ConversationTimeoutableAspect;
import org.apache.myfaces.orchestra.conversation.spring.AbstractSpringOrchestraScope;
import org.apache.myfaces.orchestra.conversation.spring.SpringConversationBinder;

public class SpringConversationScope
extends AbstractSpringOrchestraScope {
    public static final String LIFETIME_FLASH = "flash";
    public static final String LIFETIME_ACCESS = "access";
    public static final String LIFETIME_MANUAL = "manual";
    private Integer timeout;
    private String lifetime = "manual";

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public String getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(String lifetime) {
        if (LIFETIME_FLASH.equals(lifetime)) {
            this.lifetime = LIFETIME_ACCESS;
        } else if (LIFETIME_ACCESS.equals(lifetime)) {
            this.lifetime = LIFETIME_ACCESS;
        } else if (LIFETIME_MANUAL.equals(lifetime)) {
            this.lifetime = LIFETIME_MANUAL;
        } else {
            throw new IllegalArgumentException("Invalid lifetime:" + lifetime);
        }
    }

    public Conversation createConversation(ConversationContext context, String name) {
        Conversation conversation = new Conversation(context, name, this);
        conversation.setBinder(new SpringConversationBinder(this, conversation));
        this.initAspects(conversation);
        return conversation;
    }

    protected void initAspects(Conversation conversation) {
        if (this.timeout != null) {
            long timeoutMsecs = this.timeout.longValue() * 60L * 1000L;
            ConversationTimeoutableAspect aspect = new ConversationTimeoutableAspect(conversation);
            aspect.setTimeout(timeoutMsecs);
            conversation.addAspect(aspect);
        }
        if (LIFETIME_ACCESS.equals(this.lifetime)) {
            ConversationAccessLifetimeAspect aspect = new ConversationAccessLifetimeAspect(conversation);
            conversation.addAspect(aspect);
        }
    }

    protected void notifyAccessConversation(Conversation conversation) {
        super.notifyAccessConversation(conversation);
        ConversationAccessLifetimeAspect aspect = (ConversationAccessLifetimeAspect)conversation.getAspect(ConversationAccessLifetimeAspect.class);
        if (aspect != null) {
            aspect.markAsAccessed();
        }
    }
}

