/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.conversation.spring;

import java.util.Stack;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import org.apache.myfaces.orchestra.conversation.spring.PersistenceContext;
import org.apache.myfaces.orchestra.conversation.spring.PersistenceContextFactory;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JpaPersistenceContextFactory
implements PersistenceContextFactory {
    private EntityManagerFactory entityManagerFactory;

    public PersistenceContext create() {
        final EntityManager em = this.entityManagerFactory.createEntityManager();
        em.setFlushMode(FlushModeType.COMMIT);
        return new PersistenceContext(){
            private final Stack bindings = new Stack();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void bind() {
                Stack stack = this.bindings;
                synchronized (stack) {
                    EntityManagerHolder current = (EntityManagerHolder)TransactionSynchronizationManager.getResource((Object)JpaPersistenceContextFactory.this.entityManagerFactory);
                    if (current != null) {
                        TransactionSynchronizationManager.unbindResource((Object)JpaPersistenceContextFactory.this.entityManagerFactory);
                    }
                    this.bindings.push(current);
                    TransactionSynchronizationManager.bindResource((Object)JpaPersistenceContextFactory.this.entityManagerFactory, (Object)new EntityManagerHolder(em));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void unbind() {
                Stack stack = this.bindings;
                synchronized (stack) {
                    if (TransactionSynchronizationManager.hasResource((Object)JpaPersistenceContextFactory.this.entityManagerFactory)) {
                        TransactionSynchronizationManager.unbindResource((Object)JpaPersistenceContextFactory.this.entityManagerFactory);
                    }
                    Object holder = null;
                    if (this.bindings.size() > 0) {
                        holder = this.bindings.pop();
                    }
                    if (holder != null) {
                        TransactionSynchronizationManager.bindResource((Object)JpaPersistenceContextFactory.this.entityManagerFactory, holder);
                    }
                }
            }

            public void close() {
                em.close();
            }
        };
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }
}

