/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.conversation.jsf.components;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.myfaces.orchestra.lib.jsf.SerializableConverter;

public class ConverterTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private String beanName;
    private boolean useWrapper = true;

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setUseWrapper(boolean enabled) {
        this.useWrapper = enabled;
    }

    public int doStartTag() throws JspException {
        UIComponent component;
        UIComponentTag componentTag = UIComponentTag.getParentUIComponentTag((PageContext)this.pageContext);
        if (componentTag == null) {
            throw new JspException("no parent UIComponentTag found");
        }
        if (!componentTag.getCreated()) {
            return 0;
        }
        Converter converter = ConverterTag.createConverter(this.beanName);
        if (this.useWrapper && !(converter instanceof SerializableConverter)) {
            converter = new SerializableConverter(this.beanName, converter);
        }
        if ((component = componentTag.getComponentInstance()) == null) {
            throw new JspException("parent UIComponentTag has no UIComponent");
        }
        if (!(component instanceof ValueHolder)) {
            throw new JspException("UIComponent is no ValueHolder");
        }
        ((ValueHolder)component).setConverter(converter);
        return 0;
    }

    public void release() {
        super.release();
        this.beanName = null;
    }

    protected static Converter createConverter(String beanName) throws JspException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        Object converter = application.getVariableResolver().resolveVariable(facesContext, beanName);
        return (Converter)converter;
    }
}

