/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.conversation;

import java.io.IOException;
import org.apache.myfaces.orchestra.conversation.Conversation;
import org.apache.myfaces.orchestra.conversation.ConversationManager;
import org.apache.myfaces.orchestra.conversation.CurrentConversationInfo;
import org.apache.myfaces.orchestra.frameworkAdapter.FrameworkAdapter;

public final class ConversationUtils {
    private ConversationUtils() {
    }

    public static Object invalidateAndRestart(Conversation conversation) {
        String name = conversation.getName();
        conversation.invalidateAndRestart();
        return FrameworkAdapter.getCurrentInstance().getBean(name);
    }

    public static Object getCurrentBean() {
        CurrentConversationInfo currentConversationInfo = Conversation.getCurrentInstanceInfo();
        if (currentConversationInfo == null) {
            return null;
        }
        String name = currentConversationInfo.getBeanName();
        return FrameworkAdapter.getCurrentInstance().getBean(name);
    }

    public static Object invalidateAndRestartCurrent() {
        CurrentConversationInfo currentConversationInfo = Conversation.getCurrentInstanceInfo();
        String name = currentConversationInfo.getBeanName();
        currentConversationInfo.getConversation().invalidateAndRestart();
        return FrameworkAdapter.getCurrentInstance().getBean(name);
    }

    public static void ensureConversationRedirect(String conversationName, String redirectViewId) {
        if (!ConversationManager.getInstance().hasConversation(conversationName)) {
            try {
                FrameworkAdapter.getCurrentInstance().redirect(redirectViewId);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void invalidateIfExists(String name) {
        Conversation conversation = ConversationManager.getInstance().getConversation(name);
        if (conversation != null) {
            conversation.invalidate();
        }
    }

    public static Object bindToCurrent(Object instance) {
        return Conversation.getCurrentInstance().bind(instance);
    }
}

