/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.viewController;


/**
 * Find the appropriate method to invoke on a bean for each view lifecycle event.
 * <p>
 * Note that each method implementation is expected to return false if no matching
 * method could be found. This allows ViewControllerExecutor implementations to
 * be "chained" with others.
 * <p>
 * Warning: it is not recommended that code implement this interface directly;
 * Orchestra reserves the right to change this interface in minor releases. Instead,
 * subclass the class AbstractViewControllerExecutor.
 * <p>
 * @see org.apache.myfaces.orchestra.viewController.AbstractViewControllerManager
 */
public interface ViewControllerExecutor
{
    public boolean invokeInitView(String beanName, Object bean);

    public boolean invokePreRenderView(String beanName, Object bean);

    public boolean invokePreProcess(String beanName, Object bean);
}