/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.crossval.strategy;

import java.lang.annotation.Annotation;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.extensions.validator.core.metadata.MetaDataEntry;
import org.apache.myfaces.extensions.validator.core.validation.strategy.AbstractAnnotationValidationStrategy;
import org.apache.myfaces.extensions.validator.core.validation.strategy.ValidationStrategy;
import org.apache.myfaces.extensions.validator.crossval.storage.CrossValidationStorageEntry;
import org.apache.myfaces.extensions.validator.crossval.strategy.CrossValidationStrategy;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.CrossValidationUtils;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public abstract class AbstractCrossValidationStrategy<A extends Annotation>
extends AbstractAnnotationValidationStrategy<A>
implements CrossValidationStrategy {
    public void processValidation(FacesContext facesContext, UIComponent uiComponent, MetaDataEntry metaDataEntry, Object convertedObject) throws ValidatorException {
        CrossValidationStorageEntry entry = this.getCrossValidationStorageEntry(facesContext, uiComponent, metaDataEntry, convertedObject);
        CrossValidationUtils.getOrInitCrossValidationStorage().add(entry);
    }

    @Override
    public CrossValidationStorageEntry getCrossValidationStorageEntry(FacesContext facesContext, UIComponent uiComponent, MetaDataEntry metaDataEntry, Object convertedObject) {
        CrossValidationStorageEntry entry = new CrossValidationStorageEntry();
        entry.setMetaDataEntry(metaDataEntry);
        entry.setComponent(uiComponent);
        entry.setClientId(uiComponent.getClientId(facesContext));
        entry.setConvertedObject(convertedObject);
        entry.setValidationStrategy(this);
        return entry;
    }

    protected final boolean processAfterValidatorException(FacesContext facesContext, UIComponent uiComponent, MetaDataEntry metaDataEntry, Object convertedObject, ValidatorException validatorException) {
        throw new IllegalStateException("not available for cross validation - use processAfterCrossValidatorException");
    }

    protected final String getLabel(FacesContext facesContext, UIComponent uiComponent, MetaDataEntry metaDataEntry) {
        throw new IllegalStateException("not available for cross validation");
    }

    protected final void initValidation(FacesContext facesContext, UIComponent uiComponent, MetaDataEntry metaDataEntry, Object convertedObject) {
    }

    protected void initCrossValidation(CrossValidationStorageEntry crossValidationStorageEntry) {
    }

    protected boolean processAfterCrossValidatorException(CrossValidationStorageEntry crossValidationStorageEntry, ValidatorException validatorException) {
        return ExtValUtils.executeAfterThrowingInterceptors((UIComponent)crossValidationStorageEntry.getComponent(), (MetaDataEntry)crossValidationStorageEntry.getMetaDataEntry(), (Object)crossValidationStorageEntry.getConvertedObject(), (ValidatorException)validatorException, (ValidationStrategy)this);
    }
}

