/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.beanval.interceptor;

import java.util.Map;
import javax.faces.component.UIComponent;
import org.apache.myfaces.extensions.validator.beanval.BeanValidationModuleKey;
import org.apache.myfaces.extensions.validator.beanval.util.BeanValidationUtils;
import org.apache.myfaces.extensions.validator.core.InvocationOrder;
import org.apache.myfaces.extensions.validator.core.ValidationModuleAware;
import org.apache.myfaces.extensions.validator.core.interceptor.MetaDataExtractionInterceptor;
import org.apache.myfaces.extensions.validator.core.property.PropertyDetails;
import org.apache.myfaces.extensions.validator.core.property.PropertyInformation;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.extensions.validator.util.JsfUtils;

@InvocationOrder(value=200)
@UsageInformation(value={UsageCategory.INTERNAL})
public class ExtValBeanValidationMetaDataExtractionInterceptor
implements MetaDataExtractionInterceptor,
ValidationModuleAware {
    public void afterExtracting(PropertyInformation propertyInformation) {
        Map properties;
        if (propertyInformation.containsInformation("custom_properties") && (properties = (Map)propertyInformation.getInformation("custom_properties", Map.class)) != null && properties.containsKey(UIComponent.class.getName())) {
            UIComponent uiComponent = (UIComponent)properties.get(UIComponent.class.getName());
            PropertyDetails propertyDetails = ExtValUtils.getPropertyDetails((PropertyInformation)propertyInformation);
            if (propertyDetails != null) {
                this.processExtValBeanValidationMetaData(uiComponent, propertyDetails);
            }
        }
    }

    private void processExtValBeanValidationMetaData(UIComponent uiComponent, PropertyDetails propertyDetails) {
        if (propertyDetails.getKey() == null) {
            return;
        }
        if (JsfUtils.isRenderResponsePhase()) {
            BeanValidationUtils.addMetaDataToContext(uiComponent, propertyDetails, false);
        } else {
            BeanValidationUtils.addMetaDataToContext(uiComponent, propertyDetails, true);
        }
    }

    public String[] getModuleKeys() {
        return new String[]{BeanValidationModuleKey.class.getName()};
    }
}

