/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.trinidad.validation.message;

import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.validator.core.validation.message.LabeledMessage;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;
import org.apache.myfaces.trinidad.util.LabeledFacesMessage;

@UsageInformation(value={UsageCategory.INTERNAL})
class TrinidadViolationMessage
extends LabeledFacesMessage
implements LabeledMessage {
    private static final long serialVersionUID = 6356800689961505154L;
    public static final String MISSING_RESOURCE_MARKER = "???";

    public TrinidadViolationMessage(FacesMessage.Severity severity, String summary, String detail) {
        super(severity, summary, detail);
    }

    public String getLabelText() {
        return super.getLabelAsString(FacesContext.getCurrentInstance());
    }

    public String getSummary() {
        FacesMessage result = this.tryToPlaceLabel(super.getSummary());
        if (result != null) {
            super.setSummary(result.getSummary());
            return result.getSummary();
        }
        return super.getSummary();
    }

    public String getDetail() {
        FacesMessage result = this.tryToPlaceLabel(super.getDetail());
        if (result != null) {
            super.setDetail(result.getDetail());
            return result.getDetail();
        }
        return super.getDetail();
    }

    private FacesMessage tryToPlaceLabel(String originalMessage) {
        if (this.isValidMessage(originalMessage)) {
            FacesMessage newFacesMessage = this.createOriginalFacesMessage();
            this.tryToPlaceLabelIn(newFacesMessage);
            return newFacesMessage;
        }
        return null;
    }

    private FacesMessage createOriginalFacesMessage() {
        return new FacesMessage(super.getSeverity(), super.getSummary(), super.getDetail());
    }

    private void tryToPlaceLabelIn(FacesMessage newFacesMessage) {
        String label = this.getLabelText();
        if (label != null) {
            for (int i = 0; i < 3; ++i) {
                ExtValUtils.tryToPlaceLabel((FacesMessage)newFacesMessage, (String)label, (int)i);
            }
        }
    }

    private boolean isValidMessage(String originalMessage) {
        return originalMessage == null || !originalMessage.startsWith(MISSING_RESOURCE_MARKER) || !originalMessage.endsWith(MISSING_RESOURCE_MARKER);
    }

    public void setLabelText(String label) {
        super.setLabel((Object)label);
    }
}

