/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.faces;

import jakarta.faces.FacesException;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIPanel;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.UniqueIdVendor;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributeException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.core.api.shared.lang.SharedStringBuilder;
import org.apache.myfaces.view.facelets.ComponentState;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguage;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguageBase;
import org.apache.myfaces.view.facelets.tag.faces.FaceletState;

public final class ComponentSupport {
    private static final Logger LOG = Logger.getLogger(ComponentSupport.class.getName());
    private static final String SB_GET_FIND_COMPONENT_EXPR = ComponentSupport.class.getName() + "#getFindComponentExpression";
    private static final Method SET_CACHED_FACES_CONTEXT;
    public static final String MARK_CREATED = "oam.vf.MARK_ID";
    public static final String FACET_CREATED_UIPANEL_MARKER = "oam.vf.createdUIPanel";
    public static final String COMPONENT_ADDED_BY_HANDLER_MARKER = "oam.vf.addedByHandler";
    public static final String FACELET_STATE_INSTANCE = "oam.FACELET_STATE_INSTANCE";

    public static UIComponent findChild(UIComponent parent, String id) {
        int childCount = parent.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)parent.getChildren().get(i);
                if (!id.equals(child.getId())) continue;
                return child;
            }
        }
        return null;
    }

    public static String findFacetNameByComponentInstance(UIComponent parent, UIComponent instance) {
        if (parent.getFacetCount() > 0) {
            for (Map.Entry entry : parent.getFacets().entrySet()) {
                UIComponent facet = (UIComponent)entry.getValue();
                if (Boolean.TRUE.equals(facet.getAttributes().get(FACET_CREATED_UIPANEL_MARKER))) {
                    if (facet.getChildCount() > 0) {
                        int childCount = facet.getChildCount();
                        for (int i = 0; i < childCount; ++i) {
                            UIComponent child = (UIComponent)facet.getChildren().get(i);
                            if (!instance.equals(child)) continue;
                            return (String)entry.getKey();
                        }
                    }
                    if (facet.getFacetCount() <= 0) continue;
                    for (UIComponent child : facet.getFacets().values()) {
                        if (!instance.equals(child)) continue;
                        return (String)entry.getKey();
                    }
                    continue;
                }
                if (!instance.equals(facet)) continue;
                return (String)entry.getKey();
            }
            return null;
        }
        return null;
    }

    public static UIComponent findChildInFacetByTagId(UIComponent parent, String id, String facetName) {
        UIComponent facet;
        if (parent.getFacetCount() > 0 && (facet = parent.getFacet(facetName)) != null) {
            if (Boolean.TRUE.equals(facet.getAttributes().get(FACET_CREATED_UIPANEL_MARKER))) {
                if (facet.getChildCount() > 0) {
                    int childCount = facet.getChildCount();
                    for (int i = 0; i < childCount; ++i) {
                        UIComponent child = (UIComponent)facet.getChildren().get(i);
                        if (!id.equals(child.getAttributes().get(MARK_CREATED))) continue;
                        return child;
                    }
                }
                if (facet.getFacetCount() > 0) {
                    for (UIComponent child : facet.getFacets().values()) {
                        if (!id.equals(child.getAttributes().get(MARK_CREATED))) continue;
                        return child;
                    }
                }
            } else if (id.equals(facet.getAttributes().get(MARK_CREATED))) {
                return facet;
            }
        }
        return null;
    }

    public static UIComponent findChildInChildrenByTagId(UIComponent parent, String id) {
        if (parent.getChildCount() > 0) {
            int childCount = parent.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)parent.getChildren().get(i);
                if (!id.equals(child.getAttributes().get(MARK_CREATED))) continue;
                return child;
            }
        }
        return null;
    }

    public static UIComponent findChildByTagId(UIComponent parent, String id) {
        Iterator itr = null;
        if (parent.getChildCount() > 0) {
            int childCount = parent.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)parent.getChildren().get(i);
                if (!id.equals(child.getAttributes().get(MARK_CREATED))) continue;
                return child;
            }
        }
        if (parent.getFacetCount() > 0) {
            for (UIComponent facet : parent.getFacets().values()) {
                if (Boolean.TRUE.equals(facet.getAttributes().get(FACET_CREATED_UIPANEL_MARKER))) {
                    if (facet.getChildCount() > 0) {
                        int childCount = facet.getChildCount();
                        for (int i = 0; i < childCount; ++i) {
                            UIComponent child = (UIComponent)facet.getChildren().get(i);
                            if (!id.equals(child.getAttributes().get(MARK_CREATED))) continue;
                            return child;
                        }
                    }
                    if (facet.getFacetCount() <= 0) continue;
                    for (UIComponent child : facet.getFacets().values()) {
                        if (!id.equals(child.getAttributes().get(MARK_CREATED))) continue;
                        return child;
                    }
                    continue;
                }
                if (!id.equals(facet.getAttributes().get(MARK_CREATED))) continue;
                return facet;
            }
        }
        return null;
    }

    public static String findChildInFacetsByTagId(UIComponent parent, String id) {
        Iterator itr = null;
        if (parent.getFacetCount() > 0) {
            for (Map.Entry entry : parent.getFacets().entrySet()) {
                UIComponent facet = (UIComponent)entry.getValue();
                if (Boolean.TRUE.equals(facet.getAttributes().get(FACET_CREATED_UIPANEL_MARKER))) {
                    if (facet.getChildCount() > 0) {
                        int childCount = facet.getChildCount();
                        for (int i = 0; i < childCount; ++i) {
                            UIComponent child = (UIComponent)facet.getChildren().get(i);
                            if (!id.equals(child.getAttributes().get(MARK_CREATED))) continue;
                            return (String)entry.getKey();
                        }
                    }
                    if (facet.getFacetCount() <= 0) continue;
                    for (UIComponent child : facet.getFacets().values()) {
                        if (!id.equals(child.getAttributes().get(MARK_CREATED))) continue;
                        return (String)entry.getKey();
                    }
                    continue;
                }
                if (!id.equals(facet.getAttributes().get(MARK_CREATED))) continue;
                return (String)entry.getKey();
            }
        }
        return null;
    }

    public static Locale getLocale(FaceletContext ctx, TagAttribute attr) throws TagAttributeException {
        Object obj = attr.getObject(ctx);
        if (obj instanceof Locale) {
            return (Locale)obj;
        }
        if (obj instanceof String) {
            String s = (String)obj;
            if (s.length() == 2) {
                return new Locale(s);
            }
            if (s.length() == 5) {
                return new Locale(s.substring(0, 2), s.substring(3, 5).toUpperCase());
            }
            if (s.length() >= 7) {
                return new Locale(s.substring(0, 2), s.substring(3, 5).toUpperCase(), s.substring(6, s.length()));
            }
            throw new TagAttributeException(attr, "Invalid Locale Specified: " + s);
        }
        throw new TagAttributeException(attr, "Attribute did not evaluate to a String or Locale: " + obj);
    }

    public static UIViewRoot getViewRoot(FaceletContext ctx, UIComponent parent) {
        UIComponent c = parent;
        do {
            if (!(c instanceof UIViewRoot)) continue;
            return (UIViewRoot)c;
        } while ((c = c.getParent()) != null);
        UIViewRoot root = ctx.getFacesContext().getViewRoot();
        if (root == null) {
            root = FaceletCompositionContext.getCurrentInstance(ctx).getViewRoot(ctx.getFacesContext());
        }
        return root;
    }

    public static void encodeRecursive(FacesContext context, UIComponent toRender) throws IOException, FacesException {
        if (toRender.isRendered()) {
            toRender.encodeBegin(context);
            if (toRender.getRendersChildren()) {
                toRender.encodeChildren(context);
            } else if (toRender.getChildCount() > 0) {
                int childCount = toRender.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    UIComponent child = (UIComponent)toRender.getChildren().get(i);
                    ComponentSupport.encodeRecursive(context, child);
                }
            }
            toRender.encodeEnd(context);
        }
    }

    public static void removeTransient(UIComponent component) {
        if (component.getChildCount() > 0) {
            Iterator itr = component.getChildren().iterator();
            while (itr.hasNext()) {
                UIComponent child = (UIComponent)itr.next();
                if (child.isTransient()) {
                    itr.remove();
                    continue;
                }
                ComponentSupport.removeTransient(child);
            }
        }
        if (component.getFacetCount() > 0) {
            Map facets = component.getFacets();
            Iterator itr = facets.values().iterator();
            while (itr.hasNext()) {
                UIComponent facet = (UIComponent)itr.next();
                if (facet.isTransient()) {
                    itr.remove();
                    continue;
                }
                ComponentSupport.removeTransient(facet);
            }
        }
    }

    private static UIComponent createFacetUIPanel(FaceletContext ctx, UIComponent parent, String facetName) {
        FacesContext facesContext = ctx.getFacesContext();
        UIComponent panel = facesContext.getApplication().createComponent(facesContext, "jakarta.faces.Panel", null);
        FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(ctx);
        UniqueIdVendor uniqueIdVendor = mctx.getUniqueIdVendorFromStack();
        if (uniqueIdVendor == null) {
            uniqueIdVendor = ComponentSupport.getViewRoot(ctx, parent);
        }
        if (uniqueIdVendor != null) {
            String cleanFacetName = facetName.replace('.', '_').replace('{', '_').replace('}', '_');
            panel.setId(uniqueIdVendor.createUniqueId(facesContext, mctx.getSharedStringBuilder().append(parent.getId()).append("__f_").append(cleanFacetName).toString()));
        }
        panel.getAttributes().put(FACET_CREATED_UIPANEL_MARKER, Boolean.TRUE);
        panel.getAttributes().put(COMPONENT_ADDED_BY_HANDLER_MARKER, Boolean.TRUE);
        return panel;
    }

    public static void addFacet(FaceletContext ctx, UIComponent parent, UIComponent c, String facetName) {
        UIComponent facet = (UIComponent)parent.getFacets().get(facetName);
        if (facet == null) {
            parent.getFacets().put(facetName, c);
        } else if (!(facet instanceof UIPanel)) {
            UIComponent child = facet;
            facet = ComponentSupport.createFacetUIPanel(ctx, parent, facetName);
            facet.getChildren().add(child);
            facet.getChildren().add(c);
            parent.getFacets().put(facetName, facet);
        } else if (Boolean.TRUE.equals(facet.getAttributes().get(FACET_CREATED_UIPANEL_MARKER))) {
            facet.getChildren().add(c);
        } else {
            UIComponent oldPanel = facet;
            facet = ComponentSupport.createFacetUIPanel(ctx, parent, facetName);
            facet.getChildren().add(oldPanel);
            facet.getChildren().add(c);
            parent.getFacets().put(facetName, facet);
        }
    }

    public static void removeFacet(FaceletContext ctx, UIComponent parent, UIComponent c, String facetName) {
        UIComponent facet = parent.getFacet(facetName);
        if (Boolean.TRUE.equals(facet.getAttributes().get(FACET_CREATED_UIPANEL_MARKER))) {
            facet.getChildren().remove(c);
        } else {
            parent.getFacets().remove(facetName);
        }
    }

    public static void markComponentToRestoreFully(FacesContext context, UIComponent component) {
        if (MyfacesConfig.getCurrentInstance(context).isRefreshTransientBuildOnPSSPreserveState()) {
            component.getAttributes().put("oam.COMPONENT_ADDED_AFTER_BUILD_VIEW", ComponentState.REMOVE_ADD);
        }
        if (FaceletViewDeclarationLanguage.isRefreshTransientBuildOnPSSAuto(context)) {
            FaceletViewDeclarationLanguage.cleanTransientBuildOnRestore(context);
        }
    }

    public static void markComponentToRefreshDynamically(FacesContext context, UIComponent component) {
        FaceletViewDeclarationLanguageBase.dynamicComponentNeedsRefresh(context);
    }

    public static UIComponent findComponentChildOrFacetFrom(FacesContext facesContext, UIComponent parent, String expr) {
        char separatorChar = facesContext.getNamingContainerSeparatorChar();
        int separator = expr.indexOf(separatorChar);
        if (separator == -1) {
            return ComponentSupport.findComponentChildOrFacetFrom(parent, expr, null);
        }
        return ComponentSupport.findComponentChildOrFacetFrom(parent, expr.substring(0, separator), expr);
    }

    public static UIComponent findComponentChildOrFacetFrom(UIComponent parent, String id, String innerExpr) {
        if (parent.getFacetCount() > 0) {
            for (UIComponent facet : parent.getFacets().values()) {
                UIComponent find;
                if (id.equals(facet.getId())) {
                    if (innerExpr == null) {
                        return facet;
                    }
                    if (!(facet instanceof NamingContainer) || (find = facet.findComponent(innerExpr)) == null) continue;
                    return find;
                }
                if (facet instanceof NamingContainer || (find = ComponentSupport.findComponentChildOrFacetFrom(facet, id, innerExpr)) == null) continue;
                return find;
            }
        }
        if (parent.getChildCount() > 0) {
            int childCount = parent.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                UIComponent find;
                UIComponent child = (UIComponent)parent.getChildren().get(i);
                if (id.equals(child.getId())) {
                    if (innerExpr == null) {
                        return child;
                    }
                    if (!(child instanceof NamingContainer) || (find = child.findComponent(innerExpr)) == null) continue;
                    return find;
                }
                if (child instanceof NamingContainer || (find = ComponentSupport.findComponentChildOrFacetFrom(child, id, innerExpr)) == null) continue;
                return find;
            }
        }
        return null;
    }

    public static String getFindComponentExpression(FacesContext facesContext, UIComponent component) {
        char separatorChar = facesContext.getNamingContainerSeparatorChar();
        StringBuilder sb = SharedStringBuilder.get((FacesContext)facesContext, (String)SB_GET_FIND_COMPONENT_EXPR);
        sb.append(component.getId());
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof NamingContainer)) continue;
            sb.insert(0, separatorChar);
            sb.insert(0, parent.getId());
        }
        return sb.toString();
    }

    public static Object restoreInitialTagState(FaceletContext ctx, FaceletCompositionContext fcc, UIComponent parent, String uniqueId) {
        Object value = null;
        if (fcc.isUsingPSSOnThisView() && !fcc.isRefreshTransientBuildOnPSSPreserveState()) {
            UIViewRoot root = ComponentSupport.getViewRoot(ctx, parent);
            FaceletState map = (FaceletState)root.getAttributes().get(FACELET_STATE_INSTANCE);
            value = map == null ? null : map.getState(uniqueId);
        }
        return value;
    }

    public static void saveInitialTagState(FaceletContext ctx, FaceletCompositionContext fcc, UIComponent parent, String uniqueId, Object value) {
        if (fcc.isUsingPSSOnThisView() && !fcc.isRefreshTransientBuildOnPSSPreserveState()) {
            UIViewRoot root = ComponentSupport.getViewRoot(ctx, parent);
            FaceletState map = (FaceletState)root.getAttributes().get(FACELET_STATE_INSTANCE);
            if (map == null) {
                map = new FaceletState();
                root.getAttributes().put(FACELET_STATE_INSTANCE, map);
            }
            map.putState(uniqueId, value);
        }
    }

    public static FaceletState getFaceletState(FaceletContext ctx, UIComponent parent, boolean create) {
        UIViewRoot root = ComponentSupport.getViewRoot(ctx, parent);
        FaceletState map = (FaceletState)root.getAttributes().get(FACELET_STATE_INSTANCE);
        if (map == null && create) {
            map = new FaceletState();
            root.getAttributes().put(FACELET_STATE_INSTANCE, map);
        }
        return map;
    }

    public static void setCachedFacesContext(UIComponent component, FacesContext context) {
        if (SET_CACHED_FACES_CONTEXT != null) {
            try {
                SET_CACHED_FACES_CONTEXT.invoke((Object)component, context);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
    }

    static {
        Method method = null;
        try {
            method = UIComponent.class.getDeclaredMethod("setCachedFacesContext", FacesContext.class);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
            method = null;
        }
        SET_CACHED_FACES_CONTEXT = method;
    }
}

