/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag;

import jakarta.el.ELException;
import jakarta.faces.FacesException;
import jakarta.faces.application.Resource;
import jakarta.faces.application.ResourceHandler;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.facelets.BehaviorConfig;
import jakarta.faces.view.facelets.BehaviorHandler;
import jakarta.faces.view.facelets.ComponentConfig;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.ConverterConfig;
import jakarta.faces.view.facelets.ConverterHandler;
import jakarta.faces.view.facelets.FaceletException;
import jakarta.faces.view.facelets.FaceletHandler;
import jakarta.faces.view.facelets.Tag;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagHandler;
import jakarta.faces.view.facelets.ValidatorConfig;
import jakarta.faces.view.facelets.ValidatorHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.view.facelets.tag.LegacyUserTagHandler;
import org.apache.myfaces.view.facelets.tag.TagHandlerFactory;
import org.apache.myfaces.view.facelets.tag.TagLibrary;
import org.apache.myfaces.view.facelets.tag.UserTagHandler;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentResourceTagHandler;
import org.apache.myfaces.view.facelets.tag.composite.CompositeResouceWrapper;

public abstract class AbstractTagLibrary
implements TagLibrary {
    private final Map<String, TagHandlerFactory> _factories;
    private final Map<String, Method> _functions;
    private final String _namespace;
    private final String _aliasNamespace;
    private Boolean _strictJsf2FaceletsCompatibility;

    public AbstractTagLibrary(String namespace, String aliasNamespace) {
        this._namespace = namespace;
        this._aliasNamespace = aliasNamespace;
        this._factories = new HashMap<String, TagHandlerFactory>();
        this._functions = new HashMap<String, Method>();
    }

    public AbstractTagLibrary(String namespace) {
        this(namespace, null);
    }

    @Override
    public boolean containsNamespace(String ns) {
        return this._namespace.equals(ns) || this._aliasNamespace != null && this._aliasNamespace.equals(ns);
    }

    @Override
    public boolean containsTagHandler(String ns, String localName) {
        return this.containsNamespace(ns) && this._factories.containsKey(localName);
    }

    @Override
    public TagHandler createTagHandler(String ns, String localName, TagConfig tag) throws FacesException {
        TagHandlerFactory f;
        if (this.containsNamespace(ns) && (f = this._factories.get(localName)) != null) {
            return f.createHandler(tag);
        }
        return null;
    }

    @Override
    public boolean containsFunction(String ns, String name) {
        return this.containsNamespace(ns) && this._functions.containsKey(name);
    }

    @Override
    public Method createFunction(String ns, String name) {
        return this.containsNamespace(ns) ? this._functions.get(name) : null;
    }

    public String getNamespace() {
        return this._namespace;
    }

    protected final void addComponent(String name, String componentType, String rendererType) {
        this._factories.put(name, new ComponentHandlerFactory(componentType, rendererType));
    }

    protected final void addComponent(String name, String componentType, String rendererType, Class<? extends TagHandler> handlerType) {
        this._factories.put(name, new UserComponentHandlerFactory(componentType, rendererType, handlerType));
    }

    protected final void addComponentFromResourceId(String name, String resourceId) {
        this._factories.put(name, new UserComponentFromResourceIdHandlerFactory(resourceId));
    }

    protected final void addConverter(String name, String converterId) {
        this._factories.put(name, new ConverterHandlerFactory(converterId));
    }

    protected final void addConverter(String name, String converterId, Class<? extends TagHandler> type) {
        this._factories.put(name, new UserConverterHandlerFactory(converterId, type));
    }

    protected final void addValidator(String name, String validatorId) {
        this._factories.put(name, new ValidatorHandlerFactory(validatorId));
    }

    protected final void addValidator(String name, String validatorId, Class<? extends TagHandler> type) {
        this._factories.put(name, new UserValidatorHandlerFactory(validatorId, type));
    }

    protected final void addTagHandler(String name, Class<? extends TagHandler> handlerType) {
        this._factories.put(name, new HandlerFactory(handlerType));
    }

    protected final void addUserTag(String name, URL source) {
        if (this._strictJsf2FaceletsCompatibility == null) {
            MyfacesConfig config = MyfacesConfig.getCurrentInstance(FacesContext.getCurrentInstance().getExternalContext());
            this._strictJsf2FaceletsCompatibility = config.isStrictJsf2FaceletsCompatibility();
        }
        if (Boolean.TRUE.equals(this._strictJsf2FaceletsCompatibility)) {
            this._factories.put(name, new LegacyUserTagFactory(source));
        } else {
            this._factories.put(name, new UserTagFactory(source));
        }
    }

    protected final void addFunction(String name, Method method) {
        this._functions.put(name, method);
    }

    protected final void addBehavior(String name, String behaviorId) {
        this._factories.put(name, new BehaviorHandlerFactory(behaviorId));
    }

    protected final void addBehavior(String name, String behaviorId, Class<? extends TagHandler> handlerType) {
        this._factories.put(name, new UserBehaviorHandlerFactory(behaviorId, handlerType));
    }

    private static class UserComponentFromResourceIdHandlerFactory
    implements TagHandlerFactory {
        protected final String resourceId;

        public UserComponentFromResourceIdHandlerFactory(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ResourceHandler resourceHandler = facesContext.getApplication().getResourceHandler();
            Resource compositeComponentResourceWrapped = resourceHandler.createResourceFromId(this.resourceId);
            if (compositeComponentResourceWrapped != null) {
                CompositeResouceWrapper compositeComponentResource = new CompositeResouceWrapper(compositeComponentResourceWrapped);
                ComponentConfigWrapper componentConfig = new ComponentConfigWrapper(cfg, "jakarta.faces.NamingContainer", null);
                return new CompositeComponentResourceTagHandler(componentConfig, compositeComponentResource);
            }
            throw new FaceletException("Error Instantiating Component from <resource-id> declaration: " + this.resourceId);
        }
    }

    private static class UserBehaviorHandlerFactory
    implements TagHandlerFactory {
        private static final Class<?>[] CONS_SIG = new Class[]{BehaviorConfig.class};
        protected final String behaviorId;
        protected final Class<? extends TagHandler> type;
        protected final Constructor<? extends TagHandler> constructor;

        public UserBehaviorHandlerFactory(String behaviorId, Class<? extends TagHandler> type) {
            this.behaviorId = behaviorId;
            this.type = type;
            try {
                this.constructor = this.type.getConstructor(CONS_SIG);
            }
            catch (Exception e) {
                throw new FaceletException("Must have a Constructor that takes in a BehaviorConfig", e);
            }
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            try {
                BehaviorConfigWrapper bcfg = new BehaviorConfigWrapper(cfg, this.behaviorId);
                return this.constructor.newInstance(bcfg);
            }
            catch (InvocationTargetException e) {
                throw new FaceletException(e.getCause().getMessage(), e.getCause().getCause());
            }
            catch (Exception e) {
                throw new FaceletException("Error Instantiating BehaviorHandler: " + this.type.getName(), e);
            }
        }
    }

    private static class BehaviorHandlerFactory
    implements TagHandlerFactory {
        protected final String behaviorId;

        public BehaviorHandlerFactory(String behaviorId) {
            this.behaviorId = behaviorId;
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            BehaviorConfigWrapper bcfg = new BehaviorConfigWrapper(cfg, this.behaviorId);
            return new BehaviorHandler(bcfg);
        }
    }

    private static class BehaviorConfigWrapper
    implements BehaviorConfig {
        protected final TagConfig parent;
        protected final String behaviorId;

        public BehaviorConfigWrapper(TagConfig parent, String behaviorId) {
            this.parent = parent;
            this.behaviorId = behaviorId;
        }

        @Override
        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        @Override
        public Tag getTag() {
            return this.parent.getTag();
        }

        @Override
        public String getTagId() {
            return this.parent.getTagId();
        }

        @Override
        public String getBehaviorId() {
            return this.behaviorId;
        }
    }

    private static class UserValidatorHandlerFactory
    implements TagHandlerFactory {
        private static final Class<?>[] CONS_SIG = new Class[]{ValidatorConfig.class};
        protected final String validatorId;
        protected final Class<? extends TagHandler> type;
        protected final Constructor<? extends TagHandler> constructor;

        public UserValidatorHandlerFactory(String validatorId, Class<? extends TagHandler> type) {
            this.validatorId = validatorId;
            this.type = type;
            try {
                this.constructor = this.type.getConstructor(CONS_SIG);
            }
            catch (Exception e) {
                throw new FaceletException("Must have a Constructor that takes in a ConverterConfig", e);
            }
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            try {
                ValidatorConfigWrapper ccfg = new ValidatorConfigWrapper(cfg, this.validatorId);
                return this.constructor.newInstance(ccfg);
            }
            catch (InvocationTargetException e) {
                throw new FaceletException(e.getCause().getMessage(), e.getCause().getCause());
            }
            catch (Exception e) {
                throw new FaceletException("Error Instantiating ValidatorHandler: " + this.type.getName(), e);
            }
        }
    }

    private static class UserConverterHandlerFactory
    implements TagHandlerFactory {
        private static final Class<?>[] CONS_SIG = new Class[]{ConverterConfig.class};
        protected final String converterId;
        protected final Class<? extends TagHandler> type;
        protected final Constructor<? extends TagHandler> constructor;

        public UserConverterHandlerFactory(String converterId, Class<? extends TagHandler> type) {
            this.converterId = converterId;
            this.type = type;
            try {
                this.constructor = this.type.getConstructor(CONS_SIG);
            }
            catch (Exception e) {
                throw new FaceletException("Must have a Constructor that takes in a ConverterConfig", e);
            }
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            try {
                ConverterConfigWrapper ccfg = new ConverterConfigWrapper(cfg, this.converterId);
                return this.constructor.newInstance(ccfg);
            }
            catch (InvocationTargetException e) {
                throw new FaceletException(e.getCause().getMessage(), e.getCause().getCause());
            }
            catch (Exception e) {
                throw new FaceletException("Error Instantiating ConverterHandler: " + this.type.getName(), e);
            }
        }
    }

    private static class ConverterHandlerFactory
    implements TagHandlerFactory {
        protected final String converterId;

        public ConverterHandlerFactory(String converterId) {
            this.converterId = converterId;
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            return new ConverterHandler(new ConverterConfigWrapper(cfg, this.converterId));
        }
    }

    private static class ValidatorHandlerFactory
    implements TagHandlerFactory {
        protected final String validatorId;

        public ValidatorHandlerFactory(String validatorId) {
            this.validatorId = validatorId;
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            return new ValidatorHandler(new ValidatorConfigWrapper(cfg, this.validatorId));
        }
    }

    private static class UserComponentHandlerFactory
    implements TagHandlerFactory {
        private static final Class<?>[] CONS_SIG = new Class[]{ComponentConfig.class};
        protected final String componentType;
        protected final String renderType;
        protected final Class<? extends TagHandler> type;
        protected final Constructor<? extends TagHandler> constructor;

        public UserComponentHandlerFactory(String componentType, String renderType, Class<? extends TagHandler> type) {
            this.componentType = componentType;
            this.renderType = renderType;
            this.type = type;
            try {
                this.constructor = this.type.getConstructor(CONS_SIG);
            }
            catch (Exception e) {
                throw new FaceletException("Must have a Constructor that takes in a ComponentConfig", e);
            }
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            try {
                ComponentConfigWrapper ccfg = new ComponentConfigWrapper(cfg, this.componentType, this.renderType);
                return this.constructor.newInstance(ccfg);
            }
            catch (InvocationTargetException e) {
                throw new FaceletException(e.getCause().getMessage(), e.getCause().getCause());
            }
            catch (Exception e) {
                throw new FaceletException("Error Instantiating ComponentHandler: " + this.type.getName(), e);
            }
        }
    }

    private static class ComponentHandlerFactory
    implements TagHandlerFactory {
        protected final String componentType;
        protected final String renderType;

        public ComponentHandlerFactory(String componentType, String renderType) {
            this.componentType = componentType;
            this.renderType = renderType;
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            ComponentConfigWrapper ccfg = new ComponentConfigWrapper(cfg, this.componentType, this.renderType);
            return new ComponentHandler(ccfg);
        }
    }

    private static class LegacyUserTagFactory
    implements TagHandlerFactory {
        protected final URL location;

        public LegacyUserTagFactory(URL location) {
            this.location = location;
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            return new LegacyUserTagHandler(cfg, this.location);
        }
    }

    private static class UserTagFactory
    implements TagHandlerFactory {
        protected final URL location;

        public UserTagFactory(URL location) {
            this.location = location;
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            return new UserTagHandler(cfg, this.location);
        }
    }

    private static class ComponentConfigWrapper
    implements ComponentConfig {
        protected final TagConfig parent;
        protected final String componentType;
        protected final String rendererType;

        public ComponentConfigWrapper(TagConfig parent, String componentType, String rendererType) {
            this.parent = parent;
            this.componentType = componentType;
            this.rendererType = rendererType;
        }

        @Override
        public String getComponentType() {
            return this.componentType;
        }

        @Override
        public String getRendererType() {
            return this.rendererType;
        }

        @Override
        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        @Override
        public Tag getTag() {
            return this.parent.getTag();
        }

        @Override
        public String getTagId() {
            return this.parent.getTagId();
        }
    }

    private static class HandlerFactory
    implements TagHandlerFactory {
        private static final Class<?>[] CONSTRUCTOR_SIG = new Class[]{TagConfig.class};
        protected final Class<? extends TagHandler> handlerType;

        public HandlerFactory(Class<? extends TagHandler> handlerType) {
            this.handlerType = handlerType;
        }

        @Override
        public TagHandler createHandler(TagConfig cfg) throws FacesException, ELException {
            try {
                return this.handlerType.getConstructor(CONSTRUCTOR_SIG).newInstance(cfg);
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getCause();
                if (t instanceof FacesException) {
                    throw (FacesException)t;
                }
                if (t instanceof ELException) {
                    throw (ELException)t;
                }
                throw new FacesException("Error Instantiating: " + this.handlerType.getName(), t);
            }
            catch (Exception e) {
                throw new FacesException("Error Instantiating: " + this.handlerType.getName(), e);
            }
        }
    }

    private static class ConverterConfigWrapper
    implements ConverterConfig {
        private final TagConfig parent;
        private final String converterId;

        public ConverterConfigWrapper(TagConfig parent, String converterId) {
            this.parent = parent;
            this.converterId = converterId;
        }

        @Override
        public String getConverterId() {
            return this.converterId;
        }

        @Override
        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        @Override
        public Tag getTag() {
            return this.parent.getTag();
        }

        @Override
        public String getTagId() {
            return this.parent.getTagId();
        }
    }

    private static class ValidatorConfigWrapper
    implements ValidatorConfig {
        private final TagConfig parent;
        private final String validatorId;

        public ValidatorConfigWrapper(TagConfig parent, String validatorId) {
            this.parent = parent;
            this.validatorId = validatorId;
        }

        @Override
        public String getValidatorId() {
            return this.validatorId;
        }

        @Override
        public FaceletHandler getNextHandler() {
            return this.parent.getNextHandler();
        }

        @Override
        public Tag getTag() {
            return this.parent.getTag();
        }

        @Override
        public String getTagId() {
            return this.parent.getTagId();
        }
    }
}

