/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import javax.faces.FacesException;
import javax.servlet.ServletContext;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.util.lang.StringUtils;
import org.apache.myfaces.webapp.FaceletsInitilializer;
import org.apache.myfaces.webapp.FacesInitializer;
import org.apache.myfaces.webapp.JspFacesInitializer;

public class FacesInitializerFactory {
    public static FacesInitializer getFacesInitializer(ServletContext context) {
        FacesInitializer initializer = FacesInitializerFactory._getFacesInitializerFromInitParam(context);
        if (initializer == null) {
            initializer = FacesInitializerFactory._getDefaultFacesInitializer(context);
        }
        return initializer;
    }

    private static FacesInitializer _getFacesInitializerFromInitParam(ServletContext context) {
        String initializerClassName = context.getInitParameter("org.apache.myfaces.FACES_INITIALIZER");
        if (initializerClassName != null) {
            try {
                Class clazz = ClassUtils.classForName(initializerClassName);
                if (!FacesInitializer.class.isAssignableFrom(clazz)) {
                    throw new FacesException("Class " + clazz + " does not implement FacesInitializer");
                }
                return (FacesInitializer)ClassUtils.newInstance(clazz);
            }
            catch (ClassNotFoundException cnfe) {
                throw new FacesException("Could not find class of specified FacesInitializer", (Throwable)cnfe);
            }
        }
        return null;
    }

    private static FacesInitializer _getDefaultFacesInitializer(ServletContext context) {
        String initParameter = context.getInitParameter("org.apache.myfaces.SUPPORT_JSP");
        if ((StringUtils.isBlank(initParameter) || Boolean.TRUE.toString().equals(initParameter)) && ClassUtils.simpleClassForName("javax.servlet.jsp.JspApplicationContext", false) != null) {
            return new JspFacesInitializer();
        }
        return new FaceletsInitilializer();
    }
}

