/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import javax.faces.FacesException;
import javax.faces.component.ActionSource;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.PhaseId;
import javax.faces.render.ClientBehaviorRenderer;
import org.apache.myfaces.renderkit.html.util.AjaxScriptBuilder;
import org.apache.myfaces.util.SharedStringBuilder;

public class HtmlAjaxBehaviorRenderer
extends ClientBehaviorRenderer {
    private static final String ERR_NO_AJAX_BEHAVIOR = "The behavior must be an instance of AjaxBehavior";
    private static final String AJAX_SB = "oam.renderkit.AJAX_SB";

    @Override
    public void decode(FacesContext context, UIComponent component, ClientBehavior behavior) {
        this.assertBehavior(behavior);
        AjaxBehavior ajaxBehavior = (AjaxBehavior)behavior;
        if (ajaxBehavior.isDisabled() || !component.isRendered()) {
            return;
        }
        this.dispatchBehaviorEvent(component, ajaxBehavior);
    }

    @Override
    public String getScript(ClientBehaviorContext behaviorContext, ClientBehavior behavior) {
        this.assertBehavior(behavior);
        AjaxBehavior ajaxBehavior = (AjaxBehavior)behavior;
        if (ajaxBehavior.isDisabled()) {
            return null;
        }
        StringBuilder retVal = SharedStringBuilder.get(behaviorContext.getFacesContext(), AJAX_SB, 60);
        AjaxScriptBuilder.build(behaviorContext.getFacesContext(), retVal, behaviorContext.getComponent(), behaviorContext.getSourceId(), behaviorContext.getEventName(), ajaxBehavior.getExecute(), ajaxBehavior.getRender(), ajaxBehavior.getDelay(), ajaxBehavior.isResetValues(), ajaxBehavior.getOnerror(), ajaxBehavior.getOnevent(), behaviorContext.getParameters());
        return retVal.toString();
    }

    private void dispatchBehaviorEvent(UIComponent component, AjaxBehavior ajaxBehavior) {
        AjaxBehaviorEvent event = new AjaxBehaviorEvent(component, ajaxBehavior);
        boolean isImmediate = ajaxBehavior.isImmediateSet() ? ajaxBehavior.isImmediate() : this.isComponentImmediate(component);
        PhaseId phaseId = isImmediate ? PhaseId.APPLY_REQUEST_VALUES : PhaseId.INVOKE_APPLICATION;
        event.setPhaseId(phaseId);
        component.queueEvent(event);
    }

    private boolean isComponentImmediate(UIComponent component) {
        boolean isImmediate = false;
        if (component instanceof EditableValueHolder) {
            isImmediate = ((EditableValueHolder)((Object)component)).isImmediate();
        } else if (component instanceof ActionSource) {
            isImmediate = ((ActionSource)((Object)component)).isImmediate();
        }
        return isImmediate;
    }

    private void assertBehavior(ClientBehavior behavior) {
        if (!(behavior instanceof AjaxBehavior)) {
            throw new FacesException(ERR_NO_AJAX_BEHAVIOR);
        }
    }
}

