/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.FacesContext;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.core.api.shared.lang.PropertyDescriptorUtils;
import org.apache.myfaces.el.ELResolverBuilder;
import org.apache.myfaces.el.resolver.CompositeComponentELResolver;
import org.apache.myfaces.el.resolver.EmptyStringToNullELResolver;
import org.apache.myfaces.el.resolver.FacesCompositeELResolver;
import org.apache.myfaces.el.resolver.FlashELResolver;
import org.apache.myfaces.el.resolver.ImportConstantsELResolver;
import org.apache.myfaces.el.resolver.ImportHandlerResolver;
import org.apache.myfaces.el.resolver.LambdaBeanELResolver;
import org.apache.myfaces.el.resolver.ResourceBundleResolver;
import org.apache.myfaces.el.resolver.ResourceResolver;
import org.apache.myfaces.el.resolver.ScopedAttributeResolver;
import org.apache.myfaces.el.resolver.implicitobject.ImplicitObjectResolver;
import org.apache.myfaces.util.lang.ClassUtils;

public class ELResolverBuilderForFaces
extends ELResolverBuilder {
    private static final Class STATIC_FIELD_EL_RESOLVER_CLASS;
    private static final Method GET_STREAM_EL_RESOLVER_METHOD;

    public ELResolverBuilderForFaces(RuntimeConfig runtimeConfig, MyfacesConfig myfacesConfig) {
        super(runtimeConfig, myfacesConfig);
    }

    @Override
    public void build(FacesContext facesContext, CompositeELResolver compositeElResolver) {
        MyfacesConfig config = MyfacesConfig.getCurrentInstance(FacesContext.getCurrentInstance());
        ArrayList<ELResolver> list = new ArrayList<ELResolver>();
        if (this.isReplaceImplicitObjectResolverWithCDIResolver(facesContext)) {
            list.add(ImplicitObjectResolver.makeResolverForFacesCDI());
            list.add(this.getCDIELResolver());
        } else {
            list.add(ImplicitObjectResolver.makeResolverForFaces());
        }
        list.add(new CompositeComponentELResolver(config));
        this.addFromRuntimeConfig(list);
        if ("true".equalsIgnoreCase(facesContext.getExternalContext().getInitParameter("javax.faces.INTERPRET_EMPTY_STRING_SUBMITTED_VALUES_AS_NULL"))) {
            list.add(new EmptyStringToNullELResolver());
        }
        list.add(new FlashELResolver());
        list.add(new ResourceResolver());
        list.add((ELResolver)new ResourceBundleELResolver());
        list.add(new ResourceBundleResolver());
        list.add(new ImportConstantsELResolver());
        if (STATIC_FIELD_EL_RESOLVER_CLASS != null && GET_STREAM_EL_RESOLVER_METHOD != null) {
            try {
                ELResolver streamElResolver = (ELResolver)GET_STREAM_EL_RESOLVER_METHOD.invoke((Object)this.runtimeConfig.getExpressionFactory(), new Object[0]);
                if (streamElResolver != null) {
                    list.add(streamElResolver);
                }
                list.add((ELResolver)STATIC_FIELD_EL_RESOLVER_CLASS.newInstance());
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException streamElResolver) {
                // empty catch block
            }
        }
        list.add((ELResolver)new MapELResolver());
        list.add((ELResolver)new ListELResolver());
        list.add((ELResolver)new ArrayELResolver());
        if (PropertyDescriptorUtils.isUseLambdaMetafactory(facesContext.getExternalContext())) {
            list.add((ELResolver)new LambdaBeanELResolver());
        } else {
            list.add((ELResolver)new BeanELResolver());
        }
        this.sortELResolvers(list, FacesCompositeELResolver.Scope.Faces);
        Iterable<ELResolver> filteredELResolvers = this.filterELResolvers(list, FacesCompositeELResolver.Scope.Faces);
        for (ELResolver resolver : filteredELResolvers) {
            compositeElResolver.add(resolver);
        }
        if (config.isSupportEL3ImportHandler()) {
            compositeElResolver.add((ELResolver)new ImportHandlerResolver());
        }
        compositeElResolver.add((ELResolver)new ScopedAttributeResolver());
    }

    protected ELResolver getCDIELResolver() {
        BeanManager beanManager = CDIUtils.getBeanManager(FacesContext.getCurrentInstance().getExternalContext());
        return beanManager.getELResolver();
    }

    static {
        Class staticFieldELResolverClass = null;
        Method getStreamELResolverMethod = null;
        try {
            staticFieldELResolverClass = ClassUtils.classForName("javax.el.StaticFieldELResolver");
            getStreamELResolverMethod = ExpressionFactory.class.getMethod("getStreamELResolver", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        STATIC_FIELD_EL_RESOLVER_CLASS = staticFieldELResolverClass;
        GET_STREAM_EL_RESOLVER_METHOD = getStreamELResolverMethod;
    }
}

