/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util.lang;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;

public final class ClassUtils
extends org.apache.myfaces.core.api.shared.lang.ClassUtils {
    private static final Logger log = Logger.getLogger(ClassUtils.class.getName());

    public static <T> T buildApplicationObject(Class<T> interfaceClass, Collection<String> classNamesIterator, T defaultObject) {
        return ClassUtils.buildApplicationObject(interfaceClass, null, null, classNamesIterator, defaultObject);
    }

    public static <T> T buildApplicationObject(Class<T> interfaceClass, Class<? extends T> extendedInterfaceClass, Class<? extends T> extendedInterfaceWrapperClass, Collection<String> classNamesIterator, T defaultObject) {
        Object current = defaultObject;
        for (String implClassName : classNamesIterator) {
            Class implClass = ClassUtils.simpleClassForName(implClassName);
            if (!interfaceClass.isAssignableFrom(implClass)) {
                throw new IllegalArgumentException("Class " + implClassName + " is no " + interfaceClass.getName());
            }
            if (current == null) {
                current = ClassUtils.newInstance((Class)implClass);
                continue;
            }
            Object newCurrent = null;
            try {
                Constructor delegationConstructor = null;
                if (extendedInterfaceClass != null && extendedInterfaceClass.isAssignableFrom(current.getClass())) {
                    try {
                        delegationConstructor = implClass.getConstructor(extendedInterfaceClass);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (delegationConstructor == null) {
                    delegationConstructor = implClass.getConstructor(interfaceClass);
                }
                try {
                    newCurrent = delegationConstructor.newInstance(current);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    throw new FacesException((Throwable)e);
                }
            }
            catch (NoSuchMethodException e) {
                newCurrent = ClassUtils.newInstance((Class)implClass);
            }
            current = ClassUtils.wrapBackwardCompatible(interfaceClass, extendedInterfaceClass, extendedInterfaceWrapperClass, current, newCurrent);
        }
        return (T)current;
    }

    public static <T> T wrapBackwardCompatible(Class<T> interfaceClass, Class<? extends T> extendedInterfaceClass, Class<? extends T> extendedInterfaceWrapperClass, T defaultObject, T newCurrent) {
        T current = newCurrent;
        if (extendedInterfaceWrapperClass != null && !extendedInterfaceClass.isAssignableFrom(current.getClass())) {
            try {
                Constructor<T> wrapperConstructor = extendedInterfaceWrapperClass.getConstructor(interfaceClass, extendedInterfaceClass);
                current = wrapperConstructor.newInstance(newCurrent, defaultObject);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                throw new FacesException((Throwable)e);
            }
        }
        return current;
    }

    public static <T> Class<T> classForName(String type) throws ClassNotFoundException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        try {
            return Class.forName(type, false, ClassUtils.getContextClassLoader());
        }
        catch (ClassNotFoundException ignore) {
            return Class.forName(type, false, ClassUtils.class.getClassLoader());
        }
    }

    public static Class simpleClassForName(String type) {
        return ClassUtils.simpleClassForName(type, true);
    }

    public static Class simpleClassForName(String type, boolean logException) {
        Class returnClass;
        block2: {
            returnClass = null;
            try {
                returnClass = ClassUtils.classForName(type);
            }
            catch (ClassNotFoundException e) {
                if (!logException) break block2;
                log.log(Level.SEVERE, "Class " + type + " not found", e);
                throw new FacesException((Throwable)e);
            }
        }
        return returnClass;
    }

    public static URL getResource(String resource) {
        URL url = ClassUtils.getContextClassLoader().getResource(resource);
        if (url == null) {
            url = ClassUtils.class.getClassLoader().getResource(resource);
        }
        return url;
    }

    public static InputStream getResourceAsStream(String resource) {
        InputStream stream = ClassUtils.getContextClassLoader().getResourceAsStream(resource);
        if (stream == null) {
            stream = ClassUtils.class.getClassLoader().getResourceAsStream(resource);
        }
        return stream;
    }

    protected static final String paramString(Class<?> ... types) {
        if (types != null) {
            StringBuilder sb = new StringBuilder();
            for (Class<?> type : types) {
                sb.append(type.getName()).append(", ");
            }
            if (sb.length() > 2) {
                sb.setLength(sb.length() - 2);
            }
            return sb.toString();
        }
        return null;
    }
}

