/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.naming.NamingException;
import org.apache.myfaces.config.annotation.LifecycleProvider2;
import org.apache.myfaces.shared.util.ClassUtils;

public class NoInjectionAnnotationLifecycleProvider
implements LifecycleProvider2 {
    private static volatile WeakHashMap<ClassLoader, Map<Class, Method[]>> declaredMethodBeans = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Class, Method[]> getDeclaredMethodBeansMap() {
        ClassLoader cl = ClassUtils.getContextClassLoader();
        Map<Class, Method[]> metadata = declaredMethodBeans.get(cl);
        if (metadata == null) {
            WeakHashMap<ClassLoader, Map<Class, Method[]>> weakHashMap = declaredMethodBeans;
            synchronized (weakHashMap) {
                metadata = NoInjectionAnnotationLifecycleProvider.createDeclaredMethodBeansMap(cl, metadata);
            }
        }
        return metadata;
    }

    private static Map<Class, Method[]> createDeclaredMethodBeansMap(ClassLoader cl, Map<Class, Method[]> metadata) {
        metadata = declaredMethodBeans.get(cl);
        if (metadata == null) {
            metadata = new HashMap<Class, Method[]>();
            declaredMethodBeans.put(cl, metadata);
        }
        return metadata;
    }

    @Override
    public Object newInstance(String className) throws InstantiationException, IllegalAccessException, NamingException, InvocationTargetException, ClassNotFoundException {
        Class clazz = ClassUtils.classForName(className);
        Object object = clazz.newInstance();
        this.processAnnotations(object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Method[] getDeclaredMethods(Class clazz) {
        Map<Class, Method[]> declaredMethodBeansMap = NoInjectionAnnotationLifecycleProvider.getDeclaredMethodBeansMap();
        Method[] methods = declaredMethodBeansMap.get(clazz);
        if (methods == null) {
            methods = clazz.getDeclaredMethods();
            Map<Class, Method[]> map = declaredMethodBeansMap;
            synchronized (map) {
                declaredMethodBeansMap.put(clazz, methods);
            }
        }
        return methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postConstruct(Object instance) throws IllegalAccessException, InvocationTargetException {
        Class<?> clazz = instance.getClass();
        Method[] methods = this.getDeclaredMethods(clazz);
        if (methods == null) {
            Map<Class, Method[]> declaredMethodBeansMap;
            methods = clazz.getDeclaredMethods();
            Map<Class, Method[]> map = declaredMethodBeansMap = NoInjectionAnnotationLifecycleProvider.getDeclaredMethodBeansMap();
            synchronized (map) {
                declaredMethodBeansMap.put(clazz, methods);
            }
        }
        Method postConstruct = null;
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.isAnnotationPresent(PostConstruct.class)) continue;
            if (postConstruct != null || method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || method.getExceptionTypes().length > 0 || !method.getReturnType().getName().equals("void")) {
                throw new IllegalArgumentException("Invalid PostConstruct annotation");
            }
            postConstruct = method;
        }
        this.invokeAnnotatedMethod(postConstruct, instance);
    }

    @Override
    public void destroyInstance(Object instance) throws IllegalAccessException, InvocationTargetException {
        Class<?> clazz = instance.getClass();
        Method[] methods = this.getDeclaredMethods(clazz);
        Method preDestroy = null;
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.isAnnotationPresent(PreDestroy.class)) continue;
            if (preDestroy != null || method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || method.getExceptionTypes().length > 0 || !method.getReturnType().getName().equals("void")) {
                throw new IllegalArgumentException("Invalid PreDestroy annotation");
            }
            preDestroy = method;
        }
        this.invokeAnnotatedMethod(preDestroy, instance);
    }

    private void invokeAnnotatedMethod(Method method, Object instance) throws IllegalAccessException, InvocationTargetException {
        if (method != null) {
            boolean accessibility = method.isAccessible();
            method.setAccessible(true);
            method.invoke(instance, new Object[0]);
            method.setAccessible(accessibility);
        }
    }

    protected void processAnnotations(Object instance) throws IllegalAccessException, InvocationTargetException, NamingException {
    }
}

