/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutcomeTarget;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlOutputLink;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.CommonEventUtils;
import org.apache.myfaces.shared.renderkit.html.CommonPropertyUtils;
import org.apache.myfaces.shared.renderkit.html.HTML;
import org.apache.myfaces.shared.renderkit.html.HtmlFormRendererBase;
import org.apache.myfaces.shared.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.util.FormInfo;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;
import org.apache.myfaces.shared.util._ComponentUtils;

public abstract class HtmlLinkRendererBase
extends HtmlRenderer {
    public static final String END_LINK_OUTCOME_AS_SPAN = "oam.shared.HtmlLinkRendererBase.END_LINK_OUTCOME_AS_SPAN";

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void decode(FacesContext facesContext, UIComponent component) {
        super.decode(facesContext, component);
        if (component instanceof UICommand) {
            String clientId = component.getClientId(facesContext);
            FormInfo formInfo = this.findNestingForm(component, facesContext);
            boolean disabled = HtmlRendererUtils.isDisabled(component);
            boolean activateActionEvent = false;
            if (formInfo != null && !disabled) {
                String reqValue = facesContext.getExternalContext().getRequestParameterMap().get(HtmlRendererUtils.getHiddenCommandLinkFieldName(formInfo, facesContext));
                boolean bl = activateActionEvent = reqValue != null && reqValue.equals(clientId) || HtmlRendererUtils.isPartialOrBehaviorSubmit(facesContext, clientId);
                if (activateActionEvent) {
                    RendererUtils.initPartialValidationAndModelUpdate(component, facesContext);
                }
            }
            if (component instanceof ClientBehaviorHolder && !disabled) {
                HtmlRendererUtils.decodeClientBehaviors(facesContext, component);
            }
            if (activateActionEvent) {
                component.queueEvent(new ActionEvent(component));
            }
        } else if (component instanceof UIOutput) {
            if (component instanceof ClientBehaviorHolder && !HtmlRendererUtils.isDisabled(component)) {
                HtmlRendererUtils.decodeClientBehaviors(facesContext, component);
            }
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    @Override
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeBegin(facesContext, component);
        Map<String, List<ClientBehavior>> behaviors = null;
        if (component instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)((Object)component)).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, facesContext.getResponseWriter());
        }
        if (component instanceof UICommand) {
            this.renderCommandLinkStart(facesContext, component, component.getClientId(facesContext), ((UICommand)component).getValue(), this.getStyle(facesContext, component), this.getStyleClass(facesContext, component));
        } else if (component instanceof UIOutcomeTarget) {
            this.renderOutcomeLinkStart(facesContext, (UIOutcomeTarget)component);
        } else if (component instanceof UIOutput) {
            this.renderOutputLinkStart(facesContext, (UIOutput)component);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    protected String getStyle(FacesContext facesContext, UIComponent link) {
        if (link instanceof HtmlCommandLink) {
            return ((HtmlCommandLink)link).getStyle();
        }
        return (String)link.getAttributes().get("style");
    }

    protected String getStyleClass(FacesContext facesContext, UIComponent link) {
        if (link instanceof HtmlCommandLink) {
            return ((HtmlCommandLink)link).getStyleClass();
        }
        return (String)link.getAttributes().get("styleClass");
    }

    @Override
    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.renderChildren(facesContext, component);
    }

    @Override
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeEnd(facesContext, component);
        if (component instanceof UICommand) {
            this.renderCommandLinkEnd(facesContext, component);
            FormInfo formInfo = this.findNestingForm(component, facesContext);
            if (formInfo != null) {
                HtmlFormRendererBase.renderScrollHiddenInputIfNecessary(formInfo.getForm(), facesContext, facesContext.getResponseWriter());
            }
        } else if (component instanceof UIOutcomeTarget) {
            this.renderOutcomeLinkEnd(facesContext, component);
        } else if (component instanceof UIOutput) {
            this.renderOutputLinkEnd(facesContext, component);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    protected void renderCommandLinkStart(FacesContext facesContext, UIComponent component, String clientId, Object value, String style, String styleClass) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Map<String, List<ClientBehavior>> behaviors = null;
        FormInfo formInfo = this.findNestingForm(component, facesContext);
        boolean disabled = HtmlRendererUtils.isDisabled(component);
        if (disabled || formInfo == null) {
            writer.startElement("span", component);
            if (component instanceof ClientBehaviorHolder) {
                behaviors = ((ClientBehaviorHolder)((Object)component)).getClientBehaviors();
                if (!behaviors.isEmpty()) {
                    HtmlRendererUtils.writeIdAndName(writer, component, facesContext);
                } else {
                    HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
                }
                long commonPropertiesMarked = 0L;
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(component);
                }
                if (!disabled) {
                    if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                        CommonPropertyUtils.renderEventProperties(writer, commonPropertiesMarked, component);
                        CommonPropertyUtils.renderFocusBlurEventProperties(writer, commonPropertiesMarked, component);
                    } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                        Long commonEventsMarked = CommonEventUtils.getCommonEventsMarked(component);
                        CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, component, behaviors);
                        CommonEventUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, commonPropertiesMarked, commonEventsMarked, component, behaviors);
                    } else {
                        HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, component, behaviors);
                        HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, component, behaviors);
                    }
                } else if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderEventPropertiesWithoutOnclick(writer, commonPropertiesMarked, component);
                    CommonPropertyUtils.renderFocusBlurEventProperties(writer, commonPropertiesMarked, component);
                } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                    Long commonEventsMarked = CommonEventUtils.getCommonEventsMarked(component);
                    CommonEventUtils.renderBehaviorizedEventHandlersWithoutOnclick(facesContext, writer, commonPropertiesMarked, commonEventsMarked, component, behaviors);
                    CommonEventUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, commonPropertiesMarked, commonEventsMarked, component, behaviors);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlersWithoutOnclick(facesContext, writer, component, behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, component, behaviors);
                }
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughPropertiesDisabledWithoutEvents(writer, commonPropertiesMarked, component);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_DISABLED_WITHOUT_EVENTS);
                }
            } else {
                HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughPropertiesDisabled(writer, CommonPropertyUtils.getCommonPropertiesMarked(component), component);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_DISABLED);
                }
            }
        } else {
            if (component instanceof ClientBehaviorHolder) {
                behaviors = ((ClientBehaviorHolder)((Object)component)).getClientBehaviors();
                this.renderBehaviorizedJavaScriptAnchorStart(facesContext, writer, component, clientId, behaviors, formInfo);
                if (!behaviors.isEmpty()) {
                    HtmlRendererUtils.writeIdAndName(writer, component, facesContext);
                } else {
                    String commandOnclick = component instanceof HtmlCommandLink ? ((HtmlCommandLink)component).getOnclick() : (String)component.getAttributes().get("onclick");
                    if (commandOnclick != null) {
                        HtmlRendererUtils.writeIdAndName(writer, component, facesContext);
                    } else {
                        HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
                    }
                }
                long commonPropertiesMarked = 0L;
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(component);
                }
                if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderEventPropertiesWithoutOnclick(writer, commonPropertiesMarked, component);
                    CommonPropertyUtils.renderFocusBlurEventProperties(writer, commonPropertiesMarked, component);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlersWithoutOnclick(facesContext, writer, component, behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, component, behaviors);
                }
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughPropertiesWithoutStyleAndEvents(writer, commonPropertiesMarked, component);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_WITHOUT_STYLE_AND_EVENTS);
                }
            } else {
                this.renderJavaScriptAnchorStart(facesContext, writer, component, clientId, formInfo);
                HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughPropertiesWithoutOnclickAndStyle(writer, CommonPropertyUtils.getCommonPropertiesMarked(component), component);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_WITHOUT_ONCLICK_WITHOUT_STYLE);
                }
            }
            HtmlRendererUtils.renderHTMLAttribute(writer, "style", "style", (Object)style);
            HtmlRendererUtils.renderHTMLAttribute(writer, "styleClass", "styleClass", (Object)styleClass);
        }
        if (value != null) {
            writer.writeText(value.toString(), "value");
        }
        if (formInfo == null) {
            writer.writeText(": This link is deactivated, because it is not embedded in a JSF form.", null);
        }
    }

    protected void renderJavaScriptAnchorStart(FacesContext facesContext, ResponseWriter writer, UIComponent component, String clientId, FormInfo formInfo) throws IOException {
        UIComponent nestingForm = formInfo.getForm();
        String formName = formInfo.getFormName();
        StringBuilder onClick = new StringBuilder();
        String commandOnclick = component instanceof HtmlCommandLink ? ((HtmlCommandLink)component).getOnclick() : (String)component.getAttributes().get("onclick");
        if (commandOnclick != null) {
            onClick.append("var cf = function(){");
            onClick.append(commandOnclick);
            onClick.append('}');
            onClick.append(';');
            onClick.append("var oamSF = function(){");
        }
        if (RendererUtils.isAdfOrTrinidadForm(formInfo.getForm())) {
            onClick.append("submitForm('");
            onClick.append(formInfo.getForm().getClientId(facesContext));
            onClick.append("',1,{source:'");
            onClick.append(component.getClientId(facesContext));
            onClick.append("'});return false;");
        } else {
            HtmlRendererUtils.renderFormSubmitScript(facesContext);
            StringBuilder params = this.addChildParameters(facesContext, component, nestingForm);
            String target = this.getTarget(component);
            onClick.append("return ").append("myfaces.oam.submitForm").append("('").append(formName).append("','").append(clientId).append("'");
            if (params.length() > 2 || target != null) {
                onClick.append(",").append(target == null ? "null" : "'" + target + "'").append(",").append((CharSequence)params);
            }
            onClick.append(");");
            if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isRenderHiddenFieldsForLinkParams()) {
                String hiddenFieldName = HtmlRendererUtils.getHiddenCommandLinkFieldName(formInfo, facesContext);
                this.addHiddenCommandParameter(facesContext, nestingForm, hiddenFieldName);
            }
        }
        if (commandOnclick != null) {
            onClick.append('}');
            onClick.append(';');
            onClick.append("return (cf.apply(this, [])==false)? false : oamSF.apply(this, []); ");
        }
        writer.startElement("a", component);
        writer.writeURIAttribute("href", "#", null);
        writer.writeAttribute("onclick", onClick.toString(), null);
    }

    protected void renderBehaviorizedJavaScriptAnchorStart(FacesContext facesContext, ResponseWriter writer, UIComponent component, String clientId, Map<String, List<ClientBehavior>> behaviors, FormInfo formInfo) throws IOException {
        String commandOnclick = component instanceof HtmlCommandLink ? ((HtmlCommandLink)component).getOnclick() : (String)component.getAttributes().get("onclick");
        String serverEventCode = this.buildServerOnclick(facesContext, component, clientId, formInfo);
        String onclick = null;
        if (commandOnclick == null && (behaviors.isEmpty() || !behaviors.containsKey("click") && !behaviors.containsKey("action"))) {
            onclick = serverEventCode;
        } else {
            boolean hasSubmittingBehavior;
            boolean bl = hasSubmittingBehavior = this.hasSubmittingBehavior(behaviors, "click") || this.hasSubmittingBehavior(behaviors, "action");
            if (!hasSubmittingBehavior) {
                ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
            }
            Collection<ClientBehaviorContext.Parameter> paramList = HtmlRendererUtils.getClientBehaviorContextParameters(HtmlRendererUtils.mapAttachedParamsToStringValues(facesContext, component));
            onclick = HtmlRendererUtils.buildBehaviorChain(facesContext, component, "click", paramList, "action", paramList, behaviors, commandOnclick, hasSubmittingBehavior ? null : serverEventCode);
        }
        writer.startElement("a", component);
        writer.writeURIAttribute("href", "#", null);
        writer.writeAttribute("onclick", onclick, null);
    }

    private boolean hasSubmittingBehavior(Map<String, List<ClientBehavior>> clientBehaviors, String eventName) {
        block4: {
            List<ClientBehavior> eventBehaviors = clientBehaviors.get(eventName);
            if (eventBehaviors == null || eventBehaviors.isEmpty()) break block4;
            if (eventBehaviors instanceof RandomAccess) {
                int size = eventBehaviors.size();
                for (int i = 0; i < size; ++i) {
                    ClientBehavior behavior = eventBehaviors.get(i);
                    if (!behavior.getHints().contains((Object)ClientBehaviorHint.SUBMITTING)) continue;
                    return true;
                }
            } else {
                for (ClientBehavior behavior : eventBehaviors) {
                    if (!behavior.getHints().contains((Object)ClientBehaviorHint.SUBMITTING)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected String buildServerOnclick(FacesContext facesContext, UIComponent component, String clientId, FormInfo formInfo) throws IOException {
        UIComponent nestingForm = formInfo.getForm();
        String formName = formInfo.getFormName();
        StringBuilder onClick = new StringBuilder();
        if (RendererUtils.isAdfOrTrinidadForm(formInfo.getForm())) {
            onClick.append("submitForm('");
            onClick.append(formInfo.getForm().getClientId(facesContext));
            onClick.append("',1,{source:'");
            onClick.append(component.getClientId(facesContext));
            onClick.append("'});return false;");
        } else {
            HtmlRendererUtils.renderFormSubmitScript(facesContext);
            StringBuilder params = this.addChildParameters(facesContext, component, nestingForm);
            String target = this.getTarget(component);
            onClick.append("return ").append("myfaces.oam.submitForm").append("('").append(formName).append("','").append(clientId).append("'");
            if (params.length() > 2 || target != null) {
                onClick.append(",").append(target == null ? "null" : "'" + target + "'").append(",").append((CharSequence)params);
            }
            onClick.append(");");
        }
        return onClick.toString();
    }

    private String getTarget(UIComponent component) {
        String target = component instanceof HtmlCommandLink ? ((HtmlCommandLink)component).getTarget() : (String)component.getAttributes().get("target");
        return target;
    }

    private StringBuilder addChildParameters(FacesContext context, UIComponent component, UIComponent nestingForm) {
        StringBuilder params = new StringBuilder();
        params.append("[");
        List<UIComponent> childrenList = null;
        childrenList = this.getChildCount(component) > 0 ? this.getChildren(component) : Collections.emptyList();
        List<UIParameter> validParams = HtmlRendererUtils.getValidUIParameterChildren(context, childrenList, false, false);
        int size = validParams.size();
        for (int j = 0; j < size; ++j) {
            UIParameter param = validParams.get(j);
            String name = param.getName();
            if (MyfacesConfig.getCurrentInstance(context.getExternalContext()).isRenderHiddenFieldsForLinkParams()) {
                this.addHiddenCommandParameter(context, nestingForm, name);
            }
            Object value = param.getValue();
            String strParamValue = "";
            if (value != null) {
                strParamValue = value.toString();
                StringBuilder buff = null;
                for (int i = 0; i < strParamValue.length(); ++i) {
                    char c = strParamValue.charAt(i);
                    if (c == '\'' || c == '\\') {
                        if (buff == null) {
                            buff = new StringBuilder();
                            buff.append(strParamValue.substring(0, i));
                        }
                        buff.append('\\');
                        buff.append(c);
                        continue;
                    }
                    if (buff == null) continue;
                    buff.append(c);
                }
                if (buff != null) {
                    strParamValue = buff.toString();
                }
            }
            if (params.length() > 1) {
                params.append(",");
            }
            params.append("['");
            params.append(name);
            params.append("','");
            params.append(strParamValue);
            params.append("']");
        }
        params.append("]");
        return params;
    }

    protected FormInfo findNestingForm(UIComponent uiComponent, FacesContext facesContext) {
        return _ComponentUtils.findNestingForm(uiComponent, facesContext);
    }

    protected void addHiddenCommandParameter(FacesContext facesContext, UIComponent nestingForm, String hiddenFieldName) {
        if (nestingForm != null) {
            HtmlFormRendererBase.addHiddenCommandParameter(facesContext, nestingForm, hiddenFieldName);
        }
    }

    private void addChildParametersToHref(FacesContext facesContext, UIComponent linkComponent, StringBuilder hrefBuf, boolean firstParameter, String charEncoding) throws IOException {
        boolean strictXhtmlLinks = MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isStrictXhtmlLinks();
        List<UIComponent> childrenList = null;
        childrenList = this.getChildCount(linkComponent) > 0 ? this.getChildren(linkComponent) : Collections.emptyList();
        List<UIParameter> validParams = HtmlRendererUtils.getValidUIParameterChildren(facesContext, childrenList, false, false);
        int size = validParams.size();
        for (int i = 0; i < size; ++i) {
            UIParameter param = validParams.get(i);
            String name = param.getName();
            Object value = param.getValue();
            HtmlLinkRendererBase.addParameterToHref(name, value, hrefBuf, firstParameter, charEncoding, strictXhtmlLinks);
            firstParameter = false;
        }
    }

    protected void renderOutputLinkStart(FacesContext facesContext, UIOutput output) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Map<String, List<ClientBehavior>> behaviors = null;
        if (HtmlRendererUtils.isDisabled(output)) {
            writer.startElement("span", output);
            if (output instanceof ClientBehaviorHolder) {
                behaviors = ((ClientBehaviorHolder)((Object)output)).getClientBehaviors();
                if (!behaviors.isEmpty()) {
                    HtmlRendererUtils.writeIdAndName(writer, output, facesContext);
                } else {
                    HtmlRendererUtils.writeIdIfNecessary(writer, output, facesContext);
                }
                long commonPropertiesMarked = 0L;
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(output);
                }
                if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderEventProperties(writer, commonPropertiesMarked, output);
                    CommonPropertyUtils.renderFocusBlurEventProperties(writer, commonPropertiesMarked, output);
                } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                    Long commonEventsMarked = CommonEventUtils.getCommonEventsMarked(output);
                    CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, output, behaviors);
                    CommonEventUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, commonPropertiesMarked, commonEventsMarked, output, behaviors);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, output, behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, output, behaviors);
                }
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughPropertiesDisabledWithoutEvents(writer, commonPropertiesMarked, output);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_DISABLED_WITHOUT_EVENTS);
                }
            } else {
                HtmlRendererUtils.writeIdIfNecessary(writer, output, facesContext);
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughPropertiesDisabled(writer, CommonPropertyUtils.getCommonPropertiesMarked(output), output);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_DISABLED);
                }
            }
        } else {
            boolean isAnchorInHref;
            String href = RendererUtils.getStringValue(facesContext, output);
            int index = href.indexOf(35);
            String anchorString = null;
            boolean bl = isAnchorInHref = index > -1;
            if (isAnchorInHref) {
                anchorString = href.substring(index, href.length());
                href = href.substring(0, index);
            }
            if (this.getChildCount(output) > 0) {
                StringBuilder hrefBuf = new StringBuilder(href);
                this.addChildParametersToHref(facesContext, output, hrefBuf, href.indexOf(63) == -1, writer.getCharacterEncoding());
                href = hrefBuf.toString();
            }
            String fragmentAttr = null;
            fragmentAttr = output instanceof HtmlOutputLink ? ((HtmlOutputLink)output).getFragment() : (String)output.getAttributes().get("fragment");
            if (fragmentAttr != null && !"".equals(fragmentAttr)) {
                href = href + "#" + fragmentAttr;
            } else if (isAnchorInHref) {
                href = href + anchorString;
            }
            href = facesContext.getExternalContext().encodeResourceURL(href);
            writer.startElement("a", output);
            writer.writeURIAttribute("href", href, null);
            if (output instanceof ClientBehaviorHolder) {
                behaviors = ((ClientBehaviorHolder)((Object)output)).getClientBehaviors();
                if (!behaviors.isEmpty()) {
                    HtmlRendererUtils.writeIdAndName(writer, output, facesContext);
                } else {
                    HtmlRendererUtils.writeIdAndNameIfNecessary(writer, output, facesContext);
                }
                long commonPropertiesMarked = 0L;
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(output);
                }
                if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderEventProperties(writer, commonPropertiesMarked, output);
                    CommonPropertyUtils.renderFocusBlurEventProperties(writer, commonPropertiesMarked, output);
                } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                    Long commonEventsMarked = CommonEventUtils.getCommonEventsMarked(output);
                    CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, output, behaviors);
                    CommonEventUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, commonPropertiesMarked, commonEventsMarked, output, behaviors);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, output, behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, output, behaviors);
                }
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughPropertiesWithoutEvents(writer, commonPropertiesMarked, output);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS);
                }
            } else {
                HtmlRendererUtils.writeIdAndNameIfNecessary(writer, output, facesContext);
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughProperties(writer, CommonPropertyUtils.getCommonPropertiesMarked(output), output);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES);
                }
            }
            writer.flush();
        }
    }

    protected void renderOutcomeLinkStart(FacesContext facesContext, UIOutcomeTarget output) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Map<String, List<ClientBehavior>> behaviors = null;
        String targetHref = HtmlRendererUtils.getOutcomeTargetHref(facesContext, output);
        if (HtmlRendererUtils.isDisabled(output) || targetHref == null) {
            facesContext.getAttributes().put(END_LINK_OUTCOME_AS_SPAN, Boolean.TRUE);
            writer.startElement("span", output);
            if (output instanceof ClientBehaviorHolder) {
                behaviors = ((ClientBehaviorHolder)((Object)output)).getClientBehaviors();
                if (!behaviors.isEmpty()) {
                    HtmlRendererUtils.writeIdAndName(writer, output, facesContext);
                } else {
                    HtmlRendererUtils.writeIdIfNecessary(writer, output, facesContext);
                }
                long commonPropertiesMarked = 0L;
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(output);
                }
                if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderEventProperties(writer, commonPropertiesMarked, output);
                    CommonPropertyUtils.renderFocusBlurEventProperties(writer, commonPropertiesMarked, output);
                } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                    Long commonEventsMarked = CommonEventUtils.getCommonEventsMarked(output);
                    CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, output, behaviors);
                    CommonEventUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, commonPropertiesMarked, commonEventsMarked, output, behaviors);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, output, behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, output, behaviors);
                }
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughPropertiesDisabledWithoutEvents(writer, commonPropertiesMarked, output);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_DISABLED_WITHOUT_EVENTS);
                }
            } else {
                HtmlRendererUtils.writeIdIfNecessary(writer, output, facesContext);
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughPropertiesDisabled(writer, CommonPropertyUtils.getCommonPropertiesMarked(output), output);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_DISABLED);
                }
            }
            Object value = output.getValue();
            if (value != null) {
                writer.writeText(value.toString(), "value");
            }
        } else {
            writer.startElement("a", output);
            writer.writeURIAttribute("href", targetHref, null);
            if (output instanceof ClientBehaviorHolder) {
                behaviors = ((ClientBehaviorHolder)((Object)output)).getClientBehaviors();
                if (!behaviors.isEmpty()) {
                    HtmlRendererUtils.writeIdAndName(writer, output, facesContext);
                } else {
                    HtmlRendererUtils.writeIdAndNameIfNecessary(writer, output, facesContext);
                }
                long commonPropertiesMarked = 0L;
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(output);
                }
                if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderEventProperties(writer, commonPropertiesMarked, output);
                    CommonPropertyUtils.renderFocusBlurEventProperties(writer, commonPropertiesMarked, output);
                } else if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                    Long commonEventsMarked = CommonEventUtils.getCommonEventsMarked(output);
                    CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, output, behaviors);
                    CommonEventUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, commonPropertiesMarked, commonEventsMarked, output, behaviors);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, output, behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchangeAndOnselect(facesContext, writer, output, behaviors);
                }
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughPropertiesWithoutEvents(writer, commonPropertiesMarked, output);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES_WITHOUT_EVENTS);
                }
            } else {
                HtmlRendererUtils.writeIdAndNameIfNecessary(writer, output, facesContext);
                if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                    CommonPropertyUtils.renderAnchorPassthroughProperties(writer, CommonPropertyUtils.getCommonPropertiesMarked(output), output);
                } else {
                    HtmlRendererUtils.renderHTMLAttributes(writer, output, HTML.ANCHOR_PASSTHROUGH_ATTRIBUTES);
                }
            }
            writer.flush();
        }
    }

    private static void addParameterToHref(String name, Object value, StringBuilder hrefBuf, boolean firstParameter, String charEncoding, boolean strictXhtmlLinks) throws UnsupportedEncodingException {
        if (name == null) {
            throw new IllegalArgumentException("Unnamed parameter value not allowed within command link.");
        }
        if (firstParameter) {
            hrefBuf.append('?');
        } else if (strictXhtmlLinks) {
            hrefBuf.append("&amp;");
        } else {
            hrefBuf.append('&');
        }
        hrefBuf.append(URLEncoder.encode(name, charEncoding));
        hrefBuf.append('=');
        if (value != null) {
            hrefBuf.append(URLEncoder.encode(value.toString(), charEncoding));
        }
    }

    protected void renderOutcomeLinkEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (HtmlRendererUtils.isDisabled(component) || Boolean.TRUE.equals(facesContext.getAttributes().get(END_LINK_OUTCOME_AS_SPAN))) {
            writer.endElement("span");
            facesContext.getAttributes().put(END_LINK_OUTCOME_AS_SPAN, Boolean.FALSE);
        } else {
            writer.writeText(RendererUtils.getStringValue(facesContext, component), null);
            writer.endElement("a");
        }
    }

    protected void renderOutputLinkEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (HtmlRendererUtils.isDisabled(component)) {
            writer.endElement("span");
        } else {
            writer.writeText("", null);
            writer.endElement("a");
        }
    }

    protected void renderCommandLinkEnd(FacesContext facesContext, UIComponent component) throws IOException {
        FormInfo formInfo = this.findNestingForm(component, facesContext);
        ResponseWriter writer = facesContext.getResponseWriter();
        if (HtmlRendererUtils.isDisabled(component) || formInfo == null) {
            writer.endElement("span");
        } else {
            writer.writeText("", null);
            writer.endElement("a");
        }
    }
}

